/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import LogEntry from '../model/LogEntry';

/**
* LockLog service.
* @module api/LockLogApi
* @version OAS Version
*/
export default class LockLogApi {

    /**
    * Constructs a new LockLogApi. 
    * @alias module:api/LockLogApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the requestLockLogRecordsEventRange operation.
     * @callback module:api/LockLogApi~requestLockLogRecordsEventRangeCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/LogEntry>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Rerquest log records for specific event range
     * Rerquest log records for specific event range
     * @param {String} eventStartDate Event start date in ISO8601 format
     * @param {String} eventEndDate Event end date in ISO8601 format
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {module:api/LockLogApi~requestLockLogRecordsEventRangeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/LogEntry>}
     */
    requestLockLogRecordsEventRange(eventStartDate, eventEndDate, opts, callback) {
      opts = opts || {};
      let postBody = null;
      // verify the required parameter 'eventStartDate' is set
      if (eventStartDate === undefined || eventStartDate === null) {
        throw new Error("Missing the required parameter 'eventStartDate' when calling requestLockLogRecordsEventRange");
      }
      // verify the required parameter 'eventEndDate' is set
      if (eventEndDate === undefined || eventEndDate === null) {
        throw new Error("Missing the required parameter 'eventEndDate' when calling requestLockLogRecordsEventRange");
      }

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'eventStartDate': eventStartDate,
        'eventEndDate': eventEndDate
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [LogEntry];
      return this.apiClient.callApi(
        '/lock/audit/log/search', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
