/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import GluuLdapConfiguration from '../model/GluuLdapConfiguration';

/**
* DatabaseLDAPConfiguration service.
* @module api/DatabaseLDAPConfigurationApi
* @version OAS Version
*/
export default class DatabaseLDAPConfigurationApi {

    /**
    * Constructs a new DatabaseLDAPConfigurationApi. 
    * @alias module:api/DatabaseLDAPConfigurationApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteConfigDatabaseLdapByName operation.
     * @callback module:api/DatabaseLDAPConfigurationApi~deleteConfigDatabaseLdapByNameCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GluuLdapConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Deletes an LDAP configuration
     * Deletes an LDAP configuration
     * @param {String} name 
     * @param {module:api/DatabaseLDAPConfigurationApi~deleteConfigDatabaseLdapByNameCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GluuLdapConfiguration}
     */
    deleteConfigDatabaseLdapByName(name, callback) {
      let postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling deleteConfigDatabaseLdapByName");
      }

      let pathParams = {
        'name': name
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = GluuLdapConfiguration;
      return this.apiClient.callApi(
        '/api/v1/config/database/ldap/{name}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getConfigDatabaseLdap operation.
     * @callback module:api/DatabaseLDAPConfigurationApi~getConfigDatabaseLdapCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/GluuLdapConfiguration>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of existing LDAP configurations.
     * Gets list of existing LDAP configurations.
     * @param {module:api/DatabaseLDAPConfigurationApi~getConfigDatabaseLdapCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/GluuLdapConfiguration>}
     */
    getConfigDatabaseLdap(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [GluuLdapConfiguration];
      return this.apiClient.callApi(
        '/api/v1/config/database/ldap', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getConfigDatabaseLdapByName operation.
     * @callback module:api/DatabaseLDAPConfigurationApi~getConfigDatabaseLdapByNameCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GluuLdapConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets an LDAP configuration by name.
     * Gets an LDAP configuration by name.
     * @param {String} name Name of LDAP configuration
     * @param {module:api/DatabaseLDAPConfigurationApi~getConfigDatabaseLdapByNameCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GluuLdapConfiguration}
     */
    getConfigDatabaseLdapByName(name, callback) {
      let postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling getConfigDatabaseLdapByName");
      }

      let pathParams = {
        'name': name
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = GluuLdapConfiguration;
      return this.apiClient.callApi(
        '/api/v1/config/database/ldap/{name}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the patchConfigDatabaseLdapByName operation.
     * @callback module:api/DatabaseLDAPConfigurationApi~patchConfigDatabaseLdapByNameCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GluuLdapConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patches a LDAP configuration by name
     * Patches a LDAP configuration by name
     * @param {String} name Name of LDAP configuration
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody JsonPatch object
     * @param {module:api/DatabaseLDAPConfigurationApi~patchConfigDatabaseLdapByNameCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GluuLdapConfiguration}
     */
    patchConfigDatabaseLdapByName(name, opts, callback) {
      opts = opts || {};
      let postBody = opts['requestBody'];
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling patchConfigDatabaseLdapByName");
      }

      let pathParams = {
        'name': name
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json-patch+json'];
      let accepts = ['application/json'];
      let returnType = GluuLdapConfiguration;
      return this.apiClient.callApi(
        '/api/v1/config/database/ldap/{name}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postConfigDatabaseLdap operation.
     * @callback module:api/DatabaseLDAPConfigurationApi~postConfigDatabaseLdapCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GluuLdapConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Adds a new LDAP configuration
     * Adds a new LDAP configuration
     * @param {Object} opts Optional parameters
     * @param {module:model/GluuLdapConfiguration} opts.gluuLdapConfiguration GluuLdapConfiguration object
     * @param {module:api/DatabaseLDAPConfigurationApi~postConfigDatabaseLdapCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GluuLdapConfiguration}
     */
    postConfigDatabaseLdap(opts, callback) {
      opts = opts || {};
      let postBody = opts['gluuLdapConfiguration'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = GluuLdapConfiguration;
      return this.apiClient.callApi(
        '/api/v1/config/database/ldap', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postConfigDatabaseLdapTest operation.
     * @callback module:api/DatabaseLDAPConfigurationApi~postConfigDatabaseLdapTestCallback
     * @param {String} error Error message, if any.
     * @param {Boolean} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Tests an LDAP configuration
     * Tests an LDAP configuration
     * @param {Object} opts Optional parameters
     * @param {module:model/GluuLdapConfiguration} opts.gluuLdapConfiguration GluuLdapConfiguration object
     * @param {module:api/DatabaseLDAPConfigurationApi~postConfigDatabaseLdapTestCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Boolean}
     */
    postConfigDatabaseLdapTest(opts, callback) {
      opts = opts || {};
      let postBody = opts['gluuLdapConfiguration'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = 'Boolean';
      return this.apiClient.callApi(
        '/api/v1/config/database/ldap/test', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the putConfigDatabaseLdap operation.
     * @callback module:api/DatabaseLDAPConfigurationApi~putConfigDatabaseLdapCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GluuLdapConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Updates LDAP configuration
     * Updates LDAP configuration
     * @param {Object} opts Optional parameters
     * @param {module:model/GluuLdapConfiguration} opts.gluuLdapConfiguration GluuLdapConfiguration object
     * @param {module:api/DatabaseLDAPConfigurationApi~putConfigDatabaseLdapCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GluuLdapConfiguration}
     */
    putConfigDatabaseLdap(opts, callback) {
      opts = opts || {};
      let postBody = opts['gluuLdapConfiguration'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = GluuLdapConfiguration;
      return this.apiClient.callApi(
        '/api/v1/config/database/ldap', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
