/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import ApiError from '../model/ApiError';
import CustomUser from '../model/CustomUser';
import UserPagedResult from '../model/UserPagedResult';
import UserPatchRequest from '../model/UserPatchRequest';

/**
* ConfigurationUserManagement service.
* @module api/ConfigurationUserManagementApi
* @version OAS Version
*/
export default class ConfigurationUserManagementApi {

    /**
    * Constructs a new ConfigurationUserManagementApi. 
    * @alias module:api/ConfigurationUserManagementApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteUser operation.
     * @callback module:api/ConfigurationUserManagementApi~deleteUserCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete User
     * Delete User
     * @param {String} inum User identifier
     * @param {module:api/ConfigurationUserManagementApi~deleteUserCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteUser(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteUser");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/mgt/configuser/{inum}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getUser operation.
     * @callback module:api/ConfigurationUserManagementApi~getUserCallback
     * @param {String} error Error message, if any.
     * @param {module:model/UserPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of users
     * Gets list of users
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/ConfigurationUserManagementApi~getUserCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/UserPagedResult}
     */
    getUser(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = UserPagedResult;
      return this.apiClient.callApi(
        '/mgt/configuser', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getUserByInum operation.
     * @callback module:api/ConfigurationUserManagementApi~getUserByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomUser} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get User by Inum
     * Get User by Inum
     * @param {String} inum User identifier
     * @param {module:api/ConfigurationUserManagementApi~getUserByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomUser}
     */
    getUserByInum(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getUserByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = CustomUser;
      return this.apiClient.callApi(
        '/mgt/configuser/{inum}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the patchUserByInum operation.
     * @callback module:api/ConfigurationUserManagementApi~patchUserByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomUser} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patch user properties by Inum
     * Patch user properties by Inum
     * @param {String} inum User identifier
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.removeNonLDAPAttributes Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request. (default to true)
     * @param {module:model/UserPatchRequest} opts.userPatchRequest UserPatchRequest
     * @param {module:api/ConfigurationUserManagementApi~patchUserByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomUser}
     */
    patchUserByInum(inum, opts, callback) {
      opts = opts || {};
      let postBody = opts['userPatchRequest'];
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling patchUserByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
        'removeNonLDAPAttributes': opts['removeNonLDAPAttributes']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = CustomUser;
      return this.apiClient.callApi(
        '/mgt/configuser/{inum}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postUser operation.
     * @callback module:api/ConfigurationUserManagementApi~postUserCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomUser} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new User
     * Create new User
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.removeNonLDAPAttributes Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request. (default to true)
     * @param {module:model/CustomUser} opts.customUser User object
     * @param {module:api/ConfigurationUserManagementApi~postUserCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomUser}
     */
    postUser(opts, callback) {
      opts = opts || {};
      let postBody = opts['customUser'];

      let pathParams = {
      };
      let queryParams = {
        'removeNonLDAPAttributes': opts['removeNonLDAPAttributes']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = CustomUser;
      return this.apiClient.callApi(
        '/mgt/configuser', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the putUser operation.
     * @callback module:api/ConfigurationUserManagementApi~putUserCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomUser} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update User
     * Update User
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.removeNonLDAPAttributes Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request. (default to true)
     * @param {module:model/CustomUser} opts.customUser User object
     * @param {module:api/ConfigurationUserManagementApi~putUserCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomUser}
     */
    putUser(opts, callback) {
      opts = opts || {};
      let postBody = opts['customUser'];

      let pathParams = {
      };
      let queryParams = {
        'removeNonLDAPAttributes': opts['removeNonLDAPAttributes']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = CustomUser;
      return this.apiClient.callApi(
        '/mgt/configuser', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
