/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import Deployment from '../model/Deployment';
import PagedResult from '../model/PagedResult';

/**
* Agama service.
* @module api/AgamaApi
* @version OAS Version
*/
export default class AgamaApi {

    /**
    * Constructs a new AgamaApi. 
    * @alias module:api/AgamaApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteAgamaPrj operation.
     * @callback module:api/AgamaApi~deleteAgamaPrjCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete a deployed Agama project.
     * Delete a deployed Agama project.
     * @param {String} name Agama project name
     * @param {module:api/AgamaApi~deleteAgamaPrjCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteAgamaPrj(name, callback) {
      let postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling deleteAgamaPrj");
      }

      let pathParams = {
        'name': name
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/v1/agama-deployment/{name}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAgamaPrj operation.
     * @callback module:api/AgamaApi~getAgamaPrjCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieve the list of projects deployed currently.
     * Retrieve the list of projects deployed currently.
     * @param {Object} opts Optional parameters
     * @param {Number} opts.start Start index for the result
     * @param {Number} opts.count Search size - count of the results to return
     * @param {module:api/AgamaApi~getAgamaPrjCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
    getAgamaPrj(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'start': opts['start'],
        'count': opts['count']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = PagedResult;
      return this.apiClient.callApi(
        '/api/v1/agama-deployment', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAgamaPrjByName operation.
     * @callback module:api/AgamaApi~getAgamaPrjByNameCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Deployment} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetches deployed Agama project based on name.
     * Fetches deployed Agama project based on name.
     * @param {String} name Agama project name
     * @param {module:api/AgamaApi~getAgamaPrjByNameCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Deployment}
     */
    getAgamaPrjByName(name, callback) {
      let postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling getAgamaPrjByName");
      }

      let pathParams = {
        'name': name
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Deployment;
      return this.apiClient.callApi(
        '/api/v1/agama-deployment/{name}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAgamaPrjConfigs operation.
     * @callback module:api/AgamaApi~getAgamaPrjConfigsCallback
     * @param {String} error Error message, if any.
     * @param {String} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieve the list of configs based on name.
     * Retrieve the list of configs based on name.
     * @param {String} name Agama project name
     * @param {module:api/AgamaApi~getAgamaPrjConfigsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link String}
     */
    getAgamaPrjConfigs(name, callback) {
      let postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling getAgamaPrjConfigs");
      }

      let pathParams = {
        'name': name
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = 'String';
      return this.apiClient.callApi(
        '/api/v1/agama-deployment/configs/{name}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAgamaProject operation.
     * @callback module:api/AgamaApi~getAgamaProjectCallback
     * @param {String} error Error message, if any.
     * @param {File} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Download agama project.
     * Download agama project.
     * @param {Object} opts Optional parameters
     * @param {String} opts.downloadLink Agama project download Link
     * @param {module:api/AgamaApi~getAgamaProjectCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link File}
     */
    getAgamaProject(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'downloadLink': opts['downloadLink']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = File;
      return this.apiClient.callApi(
        '/api/v1/agama-repo/download', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAgamaRepositories operation.
     * @callback module:api/AgamaApi~getAgamaRepositoriesCallback
     * @param {String} error Error message, if any.
     * @param {Object} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets all agama repositories.
     * Gets all agama repositories.
     * @param {module:api/AgamaApi~getAgamaRepositoriesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Object}
     */
    getAgamaRepositories(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Object;
      return this.apiClient.callApi(
        '/api/v1/agama-repo', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postAgamaPrj operation.
     * @callback module:api/AgamaApi~postAgamaPrjCallback
     * @param {String} error Error message, if any.
     * @param {String} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Deploy an Agama project.
     * Deploy an Agama project.
     * @param {String} name Agama project name
     * @param {Object} opts Optional parameters
     * @param {String} opts.autoconfigure Boolean value to indicating to auto configure the project 
     * @param {Blob} opts.body Agama gama file
     * @param {module:api/AgamaApi~postAgamaPrjCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link String}
     */
    postAgamaPrj(name, opts, callback) {
      opts = opts || {};
      let postBody = opts['body'];
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling postAgamaPrj");
      }

      let pathParams = {
        'name': name
      };
      let queryParams = {
        'autoconfigure': opts['autoconfigure']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/zip'];
      let accepts = ['application/zip'];
      let returnType = 'String';
      return this.apiClient.callApi(
        '/api/v1/agama-deployment/{name}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the putAgamaPrj operation.
     * @callback module:api/AgamaApi~putAgamaPrjCallback
     * @param {String} error Error message, if any.
     * @param {String} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update an Agama project.
     * Update an Agama project.
     * @param {String} name Agama project name
     * @param {Object} opts Optional parameters
     * @param {Object.<String, {String: {String: Object}}>} opts.requestBody Agama flow config, key is `name` of config property and `value` is the property value. 
     * @param {module:api/AgamaApi~putAgamaPrjCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link String}
     */
    putAgamaPrj(name, opts, callback) {
      opts = opts || {};
      let postBody = opts['requestBody'];
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling putAgamaPrj");
      }

      let pathParams = {
        'name': name
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = 'String';
      return this.apiClient.callApi(
        '/api/v1/agama-deployment/configs/{name}', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
