# JansConfigApi.OrganizationConfigurationApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getOrganizationConfig**](OrganizationConfigurationApi.md#getOrganizationConfig) | **GET** /api/v1/org | Retrieves organization configuration
[**patchOrganizationConfig**](OrganizationConfigurationApi.md#patchOrganizationConfig) | **PATCH** /api/v1/org | Patch organization configuration



## getOrganizationConfig

> GluuOrganization getOrganizationConfig()

Retrieves organization configuration

Retrieves organization configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OrganizationConfigurationApi();
apiInstance.getOrganizationConfig((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GluuOrganization**](GluuOrganization.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchOrganizationConfig

> GluuOrganization patchOrganizationConfig(opts)

Patch organization configuration

Patch organization configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OrganizationConfigurationApi();
let opts = {
  'requestBody': [
    { "op": "add", "path": "/customMessages", "value": ["customMessages1","customMessages2"] },
    { "op": "add", "path": "/jsFaviconPath", "value": "/opt/jans/jetty/jans-auth/custom/static" }
] 
 // [Object] | String representing JsonPatch request.
};
apiInstance.patchOrganizationConfig(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing JsonPatch request. | [optional] 

### Return type

[**GluuOrganization**](GluuOrganization.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json

