# JansConfigApi.OAuthOpenIDConnectClientsApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteOauthOpenidClientByInum**](OAuthOpenIDConnectClientsApi.md#deleteOauthOpenidClientByInum) | **DELETE** /api/v1/openid/clients/{inum} | Delete OpenId Connect client
[**getOauthOpenidClients**](OAuthOpenIDConnectClientsApi.md#getOauthOpenidClients) | **GET** /api/v1/openid/clients | Gets list of OpenID Connect clients
[**getOauthOpenidClientsByInum**](OAuthOpenIDConnectClientsApi.md#getOauthOpenidClientsByInum) | **GET** /api/v1/openid/clients/{inum} | Get OpenId Connect Client by Inum
[**patchOauthOpenidClientByInum**](OAuthOpenIDConnectClientsApi.md#patchOauthOpenidClientByInum) | **PATCH** /api/v1/openid/clients/{inum} | Patch OpenId Connect client
[**postOauthOpenidClient**](OAuthOpenIDConnectClientsApi.md#postOauthOpenidClient) | **POST** /api/v1/openid/clients | Create new OpenId Connect client
[**putOauthOpenidClient**](OAuthOpenIDConnectClientsApi.md#putOauthOpenidClient) | **PUT** /api/v1/openid/clients | Update OpenId Connect client



## deleteOauthOpenidClientByInum

> deleteOauthOpenidClientByInum(inum)

Delete OpenId Connect client

Delete OpenId Connect client

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthOpenIDConnectClientsApi();
let inum = "inum_example"; // String | Client identifier
apiInstance.deleteOauthOpenidClientByInum(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Client identifier | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getOauthOpenidClients

> PagedResult getOauthOpenidClients(opts)

Gets list of OpenID Connect clients

Gets list of OpenID Connect clients

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthOpenIDConnectClientsApi();
let opts = {
  'limit': 50, // Number | Search size - max size of the results to return
  'pattern': "''", // String | Search pattern
  'startIndex': 0, // Number | The 1-based index of the first query result
  'sortBy': "'inum'", // String | Attribute whose value will be used to order the returned response
  'sortOrder': "'ascending'", // String | Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"
  'fieldValuePair': applicationType=web,persistClientAuthorizations=true // String | Field and value pair for seraching
};
apiInstance.getOauthOpenidClients(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]
 **pattern** | **String**| Search pattern | [optional] [default to &#39;&#39;]
 **startIndex** | **Number**| The 1-based index of the first query result | [optional] [default to 0]
 **sortBy** | **String**| Attribute whose value will be used to order the returned response | [optional] [default to &#39;inum&#39;]
 **sortOrder** | **String**| Order in which the sortBy param is applied. Allowed values are \&quot;ascending\&quot; and \&quot;descending\&quot; | [optional] [default to &#39;ascending&#39;]
 **fieldValuePair** | **String**| Field and value pair for seraching | [optional] [default to &#39;&#39;]

### Return type

[**PagedResult**](PagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getOauthOpenidClientsByInum

> Client getOauthOpenidClientsByInum(inum)

Get OpenId Connect Client by Inum

Get OpenId Connect Client by Inum

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthOpenIDConnectClientsApi();
let inum = "inum_example"; // String | Client identifier
apiInstance.getOauthOpenidClientsByInum(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Client identifier | 

### Return type

[**Client**](Client.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchOauthOpenidClientByInum

> Client patchOauthOpenidClientByInum(inum, opts)

Patch OpenId Connect client

Patch OpenId Connect client

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthOpenIDConnectClientsApi();
let inum = "inum_example"; // String | Client identifier
let opts = {
  'requestBody': [{ "op": "replace", "path": "/responseTypes", "value":["code","token"]}] 
 // [Object] | String representing patch-document.
};
apiInstance.patchOauthOpenidClientByInum(inum, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Client identifier | 
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**Client**](Client.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## postOauthOpenidClient

> Client postOauthOpenidClient(opts)

Create new OpenId Connect client

Create new OpenId Connect client

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthOpenIDConnectClientsApi();
let opts = {
  'client': {
    "deletable": false,
    "clientSecret": "test1234",
    "frontChannelLogoutSessionRequired": false,
    "redirectUris": [
        "https://jans.server2/admin-ui",
        "http://localhost:4100"
    ],
    "responseTypes": [
        "code"
    ],
    "grantTypes": [
        "authorization_code",
        "refresh_token",
        "client_credentials"
    ],
    "applicationType": "web",
    "clientName": "",
    "logoUri": "",
    "clientUri": "",
    "policyUri":"",
    "tosUri": "",
    "subjectType": "pairwise",
    "idTokenSignedResponseAlg": "RS256",
    "tokenEndpointAuthMethod": "client_secret_basic",
    "scopes": [
        "inum=C4F7,ou=scopes,o=jans"
    ],
    "trustedClient": false,
    "persistClientAuthorizations": true,
    "includeClaimsInIdToken": false,
    "customAttributes": [
        {
            "name": "displayName",
            "multiValued": false,
            "values": [
                "Api Client"
            ],
            "value": "Api Client",
            "displayValue": "Api Client"
        }
    ],
    "customObjectClasses": [
        "top"
    ],
    "rptAsJwt": false,
    "accessTokenAsJwt": false,
    "accessTokenSigningAlg": "RS256",
    "disabled": false,
    "attributes": {
        "runIntrospectionScriptBeforeJwtCreation": false,
        "keepClientAuthorizationAfterExpiration": false,
        "allowSpontaneousScopes": false,
        "backchannelLogoutSessionRequired": false,
        "parLifetime": 600,
        "requirePar": false,
        "jansDefaultPromptLogin": false
    },
    "tokenBindingSupported": false,
    "authenticationMethod": "client_secret_basic",
    "displayName": "Api Client"
}
 // Client | OpenID Connect Client object
};
apiInstance.postOauthOpenidClient(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **client** | [**Client**](Client.md)| OpenID Connect Client object | [optional] 

### Return type

[**Client**](Client.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## putOauthOpenidClient

> Client putOauthOpenidClient(opts)

Update OpenId Connect client

Update OpenId Connect client

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthOpenIDConnectClientsApi();
let opts = {
  'client': {
    "dn": "inum=f8c1a111-0919-47e8-a4d4-f7c18f73a644,ou=clients,o=jans",
    "baseDn": "inum=f8c1a111-0919-47e8-a4d4-f7c18f73a644,ou=clients,o=jans",
    "inum": "f8c1a111-0919-47e8-a4d4-f7c18f73a644",
    "deletable": false,
    "clientSecret": "test1234",
    "frontChannelLogoutSessionRequired": false,
    "redirectUris": [
        "https://jans.server2/admin-ui",
        "http://localhost:4100"
    ],
    "responseTypes": [
        "code"
    ],
    "grantTypes": [
        "authorization_code",
        "refresh_token",
        "client_credentials"
    ],
    "applicationType": "web",
    "clientName": "",
    "logoUri": "",
    "clientUri": "",
    "policyUri":"",
    "tosUri": "",
    "subjectType": "pairwise",
    "idTokenSignedResponseAlg": "RS256",
    "tokenEndpointAuthMethod": "client_secret_basic",
    "scopes": [
        "inum=C4F7,ou=scopes,o=jans"
    ],
    "trustedClient": false,
    "persistClientAuthorizations": true,
    "includeClaimsInIdToken": false,
    "customAttributes": [
        {
            "name": "displayName",
            "multiValued": false,
            "values": [
                "Api Client"
            ],
            "value": "Api Client",
            "displayValue": "Api Client"
        }
    ],
    "customObjectClasses": [
        "top"
    ],
    "rptAsJwt": false,
    "accessTokenAsJwt": false,
    "accessTokenSigningAlg": "RS256",
    "disabled": false,
    "attributes": {
        "runIntrospectionScriptBeforeJwtCreation": false,
        "keepClientAuthorizationAfterExpiration": false,
        "allowSpontaneousScopes": false,
        "backchannelLogoutSessionRequired": false,
        "parLifetime": 600,
        "requirePar": false,
        "jansDefaultPromptLogin": false
    },
    "tokenBindingSupported": false,
    "authenticationMethod": "client_secret_basic",
    "displayName": "Api Client"
}
 // Client | OpenID Connect Client object
};
apiInstance.putOauthOpenidClient(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **client** | [**Client**](Client.md)| OpenID Connect Client object | [optional] 

### Return type

[**Client**](Client.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

