# JansConfigApi.MessageConfigurationPostgresApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getConfigMessagePostgres**](MessageConfigurationPostgresApi.md#getConfigMessagePostgres) | **GET** /api/v1/config/message/postgres | Returns Postgres message configuration.
[**patchConfigMessagePostgres**](MessageConfigurationPostgresApi.md#patchConfigMessagePostgres) | **PATCH** /api/v1/config/message/postgres | Patch Postgres message configuration.
[**putConfigMessagePostgres**](MessageConfigurationPostgresApi.md#putConfigMessagePostgres) | **PUT** /api/v1/config/message/postgres | Updates Postgres message configuration.



## getConfigMessagePostgres

> PostgresMessageConfiguration getConfigMessagePostgres()

Returns Postgres message configuration.

Returns Postgres message configuration.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.MessageConfigurationPostgresApi();
apiInstance.getConfigMessagePostgres((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**PostgresMessageConfiguration**](PostgresMessageConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchConfigMessagePostgres

> PostgresMessageConfiguration patchConfigMessagePostgres(opts)

Patch Postgres message configuration.

Patch Postgres message configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.MessageConfigurationPostgresApi();
let opts = {
  'requestBody':  // [Object] | String representing patch-document.
};
apiInstance.patchConfigMessagePostgres(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**PostgresMessageConfiguration**](PostgresMessageConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## putConfigMessagePostgres

> PostgresMessageConfiguration putConfigMessagePostgres(opts)

Updates Postgres message configuration.

Updates Postgres message configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.MessageConfigurationPostgresApi();
let opts = {
  'postgresMessageConfiguration':  // PostgresMessageConfiguration | PostgresMessageConfiguration object
};
apiInstance.putConfigMessagePostgres(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **postgresMessageConfiguration** | [**PostgresMessageConfiguration**](PostgresMessageConfiguration.md)| PostgresMessageConfiguration object | [optional] 

### Return type

[**PostgresMessageConfiguration**](PostgresMessageConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

