# JansConfigApi.LockAuditApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**bulkSaveHealthData**](LockAuditApi.md#bulkSaveHealthData) | **POST** /lock/audit/health/bulk | Bulk save health data
[**bulkSaveLogData**](LockAuditApi.md#bulkSaveLogData) | **POST** /lock/audit/log/bulk | Bulk save log data
[**bulkSaveTelemetryData**](LockAuditApi.md#bulkSaveTelemetryData) | **POST** /lock/audit/telemetry/bulk | Bulk save telemetry data
[**requestLockHealthRecordsEventRange**](LockAuditApi.md#requestLockHealthRecordsEventRange) | **GET** /lock/audit/health/search | Rerquest health records for specific event range
[**requestLockTelemetryRecordsEventRange**](LockAuditApi.md#requestLockTelemetryRecordsEventRange) | **GET** /lock/audit/telemetry/search | Request telemetry records for specific event range
[**saveHealthData**](LockAuditApi.md#saveHealthData) | **POST** /lock/audit/health | Save health data
[**saveLogData**](LockAuditApi.md#saveLogData) | **POST** /lock/audit/log | Save log data
[**saveTelemetryData**](LockAuditApi.md#saveTelemetryData) | **POST** /lock/audit/telemetry | Save telemetry data



## bulkSaveHealthData

> bulkSaveHealthData(opts)

Bulk save health data

Bulk save health data

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.LockAuditApi();
let opts = {
  'healthEntry': [new JansConfigApi.HealthEntry()] // [HealthEntry] | 
};
apiInstance.bulkSaveHealthData(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **healthEntry** | [**[HealthEntry]**](HealthEntry.md)|  | [optional] 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## bulkSaveLogData

> bulkSaveLogData(opts)

Bulk save log data

Bulk save log data

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.LockAuditApi();
let opts = {
  'logEntry': [new JansConfigApi.LogEntry()] // [LogEntry] | 
};
apiInstance.bulkSaveLogData(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **logEntry** | [**[LogEntry]**](LogEntry.md)|  | [optional] 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## bulkSaveTelemetryData

> bulkSaveTelemetryData(opts)

Bulk save telemetry data

Bulk save telemetry data

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.LockAuditApi();
let opts = {
  'telemetryEntry': [new JansConfigApi.TelemetryEntry()] // [TelemetryEntry] | 
};
apiInstance.bulkSaveTelemetryData(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **telemetryEntry** | [**[TelemetryEntry]**](TelemetryEntry.md)|  | [optional] 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## requestLockHealthRecordsEventRange

> [HealthEntry] requestLockHealthRecordsEventRange(eventStartDate, eventEndDate, opts)

Rerquest health records for specific event range

Rerquest health records for specific event range

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.LockAuditApi();
let eventStartDate = "eventStartDate_example"; // String | Event start date in ISO8601 format
let eventEndDate = "eventEndDate_example"; // String | Event end date in ISO8601 format
let opts = {
  'limit': 50 // Number | Search size - max size of the results to return
};
apiInstance.requestLockHealthRecordsEventRange(eventStartDate, eventEndDate, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **eventStartDate** | **String**| Event start date in ISO8601 format | 
 **eventEndDate** | **String**| Event end date in ISO8601 format | 
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]

### Return type

[**[HealthEntry]**](HealthEntry.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## requestLockTelemetryRecordsEventRange

> [TelemetryEntry] requestLockTelemetryRecordsEventRange(eventStartDate, eventEndDate, opts)

Request telemetry records for specific event range

Rerquest telemetry records for specific event range

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.LockAuditApi();
let eventStartDate = "eventStartDate_example"; // String | Event start date in ISO8601 format
let eventEndDate = "eventEndDate_example"; // String | Event end date in ISO8601 format
let opts = {
  'limit': 50 // Number | Search size - max size of the results to return
};
apiInstance.requestLockTelemetryRecordsEventRange(eventStartDate, eventEndDate, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **eventStartDate** | **String**| Event start date in ISO8601 format | 
 **eventEndDate** | **String**| Event end date in ISO8601 format | 
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]

### Return type

[**[TelemetryEntry]**](TelemetryEntry.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## saveHealthData

> saveHealthData(opts)

Save health data

Save health data

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.LockAuditApi();
let opts = {
  'healthEntry': new JansConfigApi.HealthEntry() // HealthEntry | 
};
apiInstance.saveHealthData(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **healthEntry** | [**HealthEntry**](HealthEntry.md)|  | [optional] 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## saveLogData

> saveLogData(opts)

Save log data

Save log data

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.LockAuditApi();
let opts = {
  'logEntry': new JansConfigApi.LogEntry() // LogEntry | 
};
apiInstance.saveLogData(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **logEntry** | [**LogEntry**](LogEntry.md)|  | [optional] 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## saveTelemetryData

> saveTelemetryData(opts)

Save telemetry data

Save telemetry data

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.LockAuditApi();
let opts = {
  'telemetryEntry': new JansConfigApi.TelemetryEntry() // TelemetryEntry | 
};
apiInstance.saveTelemetryData(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **telemetryEntry** | [**TelemetryEntry**](TelemetryEntry.md)|  | [optional] 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

