# JansConfigApi.CacheConfigurationMemcachedApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getConfigCacheMemcached**](CacheConfigurationMemcachedApi.md#getConfigCacheMemcached) | **GET** /api/v1/config/cache/memcached | Returns memcached cache configuration.
[**patchConfigCacheMemcached**](CacheConfigurationMemcachedApi.md#patchConfigCacheMemcached) | **PATCH** /api/v1/config/cache/memcached | Patch memcached cache configuration.
[**putConfigCacheMemcached**](CacheConfigurationMemcachedApi.md#putConfigCacheMemcached) | **PUT** /api/v1/config/cache/memcached | Updates memcached cache configuration.



## getConfigCacheMemcached

> MemcachedConfiguration getConfigCacheMemcached()

Returns memcached cache configuration.

Returns memcached cache configuration.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationMemcachedApi();
apiInstance.getConfigCacheMemcached((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**MemcachedConfiguration**](MemcachedConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchConfigCacheMemcached

> MemcachedConfiguration patchConfigCacheMemcached(opts)

Patch memcached cache configuration.

Patch memcached cache configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationMemcachedApi();
let opts = {
  'requestBody': [{ "op": "replace", "path": "/maxOperationQueueLength", "value":10001}] 
 // [Object] | String representing patch-document.
};
apiInstance.patchConfigCacheMemcached(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**MemcachedConfiguration**](MemcachedConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## putConfigCacheMemcached

> MemcachedConfiguration putConfigCacheMemcached(opts)

Updates memcached cache configuration.

Updates memcached cache configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationMemcachedApi();
let opts = {
  'memcachedConfiguration': {
    "servers": "localhost:11211",
    "maxOperationQueueLength": 100000,
    "bufferSize": 32768,
    "defaultPutExpiration": 80,
    "connectionFactoryType": "DEFAULT"
}
 // MemcachedConfiguration | Memcached Configuration object
};
apiInstance.putConfigCacheMemcached(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **memcachedConfiguration** | [**MemcachedConfiguration**](MemcachedConfiguration.md)| Memcached Configuration object | [optional] 

### Return type

[**MemcachedConfiguration**](MemcachedConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

