"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _ScriptError = _interopRequireDefault(require("./ScriptError"));
var _SimpleCustomProperty = _interopRequireDefault(require("./SimpleCustomProperty"));
var _SimpleExtendedCustomProperty = _interopRequireDefault(require("./SimpleExtendedCustomProperty"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
 * The CustomScript model module.
 * @module model/CustomScript
 * @version OAS Version
 */
var CustomScript = /*#__PURE__*/function () {
  /**
   * Constructs a new <code>CustomScript</code>.
   * @alias module:model/CustomScript
   */
  function CustomScript() {
    _classCallCheck(this, CustomScript);
    CustomScript.initialize(this);
  }

  /**
   * Initializes the fields of this object.
   * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
   * Only for internal use.
   */
  return _createClass(CustomScript, null, [{
    key: "initialize",
    value: function initialize(obj) {}

    /**
     * Constructs a <code>CustomScript</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CustomScript} obj Optional instance to populate.
     * @return {module:model/CustomScript} The populated <code>CustomScript</code> instance.
     */
  }, {
    key: "constructFromObject",
    value: function constructFromObject(data, obj) {
      if (data) {
        obj = obj || new CustomScript();
        if (data.hasOwnProperty('dn')) {
          obj['dn'] = _ApiClient["default"].convertToType(data['dn'], 'String');
        }
        if (data.hasOwnProperty('inum')) {
          obj['inum'] = _ApiClient["default"].convertToType(data['inum'], 'String');
        }
        if (data.hasOwnProperty('name')) {
          obj['name'] = _ApiClient["default"].convertToType(data['name'], 'String');
        }
        if (data.hasOwnProperty('aliases')) {
          obj['aliases'] = _ApiClient["default"].convertToType(data['aliases'], ['String']);
        }
        if (data.hasOwnProperty('description')) {
          obj['description'] = _ApiClient["default"].convertToType(data['description'], 'String');
        }
        if (data.hasOwnProperty('script')) {
          obj['script'] = _ApiClient["default"].convertToType(data['script'], 'String');
        }
        if (data.hasOwnProperty('scriptType')) {
          obj['scriptType'] = _ApiClient["default"].convertToType(data['scriptType'], 'String');
        }
        if (data.hasOwnProperty('programmingLanguage')) {
          obj['programmingLanguage'] = _ApiClient["default"].convertToType(data['programmingLanguage'], 'String');
        }
        if (data.hasOwnProperty('moduleProperties')) {
          obj['moduleProperties'] = _ApiClient["default"].convertToType(data['moduleProperties'], [_SimpleCustomProperty["default"]]);
        }
        if (data.hasOwnProperty('configurationProperties')) {
          obj['configurationProperties'] = _ApiClient["default"].convertToType(data['configurationProperties'], [_SimpleExtendedCustomProperty["default"]]);
        }
        if (data.hasOwnProperty('level')) {
          obj['level'] = _ApiClient["default"].convertToType(data['level'], 'Number');
        }
        if (data.hasOwnProperty('revision')) {
          obj['revision'] = _ApiClient["default"].convertToType(data['revision'], 'Number');
        }
        if (data.hasOwnProperty('enabled')) {
          obj['enabled'] = _ApiClient["default"].convertToType(data['enabled'], 'Boolean');
        }
        if (data.hasOwnProperty('scriptError')) {
          obj['scriptError'] = _ScriptError["default"].constructFromObject(data['scriptError']);
        }
        if (data.hasOwnProperty('modified')) {
          obj['modified'] = _ApiClient["default"].convertToType(data['modified'], 'Boolean');
        }
        if (data.hasOwnProperty('internal')) {
          obj['internal'] = _ApiClient["default"].convertToType(data['internal'], 'Boolean');
        }
        if (data.hasOwnProperty('locationType')) {
          obj['locationType'] = _ApiClient["default"].convertToType(data['locationType'], 'String');
        }
        if (data.hasOwnProperty('locationPath')) {
          obj['locationPath'] = _ApiClient["default"].convertToType(data['locationPath'], 'String');
        }
        if (data.hasOwnProperty('baseDn')) {
          obj['baseDn'] = _ApiClient["default"].convertToType(data['baseDn'], 'String');
        }
      }
      return obj;
    }
  }]);
}();
/**
 * @member {String} dn
 */
CustomScript.prototype['dn'] = undefined;

/**
 * @member {String} inum
 */
CustomScript.prototype['inum'] = undefined;

/**
 * @member {String} name
 */
CustomScript.prototype['name'] = undefined;

/**
 * @member {Array.<String>} aliases
 */
CustomScript.prototype['aliases'] = undefined;

/**
 * @member {String} description
 */
CustomScript.prototype['description'] = undefined;

/**
 * @member {String} script
 */
CustomScript.prototype['script'] = undefined;

/**
 * @member {module:model/CustomScript.ScriptTypeEnum} scriptType
 */
CustomScript.prototype['scriptType'] = undefined;

/**
 * @member {module:model/CustomScript.ProgrammingLanguageEnum} programmingLanguage
 */
CustomScript.prototype['programmingLanguage'] = undefined;

/**
 * @member {Array.<module:model/SimpleCustomProperty>} moduleProperties
 */
CustomScript.prototype['moduleProperties'] = undefined;

/**
 * @member {Array.<module:model/SimpleExtendedCustomProperty>} configurationProperties
 */
CustomScript.prototype['configurationProperties'] = undefined;

/**
 * @member {Number} level
 */
CustomScript.prototype['level'] = undefined;

/**
 * @member {Number} revision
 */
CustomScript.prototype['revision'] = undefined;

/**
 * @member {Boolean} enabled
 */
CustomScript.prototype['enabled'] = undefined;

/**
 * @member {module:model/ScriptError} scriptError
 */
CustomScript.prototype['scriptError'] = undefined;

/**
 * @member {Boolean} modified
 */
CustomScript.prototype['modified'] = undefined;

/**
 * @member {Boolean} internal
 */
CustomScript.prototype['internal'] = undefined;

/**
 * @member {module:model/CustomScript.LocationTypeEnum} locationType
 */
CustomScript.prototype['locationType'] = undefined;

/**
 * @member {String} locationPath
 */
CustomScript.prototype['locationPath'] = undefined;

/**
 * @member {String} baseDn
 */
CustomScript.prototype['baseDn'] = undefined;

/**
 * Allowed values for the <code>scriptType</code> property.
 * @enum {String}
 * @readonly
 */
CustomScript['ScriptTypeEnum'] = {
  /**
   * value: "person_authentication"
   * @const
   */
  "person_authentication": "person_authentication",
  /**
   * value: "authorization_challenge"
   * @const
   */
  "authorization_challenge": "authorization_challenge",
  /**
   * value: "introspection"
   * @const
   */
  "introspection": "introspection",
  /**
   * value: "resource_owner_password_credentials"
   * @const
   */
  "resource_owner_password_credentials": "resource_owner_password_credentials",
  /**
   * value: "application_session"
   * @const
   */
  "application_session": "application_session",
  /**
   * value: "link_interception"
   * @const
   */
  "link_interception": "link_interception",
  /**
   * value: "client_registration"
   * @const
   */
  "client_registration": "client_registration",
  /**
   * value: "id_generator"
   * @const
   */
  "id_generator": "id_generator",
  /**
   * value: "uma_rpt_policy"
   * @const
   */
  "uma_rpt_policy": "uma_rpt_policy",
  /**
   * value: "uma_rpt_claims"
   * @const
   */
  "uma_rpt_claims": "uma_rpt_claims",
  /**
   * value: "uma_claims_gathering"
   * @const
   */
  "uma_claims_gathering": "uma_claims_gathering",
  /**
   * value: "access_evaluation"
   * @const
   */
  "access_evaluation": "access_evaluation",
  /**
   * value: "access_evaluation_discovery"
   * @const
   */
  "access_evaluation_discovery": "access_evaluation_discovery",
  /**
   * value: "token_exchange"
   * @const
   */
  "token_exchange": "token_exchange",
  /**
   * value: "consent_gathering"
   * @const
   */
  "consent_gathering": "consent_gathering",
  /**
   * value: "dynamic_scope"
   * @const
   */
  "dynamic_scope": "dynamic_scope",
  /**
   * value: "spontaneous_scope"
   * @const
   */
  "spontaneous_scope": "spontaneous_scope",
  /**
   * value: "end_session"
   * @const
   */
  "end_session": "end_session",
  /**
   * value: "post_authn"
   * @const
   */
  "post_authn": "post_authn",
  /**
   * value: "client_authn"
   * @const
   */
  "client_authn": "client_authn",
  /**
   * value: "select_account"
   * @const
   */
  "select_account": "select_account",
  /**
   * value: "create_user"
   * @const
   */
  "create_user": "create_user",
  /**
   * value: "scim"
   * @const
   */
  "scim": "scim",
  /**
   * value: "ciba_end_user_notification"
   * @const
   */
  "ciba_end_user_notification": "ciba_end_user_notification",
  /**
   * value: "revoke_token"
   * @const
   */
  "revoke_token": "revoke_token",
  /**
   * value: "persistence_extension"
   * @const
   */
  "persistence_extension": "persistence_extension",
  /**
   * value: "idp"
   * @const
   */
  "idp": "idp",
  /**
   * value: "discovery"
   * @const
   */
  "discovery": "discovery",
  /**
   * value: "cookie"
   * @const
   */
  "cookie": "cookie",
  /**
   * value: "health_check"
   * @const
   */
  "health_check": "health_check",
  /**
   * value: "authz_detail"
   * @const
   */
  "authz_detail": "authz_detail",
  /**
   * value: "update_token"
   * @const
   */
  "update_token": "update_token",
  /**
   * value: "logout_status_jwt"
   * @const
   */
  "logout_status_jwt": "logout_status_jwt",
  /**
   * value: "config_api_auth"
   * @const
   */
  "config_api_auth": "config_api_auth",
  /**
   * value: "modify_ssa_response"
   * @const
   */
  "modify_ssa_response": "modify_ssa_response",
  /**
   * value: "fido2_extension"
   * @const
   */
  "fido2_extension": "fido2_extension",
  /**
   * value: "lock_extension"
   * @const
   */
  "lock_extension": "lock_extension"
};

/**
 * Allowed values for the <code>programmingLanguage</code> property.
 * @enum {String}
 * @readonly
 */
CustomScript['ProgrammingLanguageEnum'] = {
  /**
   * value: "python"
   * @const
   */
  "python": "python",
  /**
   * value: "java"
   * @const
   */
  "java": "java"
};

/**
 * Allowed values for the <code>locationType</code> property.
 * @enum {String}
 * @readonly
 */
CustomScript['LocationTypeEnum'] = {
  /**
   * value: "ldap"
   * @const
   */
  "ldap": "ldap",
  /**
   * value: "db"
   * @const
   */
  "db": "db",
  /**
   * value: "file"
   * @const
   */
  "file": "file"
};
var _default = exports["default"] = CustomScript;