"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _LogEntry = _interopRequireDefault(require("../model/LogEntry"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* LockLog service.
* @module api/LockLogApi
* @version OAS Version
*/
var LockLogApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new LockLogApi. 
  * @alias module:api/LockLogApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function LockLogApi(apiClient) {
    _classCallCheck(this, LockLogApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the requestLockLogRecordsEventRange operation.
   * @callback module:api/LockLogApi~requestLockLogRecordsEventRangeCallback
   * @param {String} error Error message, if any.
   * @param {Array.<module:model/LogEntry>} data The data returned by the service call.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Rerquest log records for specific event range
   * Rerquest log records for specific event range
   * @param {String} eventStartDate Event start date in ISO8601 format
   * @param {String} eventEndDate Event end date in ISO8601 format
   * @param {Object} opts Optional parameters
   * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
   * @param {module:api/LockLogApi~requestLockLogRecordsEventRangeCallback} callback The callback function, accepting three arguments: error, data, response
   * data is of type: {@link Array.<module:model/LogEntry>}
   */
  return _createClass(LockLogApi, [{
    key: "requestLockLogRecordsEventRange",
    value: function requestLockLogRecordsEventRange(eventStartDate, eventEndDate, opts, callback) {
      opts = opts || {};
      var postBody = null;
      // verify the required parameter 'eventStartDate' is set
      if (eventStartDate === undefined || eventStartDate === null) {
        throw new Error("Missing the required parameter 'eventStartDate' when calling requestLockLogRecordsEventRange");
      }
      // verify the required parameter 'eventEndDate' is set
      if (eventEndDate === undefined || eventEndDate === null) {
        throw new Error("Missing the required parameter 'eventEndDate' when calling requestLockLogRecordsEventRange");
      }
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'eventStartDate': eventStartDate,
        'eventEndDate': eventEndDate
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_LogEntry["default"]];
      return this.apiClient.callApi('/lock/audit/log/search', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();