"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _ApiError = _interopRequireDefault(require("../model/ApiError"));
var _HealthEntry = _interopRequireDefault(require("../model/HealthEntry"));
var _LogEntry = _interopRequireDefault(require("../model/LogEntry"));
var _TelemetryEntry = _interopRequireDefault(require("../model/TelemetryEntry"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* LockAudit service.
* @module api/LockAuditApi
* @version OAS Version
*/
var LockAuditApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new LockAuditApi. 
  * @alias module:api/LockAuditApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function LockAuditApi(apiClient) {
    _classCallCheck(this, LockAuditApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the bulkSaveHealthData operation.
   * @callback module:api/LockAuditApi~bulkSaveHealthDataCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Bulk save health data
   * Bulk save health data
   * @param {Object} opts Optional parameters
   * @param {Array.<module:model/HealthEntry>} opts.healthEntry 
   * @param {module:api/LockAuditApi~bulkSaveHealthDataCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(LockAuditApi, [{
    key: "bulkSaveHealthData",
    value: function bulkSaveHealthData(opts, callback) {
      opts = opts || {};
      var postBody = opts['healthEntry'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;
      return this.apiClient.callApi('/lock/audit/health/bulk', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the bulkSaveLogData operation.
     * @callback module:api/LockAuditApi~bulkSaveLogDataCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Bulk save log data
     * Bulk save log data
     * @param {Object} opts Optional parameters
     * @param {Array.<module:model/LogEntry>} opts.logEntry 
     * @param {module:api/LockAuditApi~bulkSaveLogDataCallback} callback The callback function, accepting three arguments: error, data, response
     */
  }, {
    key: "bulkSaveLogData",
    value: function bulkSaveLogData(opts, callback) {
      opts = opts || {};
      var postBody = opts['logEntry'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;
      return this.apiClient.callApi('/lock/audit/log/bulk', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the bulkSaveTelemetryData operation.
     * @callback module:api/LockAuditApi~bulkSaveTelemetryDataCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Bulk save telemetry data
     * Bulk save telemetry data
     * @param {Object} opts Optional parameters
     * @param {Array.<module:model/TelemetryEntry>} opts.telemetryEntry 
     * @param {module:api/LockAuditApi~bulkSaveTelemetryDataCallback} callback The callback function, accepting three arguments: error, data, response
     */
  }, {
    key: "bulkSaveTelemetryData",
    value: function bulkSaveTelemetryData(opts, callback) {
      opts = opts || {};
      var postBody = opts['telemetryEntry'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;
      return this.apiClient.callApi('/lock/audit/telemetry/bulk', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the requestLockHealthRecordsEventRange operation.
     * @callback module:api/LockAuditApi~requestLockHealthRecordsEventRangeCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/HealthEntry>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Rerquest health records for specific event range
     * Rerquest health records for specific event range
     * @param {String} eventStartDate Event start date in ISO8601 format
     * @param {String} eventEndDate Event end date in ISO8601 format
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {module:api/LockAuditApi~requestLockHealthRecordsEventRangeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/HealthEntry>}
     */
  }, {
    key: "requestLockHealthRecordsEventRange",
    value: function requestLockHealthRecordsEventRange(eventStartDate, eventEndDate, opts, callback) {
      opts = opts || {};
      var postBody = null;
      // verify the required parameter 'eventStartDate' is set
      if (eventStartDate === undefined || eventStartDate === null) {
        throw new Error("Missing the required parameter 'eventStartDate' when calling requestLockHealthRecordsEventRange");
      }
      // verify the required parameter 'eventEndDate' is set
      if (eventEndDate === undefined || eventEndDate === null) {
        throw new Error("Missing the required parameter 'eventEndDate' when calling requestLockHealthRecordsEventRange");
      }
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'eventStartDate': eventStartDate,
        'eventEndDate': eventEndDate
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_HealthEntry["default"]];
      return this.apiClient.callApi('/lock/audit/health/search', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the requestLockTelemetryRecordsEventRange operation.
     * @callback module:api/LockAuditApi~requestLockTelemetryRecordsEventRangeCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/TelemetryEntry>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Request telemetry records for specific event range
     * Rerquest telemetry records for specific event range
     * @param {String} eventStartDate Event start date in ISO8601 format
     * @param {String} eventEndDate Event end date in ISO8601 format
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {module:api/LockAuditApi~requestLockTelemetryRecordsEventRangeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/TelemetryEntry>}
     */
  }, {
    key: "requestLockTelemetryRecordsEventRange",
    value: function requestLockTelemetryRecordsEventRange(eventStartDate, eventEndDate, opts, callback) {
      opts = opts || {};
      var postBody = null;
      // verify the required parameter 'eventStartDate' is set
      if (eventStartDate === undefined || eventStartDate === null) {
        throw new Error("Missing the required parameter 'eventStartDate' when calling requestLockTelemetryRecordsEventRange");
      }
      // verify the required parameter 'eventEndDate' is set
      if (eventEndDate === undefined || eventEndDate === null) {
        throw new Error("Missing the required parameter 'eventEndDate' when calling requestLockTelemetryRecordsEventRange");
      }
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'eventStartDate': eventStartDate,
        'eventEndDate': eventEndDate
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_TelemetryEntry["default"]];
      return this.apiClient.callApi('/lock/audit/telemetry/search', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the saveHealthData operation.
     * @callback module:api/LockAuditApi~saveHealthDataCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Save health data
     * Save health data
     * @param {Object} opts Optional parameters
     * @param {module:model/HealthEntry} opts.healthEntry 
     * @param {module:api/LockAuditApi~saveHealthDataCallback} callback The callback function, accepting three arguments: error, data, response
     */
  }, {
    key: "saveHealthData",
    value: function saveHealthData(opts, callback) {
      opts = opts || {};
      var postBody = opts['healthEntry'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;
      return this.apiClient.callApi('/lock/audit/health', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the saveLogData operation.
     * @callback module:api/LockAuditApi~saveLogDataCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Save log data
     * Save log data
     * @param {Object} opts Optional parameters
     * @param {module:model/LogEntry} opts.logEntry 
     * @param {module:api/LockAuditApi~saveLogDataCallback} callback The callback function, accepting three arguments: error, data, response
     */
  }, {
    key: "saveLogData",
    value: function saveLogData(opts, callback) {
      opts = opts || {};
      var postBody = opts['logEntry'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;
      return this.apiClient.callApi('/lock/audit/log', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the saveTelemetryData operation.
     * @callback module:api/LockAuditApi~saveTelemetryDataCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Save telemetry data
     * Save telemetry data
     * @param {Object} opts Optional parameters
     * @param {module:model/TelemetryEntry} opts.telemetryEntry 
     * @param {module:api/LockAuditApi~saveTelemetryDataCallback} callback The callback function, accepting three arguments: error, data, response
     */
  }, {
    key: "saveTelemetryData",
    value: function saveTelemetryData(opts, callback) {
      opts = opts || {};
      var postBody = opts['telemetryEntry'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = null;
      return this.apiClient.callApi('/lock/audit/telemetry', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();