"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _Deployment = _interopRequireDefault(require("../model/Deployment"));
var _PagedResult = _interopRequireDefault(require("../model/PagedResult"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* Agama service.
* @module api/AgamaApi
* @version OAS Version
*/
var AgamaApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new AgamaApi. 
  * @alias module:api/AgamaApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function AgamaApi(apiClient) {
    _classCallCheck(this, AgamaApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteAgamaPrj operation.
   * @callback module:api/AgamaApi~deleteAgamaPrjCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Delete a deployed Agama project.
   * Delete a deployed Agama project.
   * @param {String} name Agama project name
   * @param {module:api/AgamaApi~deleteAgamaPrjCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(AgamaApi, [{
    key: "deleteAgamaPrj",
    value: function deleteAgamaPrj(name, callback) {
      var postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling deleteAgamaPrj");
      }
      var pathParams = {
        'name': name
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/api/v1/agama-deployment/{name}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAgamaPrj operation.
     * @callback module:api/AgamaApi~getAgamaPrjCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieve the list of projects deployed currently.
     * Retrieve the list of projects deployed currently.
     * @param {Object} opts Optional parameters
     * @param {Number} opts.start Start index for the result
     * @param {Number} opts.count Search size - count of the results to return
     * @param {module:api/AgamaApi~getAgamaPrjCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
  }, {
    key: "getAgamaPrj",
    value: function getAgamaPrj(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'start': opts['start'],
        'count': opts['count']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _PagedResult["default"];
      return this.apiClient.callApi('/api/v1/agama-deployment', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAgamaPrjByName operation.
     * @callback module:api/AgamaApi~getAgamaPrjByNameCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Deployment} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetches deployed Agama project based on name.
     * Fetches deployed Agama project based on name.
     * @param {String} name Agama project name
     * @param {module:api/AgamaApi~getAgamaPrjByNameCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Deployment}
     */
  }, {
    key: "getAgamaPrjByName",
    value: function getAgamaPrjByName(name, callback) {
      var postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling getAgamaPrjByName");
      }
      var pathParams = {
        'name': name
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _Deployment["default"];
      return this.apiClient.callApi('/api/v1/agama-deployment/{name}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAgamaPrjConfigs operation.
     * @callback module:api/AgamaApi~getAgamaPrjConfigsCallback
     * @param {String} error Error message, if any.
     * @param {String} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieve the list of configs based on name.
     * Retrieve the list of configs based on name.
     * @param {String} name Agama project name
     * @param {module:api/AgamaApi~getAgamaPrjConfigsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link String}
     */
  }, {
    key: "getAgamaPrjConfigs",
    value: function getAgamaPrjConfigs(name, callback) {
      var postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling getAgamaPrjConfigs");
      }
      var pathParams = {
        'name': name
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = 'String';
      return this.apiClient.callApi('/api/v1/agama-deployment/configs/{name}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAgamaProject operation.
     * @callback module:api/AgamaApi~getAgamaProjectCallback
     * @param {String} error Error message, if any.
     * @param {File} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Download agama project.
     * Download agama project.
     * @param {Object} opts Optional parameters
     * @param {String} opts.downloadLink Agama project download Link
     * @param {module:api/AgamaApi~getAgamaProjectCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link File}
     */
  }, {
    key: "getAgamaProject",
    value: function getAgamaProject(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'downloadLink': opts['downloadLink']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = File;
      return this.apiClient.callApi('/api/v1/agama-repo/download', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAgamaRepositories operation.
     * @callback module:api/AgamaApi~getAgamaRepositoriesCallback
     * @param {String} error Error message, if any.
     * @param {Object} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets all agama repositories.
     * Gets all agama repositories.
     * @param {module:api/AgamaApi~getAgamaRepositoriesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Object}
     */
  }, {
    key: "getAgamaRepositories",
    value: function getAgamaRepositories(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = Object;
      return this.apiClient.callApi('/api/v1/agama-repo', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postAgamaPrj operation.
     * @callback module:api/AgamaApi~postAgamaPrjCallback
     * @param {String} error Error message, if any.
     * @param {String} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Deploy an Agama project.
     * Deploy an Agama project.
     * @param {String} name Agama project name
     * @param {Object} opts Optional parameters
     * @param {String} opts.autoconfigure Boolean value to indicating to auto configure the project 
     * @param {Blob} opts.body Agama gama file
     * @param {module:api/AgamaApi~postAgamaPrjCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link String}
     */
  }, {
    key: "postAgamaPrj",
    value: function postAgamaPrj(name, opts, callback) {
      opts = opts || {};
      var postBody = opts['body'];
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling postAgamaPrj");
      }
      var pathParams = {
        'name': name
      };
      var queryParams = {
        'autoconfigure': opts['autoconfigure']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/zip'];
      var accepts = ['application/zip'];
      var returnType = 'String';
      return this.apiClient.callApi('/api/v1/agama-deployment/{name}', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putAgamaPrj operation.
     * @callback module:api/AgamaApi~putAgamaPrjCallback
     * @param {String} error Error message, if any.
     * @param {String} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update an Agama project.
     * Update an Agama project.
     * @param {String} name Agama project name
     * @param {Object} opts Optional parameters
     * @param {Object.<String, {String: {String: Object}}>} opts.requestBody Agama flow config, key is `name` of config property and `value` is the property value. 
     * @param {module:api/AgamaApi~putAgamaPrjCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link String}
     */
  }, {
    key: "putAgamaPrj",
    value: function putAgamaPrj(name, opts, callback) {
      opts = opts || {};
      var postBody = opts['requestBody'];
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling putAgamaPrj");
      }
      var pathParams = {
        'name': name
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = 'String';
      return this.apiClient.callApi('/api/v1/agama-deployment/configs/{name}', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();