"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _AuiFeature = _interopRequireDefault(require("../model/AuiFeature"));
var _GenericResponse = _interopRequireDefault(require("../model/GenericResponse"));
var _PagedResult = _interopRequireDefault(require("../model/PagedResult"));
var _Scope = _interopRequireDefault(require("../model/Scope"));
var _ShortCodeRequest = _interopRequireDefault(require("../model/ShortCodeRequest"));
var _WebhookEntry = _interopRequireDefault(require("../model/WebhookEntry"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* AdminUIWebhooks service.
* @module api/AdminUIWebhooksApi
* @version OAS Version
*/
var AdminUIWebhooksApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new AdminUIWebhooksApi. 
  * @alias module:api/AdminUIWebhooksApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function AdminUIWebhooksApi(apiClient) {
    _classCallCheck(this, AdminUIWebhooksApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteWebhookByInum operation.
   * @callback module:api/AdminUIWebhooksApi~deleteWebhookByInumCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Delete Webhook
   * Delete Webhook
   * @param {String} webhookId Webhook identifier
   * @param {module:api/AdminUIWebhooksApi~deleteWebhookByInumCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(AdminUIWebhooksApi, [{
    key: "deleteWebhookByInum",
    value: function deleteWebhookByInum(webhookId, callback) {
      var postBody = null;
      // verify the required parameter 'webhookId' is set
      if (webhookId === undefined || webhookId === null) {
        throw new Error("Missing the required parameter 'webhookId' when calling deleteWebhookByInum");
      }
      var pathParams = {
        'webhookId': webhookId
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = null;
      return this.apiClient.callApi('/admin-ui/webhook/{webhookId}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAllFeatures operation.
     * @callback module:api/AdminUIWebhooksApi~getAllFeaturesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/AuiFeature} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of Admin UI features
     * Gets list of Admin UI features
     * @param {module:api/AdminUIWebhooksApi~getAllFeaturesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/AuiFeature}
     */
  }, {
    key: "getAllFeatures",
    value: function getAllFeatures(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _AuiFeature["default"];
      return this.apiClient.callApi('/admin-ui/webhook/features', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAllWebhooks operation.
     * @callback module:api/AdminUIWebhooksApi~getAllWebhooksCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of webhooks
     * Gets list of webhooks
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/AdminUIWebhooksApi~getAllWebhooksCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
  }, {
    key: "getAllWebhooks",
    value: function getAllWebhooks(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _PagedResult["default"];
      return this.apiClient.callApi('/admin-ui/webhook', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getFeaturesByWebhookId operation.
     * @callback module:api/AdminUIWebhooksApi~getFeaturesByWebhookIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/AuiFeature} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of Admin UI features mapped to webhookId
     * Gets list of Admin UI features mapped to webhookId
     * @param {String} webhookId Webhook identifier
     * @param {module:api/AdminUIWebhooksApi~getFeaturesByWebhookIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/AuiFeature}
     */
  }, {
    key: "getFeaturesByWebhookId",
    value: function getFeaturesByWebhookId(webhookId, callback) {
      var postBody = null;
      // verify the required parameter 'webhookId' is set
      if (webhookId === undefined || webhookId === null) {
        throw new Error("Missing the required parameter 'webhookId' when calling getFeaturesByWebhookId");
      }
      var pathParams = {
        'webhookId': webhookId
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _AuiFeature["default"];
      return this.apiClient.callApi('/admin-ui/webhook/features/{webhookId}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getWebhooksByFeatureId operation.
     * @callback module:api/AdminUIWebhooksApi~getWebhooksByFeatureIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/WebhookEntry} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of Admin UI Webhooks mapped to featureId
     * Gets list of Admin UI Webhooks mapped to featureId
     * @param {String} featureId Feature identifier
     * @param {module:api/AdminUIWebhooksApi~getWebhooksByFeatureIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/WebhookEntry}
     */
  }, {
    key: "getWebhooksByFeatureId",
    value: function getWebhooksByFeatureId(featureId, callback) {
      var postBody = null;
      // verify the required parameter 'featureId' is set
      if (featureId === undefined || featureId === null) {
        throw new Error("Missing the required parameter 'featureId' when calling getWebhooksByFeatureId");
      }
      var pathParams = {
        'featureId': featureId
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _WebhookEntry["default"];
      return this.apiClient.callApi('/admin-ui/webhook/{featureId}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postWebhook operation.
     * @callback module:api/AdminUIWebhooksApi~postWebhookCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Scope} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create Webhook
     * Create Webhook
     * @param {Object} opts Optional parameters
     * @param {module:model/WebhookEntry} opts.webhookEntry Webhook object
     * @param {module:api/AdminUIWebhooksApi~postWebhookCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Scope}
     */
  }, {
    key: "postWebhook",
    value: function postWebhook(opts, callback) {
      opts = opts || {};
      var postBody = opts['webhookEntry'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _Scope["default"];
      return this.apiClient.callApi('/admin-ui/webhook', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putWebhook operation.
     * @callback module:api/AdminUIWebhooksApi~putWebhookCallback
     * @param {String} error Error message, if any.
     * @param {module:model/WebhookEntry} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update Webhook
     * Update Webhook
     * @param {Object} opts Optional parameters
     * @param {module:model/WebhookEntry} opts.webhookEntry Webhook object
     * @param {module:api/AdminUIWebhooksApi~putWebhookCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/WebhookEntry}
     */
  }, {
    key: "putWebhook",
    value: function putWebhook(opts, callback) {
      opts = opts || {};
      var postBody = opts['webhookEntry'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _WebhookEntry["default"];
      return this.apiClient.callApi('/admin-ui/webhook', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the triggerWebhook operation.
     * @callback module:api/AdminUIWebhooksApi~triggerWebhookCallback
     * @param {String} error Error message, if any.
     * @param {module:model/AuiFeature} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Trigger webhooks mapped to featureId
     * Trigger webhooks mapped to featureId
     * @param {String} featureId Admin UI feature identifier
     * @param {Object} opts Optional parameters
     * @param {module:model/ShortCodeRequest} opts.shortCodeRequest Webhook object
     * @param {module:api/AdminUIWebhooksApi~triggerWebhookCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/AuiFeature}
     */
  }, {
    key: "triggerWebhook",
    value: function triggerWebhook(featureId, opts, callback) {
      opts = opts || {};
      var postBody = opts['shortCodeRequest'];
      // verify the required parameter 'featureId' is set
      if (featureId === undefined || featureId === null) {
        throw new Error("Missing the required parameter 'featureId' when calling triggerWebhook");
      }
      var pathParams = {
        'featureId': featureId
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _AuiFeature["default"];
      return this.apiClient.callApi('/admin-ui/webhook/trigger/{featureId}', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();