"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _AdminRole = _interopRequireDefault(require("../model/AdminRole"));
var _GenericResponse = _interopRequireDefault(require("../model/GenericResponse"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* AdminUIRole service.
* @module api/AdminUIRoleApi
* @version OAS Version
*/
var AdminUIRoleApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new AdminUIRoleApi. 
  * @alias module:api/AdminUIRoleApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function AdminUIRoleApi(apiClient) {
    _classCallCheck(this, AdminUIRoleApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the addAdminuiRole operation.
   * @callback module:api/AdminUIRoleApi~addAdminuiRoleCallback
   * @param {String} error Error message, if any.
   * @param {Array.<module:model/AdminRole>} data The data returned by the service call.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Add admin ui role
   * Add admin ui role
   * @param {Object} opts Optional parameters
   * @param {module:model/AdminRole} opts.adminRole AdminRole object
   * @param {module:api/AdminUIRoleApi~addAdminuiRoleCallback} callback The callback function, accepting three arguments: error, data, response
   * data is of type: {@link Array.<module:model/AdminRole>}
   */
  return _createClass(AdminUIRoleApi, [{
    key: "addAdminuiRole",
    value: function addAdminuiRole(opts, callback) {
      opts = opts || {};
      var postBody = opts['adminRole'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = [_AdminRole["default"]];
      return this.apiClient.callApi('/admin-ui/adminUIRoles', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the deleteAdminuiRole operation.
     * @callback module:api/AdminUIRoleApi~deleteAdminuiRoleCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/AdminRole>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete admin ui role by role-name
     * Delete admin ui role by role-name
     * @param {String} adminUIRole Admin UI role
     * @param {module:api/AdminUIRoleApi~deleteAdminuiRoleCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/AdminRole>}
     */
  }, {
    key: "deleteAdminuiRole",
    value: function deleteAdminuiRole(adminUIRole, callback) {
      var postBody = null;
      // verify the required parameter 'adminUIRole' is set
      if (adminUIRole === undefined || adminUIRole === null) {
        throw new Error("Missing the required parameter 'adminUIRole' when calling deleteAdminuiRole");
      }
      var pathParams = {
        'adminUIRole': adminUIRole
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_AdminRole["default"]];
      return this.apiClient.callApi('/admin-ui/adminUIRoles/{adminUIRole}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the editAdminuiRole operation.
     * @callback module:api/AdminUIRoleApi~editAdminuiRoleCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/AdminRole>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Edit admin ui role
     * Edit admin ui role
     * @param {Object} opts Optional parameters
     * @param {module:model/AdminRole} opts.adminRole AdminRole object
     * @param {module:api/AdminUIRoleApi~editAdminuiRoleCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/AdminRole>}
     */
  }, {
    key: "editAdminuiRole",
    value: function editAdminuiRole(opts, callback) {
      opts = opts || {};
      var postBody = opts['adminRole'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = [_AdminRole["default"]];
      return this.apiClient.callApi('/admin-ui/adminUIRoles', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAdminuiRole operation.
     * @callback module:api/AdminUIRoleApi~getAdminuiRoleCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/AdminRole>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get admin ui role details by role-name
     * Get admin ui role details by role-name
     * @param {String} adminUIRole Admin UI role
     * @param {module:api/AdminUIRoleApi~getAdminuiRoleCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/AdminRole>}
     */
  }, {
    key: "getAdminuiRole",
    value: function getAdminuiRole(adminUIRole, callback) {
      var postBody = null;
      // verify the required parameter 'adminUIRole' is set
      if (adminUIRole === undefined || adminUIRole === null) {
        throw new Error("Missing the required parameter 'adminUIRole' when calling getAdminuiRole");
      }
      var pathParams = {
        'adminUIRole': adminUIRole
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_AdminRole["default"]];
      return this.apiClient.callApi('/admin-ui/adminUIRoles/{adminUIRole}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAllAdminuiRoles operation.
     * @callback module:api/AdminUIRoleApi~getAllAdminuiRolesCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/AdminRole>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get all admin ui roles
     * Get all admin ui roles
     * @param {module:api/AdminUIRoleApi~getAllAdminuiRolesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/AdminRole>}
     */
  }, {
    key: "getAllAdminuiRoles",
    value: function getAllAdminuiRoles(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_AdminRole["default"]];
      return this.apiClient.callApi('/admin-ui/adminUIRoles', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();