"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _GenericResponse = _interopRequireDefault(require("../model/GenericResponse"));
var _LicenseRequest = _interopRequireDefault(require("../model/LicenseRequest"));
var _LicenseResponse = _interopRequireDefault(require("../model/LicenseResponse"));
var _SSARequest = _interopRequireDefault(require("../model/SSARequest"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* AdminUILicense service.
* @module api/AdminUILicenseApi
* @version OAS Version
*/
var AdminUILicenseApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new AdminUILicenseApi. 
  * @alias module:api/AdminUILicenseApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function AdminUILicenseApi(apiClient) {
    _classCallCheck(this, AdminUILicenseApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the activateAdminuiLicense operation.
   * @callback module:api/AdminUILicenseApi~activateAdminuiLicenseCallback
   * @param {String} error Error message, if any.
   * @param {module:model/GenericResponse} data The data returned by the service call.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Activate license using license-key
   * Activate license using license-key
   * @param {Object} opts Optional parameters
   * @param {module:model/LicenseRequest} opts.licenseRequest LicenseRequest object
   * @param {module:api/AdminUILicenseApi~activateAdminuiLicenseCallback} callback The callback function, accepting three arguments: error, data, response
   * data is of type: {@link module:model/GenericResponse}
   */
  return _createClass(AdminUILicenseApi, [{
    key: "activateAdminuiLicense",
    value: function activateAdminuiLicense(opts, callback) {
      opts = opts || {};
      var postBody = opts['licenseRequest'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _GenericResponse["default"];
      return this.apiClient.callApi('/admin-ui/license/activate', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the adminuiPostSsa operation.
     * @callback module:api/AdminUILicenseApi~adminuiPostSsaCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GenericResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Save SSA in configuration
     * Save SSA in configuration
     * @param {Object} opts Optional parameters
     * @param {module:model/SSARequest} opts.sSARequest SSARequest object
     * @param {module:api/AdminUILicenseApi~adminuiPostSsaCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GenericResponse}
     */
  }, {
    key: "adminuiPostSsa",
    value: function adminuiPostSsa(opts, callback) {
      opts = opts || {};
      var postBody = opts['sSARequest'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _GenericResponse["default"];
      return this.apiClient.callApi('/admin-ui/license/ssa', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the checkAdminuiLicenseConfig operation.
     * @callback module:api/AdminUILicenseApi~checkAdminuiLicenseConfigCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GenericResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Is license configuration valid
     * Is license configuration valid
     * @param {module:api/AdminUILicenseApi~checkAdminuiLicenseConfigCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GenericResponse}
     */
  }, {
    key: "checkAdminuiLicenseConfig",
    value: function checkAdminuiLicenseConfig(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _GenericResponse["default"];
      return this.apiClient.callApi('/admin-ui/license/isConfigValid', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAdminuiLicense operation.
     * @callback module:api/AdminUILicenseApi~getAdminuiLicenseCallback
     * @param {String} error Error message, if any.
     * @param {module:model/LicenseResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get admin ui license details
     * Get admin ui license details
     * @param {module:api/AdminUILicenseApi~getAdminuiLicenseCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/LicenseResponse}
     */
  }, {
    key: "getAdminuiLicense",
    value: function getAdminuiLicense(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _LicenseResponse["default"];
      return this.apiClient.callApi('/admin-ui/license/details', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getTrialLicense operation.
     * @callback module:api/AdminUILicenseApi~getTrialLicenseCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GenericResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Generate trial license
     * Generate trial license
     * @param {module:api/AdminUILicenseApi~getTrialLicenseCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GenericResponse}
     */
  }, {
    key: "getTrialLicense",
    value: function getTrialLicense(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _GenericResponse["default"];
      return this.apiClient.callApi('/admin-ui/license/trial', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the isLicenseActive operation.
     * @callback module:api/AdminUILicenseApi~isLicenseActiveCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GenericResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Check if admin-ui license is active
     * Check if admin-ui license is active
     * @param {module:api/AdminUILicenseApi~isLicenseActiveCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GenericResponse}
     */
  }, {
    key: "isLicenseActive",
    value: function isLicenseActive(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _GenericResponse["default"];
      return this.apiClient.callApi('/admin-ui/license/isActive', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the licenseConfigDelete operation.
     * @callback module:api/AdminUILicenseApi~licenseConfigDeleteCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GenericResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete license details in admin-ui configuration
     * Delete license details in admin-ui configuration
     * @param {module:api/AdminUILicenseApi~licenseConfigDeleteCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GenericResponse}
     */
  }, {
    key: "licenseConfigDelete",
    value: function licenseConfigDelete(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _GenericResponse["default"];
      return this.apiClient.callApi('/admin-ui/license/deleteConfig', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the retrieveLicense operation.
     * @callback module:api/AdminUILicenseApi~retrieveLicenseCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GenericResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieve license from SCAN
     * Retrieve license from SCAN
     * @param {module:api/AdminUILicenseApi~retrieveLicenseCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GenericResponse}
     */
  }, {
    key: "retrieveLicense",
    value: function retrieveLicense(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _GenericResponse["default"];
      return this.apiClient.callApi('/admin-ui/license/retrieve', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();