/// <reference types="react" />
import { noop } from '../utils';
import { Id, Option, OptionHandler, SelectEvent } from '../types';
export interface TypeaheadContextType {
    activeIndex: number;
    hintText: string;
    id: Id;
    initialItem: Option | null;
    inputNode: HTMLInputElement | null;
    isOnlyResult: boolean;
    onActiveItemChange: OptionHandler;
    onAdd: OptionHandler;
    onInitialItemChange: (option?: Option) => void;
    onMenuItemClick: (option: Option, event: SelectEvent<HTMLElement>) => void;
    setItem: (option: Option, position: number) => void;
}
export declare const defaultContext: {
    activeIndex: number;
    hintText: string;
    id: string;
    initialItem: null;
    inputNode: null;
    isOnlyResult: boolean;
    onActiveItemChange: typeof noop;
    onAdd: typeof noop;
    onInitialItemChange: typeof noop;
    onMenuItemClick: typeof noop;
    setItem: typeof noop;
};
export declare const TypeaheadContext: import("react").Context<TypeaheadContextType>;
export declare const useTypeaheadContext: () => TypeaheadContextType;
