import React, { useState } from 'react';
import Overlay from './Overlay';
import Menu from '../Menu';
import { BaseMenuItem } from '../MenuItem';
export default {
    title: 'Components/Overlay',
    component: Overlay,
};
const Template = (args) => {
    const [referenceElement, setReferenceElement] = useState(null);
    return (React.createElement("div", null,
        React.createElement("div", { ref: setReferenceElement, style: { border: '1px solid red', padding: '4px' } }, "Reference element"),
        React.createElement(Overlay, { ...args, referenceElement: referenceElement }, (menuProps) => (React.createElement(Menu, { ...menuProps, id: "overlay-story" },
            React.createElement(BaseMenuItem, { role: "option" }, "This is the menu"))))));
};
export const Default = Template.bind({});
Default.args = {
    isMenuShown: true,
    positionFixed: true,
};
