/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import AssetDirMapping from './AssetDirMapping';

/**
 * The AssetMgtConfiguration model module.
 * @module model/AssetMgtConfiguration
 * @version OAS Version
 */
class AssetMgtConfiguration {
    /**
     * Constructs a new <code>AssetMgtConfiguration</code>.
     * Asset management configuration details.
     * @alias module:model/AssetMgtConfiguration
     */
    constructor() { 
        
        AssetMgtConfiguration.initialize(this);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj) { 
    }

    /**
     * Constructs a <code>AssetMgtConfiguration</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/AssetMgtConfiguration} obj Optional instance to populate.
     * @return {module:model/AssetMgtConfiguration} The populated <code>AssetMgtConfiguration</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new AssetMgtConfiguration();

            if (data.hasOwnProperty('assetMgtEnabled')) {
                obj['assetMgtEnabled'] = ApiClient.convertToType(data['assetMgtEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('assetServerUploadEnabled')) {
                obj['assetServerUploadEnabled'] = ApiClient.convertToType(data['assetServerUploadEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('fileExtensionValidationEnabled')) {
                obj['fileExtensionValidationEnabled'] = ApiClient.convertToType(data['fileExtensionValidationEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('moduleNameValidationEnabled')) {
                obj['moduleNameValidationEnabled'] = ApiClient.convertToType(data['moduleNameValidationEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('assetDirMapping')) {
                obj['assetDirMapping'] = ApiClient.convertToType(data['assetDirMapping'], [AssetDirMapping]);
            }
        }
        return obj;
    }


}

/**
 * Flag indicating if asset management functionality is enabled.
 * @member {Boolean} assetMgtEnabled
 */
AssetMgtConfiguration.prototype['assetMgtEnabled'] = undefined;

/**
 * Flag indicating if asset upload to server is enabled.
 * @member {Boolean} assetServerUploadEnabled
 */
AssetMgtConfiguration.prototype['assetServerUploadEnabled'] = undefined;

/**
 * Flag indicating if file extension validation is enabled.
 * @member {Boolean} fileExtensionValidationEnabled
 */
AssetMgtConfiguration.prototype['fileExtensionValidationEnabled'] = undefined;

/**
 * Flag indicating if service module name extension validation is enabled.
 * @member {Boolean} moduleNameValidationEnabled
 */
AssetMgtConfiguration.prototype['moduleNameValidationEnabled'] = undefined;

/**
 * Asset type mapped to server directory.
 * @member {Array.<module:model/AssetDirMapping>} assetDirMapping
 */
AssetMgtConfiguration.prototype['assetDirMapping'] = undefined;






export default AssetMgtConfiguration;

