/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import ApiError from '../model/ApiError';
import TrustRelationship from '../model/TrustRelationship';

/**
* SAMLTrustRelationship service.
* @module api/SAMLTrustRelationshipApi
* @version OAS Version
*/
export default class SAMLTrustRelationshipApi {

    /**
    * Constructs a new SAMLTrustRelationshipApi. 
    * @alias module:api/SAMLTrustRelationshipApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteTrustRelationship operation.
     * @callback module:api/SAMLTrustRelationshipApi~deleteTrustRelationshipCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete TrustRelationship
     * Delete TrustRelationship
     * @param {String} id Unique Id of Trust Relationship
     * @param {module:api/SAMLTrustRelationshipApi~deleteTrustRelationshipCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteTrustRelationship(id, callback) {
      let postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling deleteTrustRelationship");
      }

      let pathParams = {
        'id': id
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/kc/saml/trust-relationship/{id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getTrustRelationshipById operation.
     * @callback module:api/SAMLTrustRelationshipApi~getTrustRelationshipByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TrustRelationship} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get TrustRelationship by Id
     * Get TrustRelationship by Id
     * @param {String} id Unique identifier - Id
     * @param {module:api/SAMLTrustRelationshipApi~getTrustRelationshipByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TrustRelationship}
     */
    getTrustRelationshipById(id, callback) {
      let postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling getTrustRelationshipById");
      }

      let pathParams = {
        'id': id
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = TrustRelationship;
      return this.apiClient.callApi(
        '/kc/saml/trust-relationship/id/{id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getTrustRelationshipFileMetadata operation.
     * @callback module:api/SAMLTrustRelationshipApi~getTrustRelationshipFileMetadataCallback
     * @param {String} error Error message, if any.
     * @param {File} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get TrustRelationship file metadata
     * Get TrustRelationship file metadata
     * @param {String} id TrustRelationship inum
     * @param {module:api/SAMLTrustRelationshipApi~getTrustRelationshipFileMetadataCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link File}
     */
    getTrustRelationshipFileMetadata(id, callback) {
      let postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling getTrustRelationshipFileMetadata");
      }

      let pathParams = {
        'id': id
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/xml', 'application/json'];
      let returnType = File;
      return this.apiClient.callApi(
        '/kc/saml/trust-relationship/sp-metadata-file/{id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getTrustRelationships operation.
     * @callback module:api/SAMLTrustRelationshipApi~getTrustRelationshipsCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/TrustRelationship>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get all Trust Relationship
     * Get all TrustRelationship.
     * @param {module:api/SAMLTrustRelationshipApi~getTrustRelationshipsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/TrustRelationship>}
     */
    getTrustRelationships(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [TrustRelationship];
      return this.apiClient.callApi(
        '/kc/saml/trust-relationship', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postTrustRelationshipMetadataFile operation.
     * @callback module:api/SAMLTrustRelationshipApi~postTrustRelationshipMetadataFileCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TrustRelationship} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create Trust Relationship with Metadata File
     * Create Trust Relationship with Metadata File
     * @param {module:model/TrustRelationship} trustRelationship 
     * @param {File} metaDataFile 
     * @param {module:api/SAMLTrustRelationshipApi~postTrustRelationshipMetadataFileCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TrustRelationship}
     */
    postTrustRelationshipMetadataFile(trustRelationship, metaDataFile, callback) {
      let postBody = null;
      // verify the required parameter 'trustRelationship' is set
      if (trustRelationship === undefined || trustRelationship === null) {
        throw new Error("Missing the required parameter 'trustRelationship' when calling postTrustRelationshipMetadataFile");
      }
      // verify the required parameter 'metaDataFile' is set
      if (metaDataFile === undefined || metaDataFile === null) {
        throw new Error("Missing the required parameter 'metaDataFile' when calling postTrustRelationshipMetadataFile");
      }

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
        'trustRelationship': trustRelationship,
        'metaDataFile': metaDataFile
      };

      let authNames = ['oauth2'];
      let contentTypes = ['multipart/form-data'];
      let accepts = ['application/json'];
      let returnType = TrustRelationship;
      return this.apiClient.callApi(
        '/kc/saml/trust-relationship/upload', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the putTrustRelationship operation.
     * @callback module:api/SAMLTrustRelationshipApi~putTrustRelationshipCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TrustRelationship} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update TrustRelationship
     * Update TrustRelationship
     * @param {module:model/TrustRelationship} trustRelationship 
     * @param {File} metaDataFile 
     * @param {module:api/SAMLTrustRelationshipApi~putTrustRelationshipCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TrustRelationship}
     */
    putTrustRelationship(trustRelationship, metaDataFile, callback) {
      let postBody = null;
      // verify the required parameter 'trustRelationship' is set
      if (trustRelationship === undefined || trustRelationship === null) {
        throw new Error("Missing the required parameter 'trustRelationship' when calling putTrustRelationship");
      }
      // verify the required parameter 'metaDataFile' is set
      if (metaDataFile === undefined || metaDataFile === null) {
        throw new Error("Missing the required parameter 'metaDataFile' when calling putTrustRelationship");
      }

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
        'trustRelationship': trustRelationship,
        'metaDataFile': metaDataFile
      };

      let authNames = ['oauth2'];
      let contentTypes = ['multipart/form-data'];
      let accepts = ['application/json'];
      let returnType = TrustRelationship;
      return this.apiClient.callApi(
        '/kc/saml/trust-relationship/upload', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
