/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import ApiError from '../model/ApiError';
import HealthEntry from '../model/HealthEntry';
import LogEntry from '../model/LogEntry';
import TelemetryEntry from '../model/TelemetryEntry';

/**
* LockAudit service.
* @module api/LockAuditApi
* @version OAS Version
*/
export default class LockAuditApi {

    /**
    * Constructs a new LockAuditApi. 
    * @alias module:api/LockAuditApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the bulkSaveHealthData operation.
     * @callback module:api/LockAuditApi~bulkSaveHealthDataCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Bulk save health data
     * Bulk save health data
     * @param {Object} opts Optional parameters
     * @param {Array.<module:model/HealthEntry>} opts.healthEntry 
     * @param {module:api/LockAuditApi~bulkSaveHealthDataCallback} callback The callback function, accepting three arguments: error, data, response
     */
    bulkSaveHealthData(opts, callback) {
      opts = opts || {};
      let postBody = opts['healthEntry'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = null;
      return this.apiClient.callApi(
        '/lock/audit/health/bulk', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the bulkSaveLogData operation.
     * @callback module:api/LockAuditApi~bulkSaveLogDataCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Bulk save log data
     * Bulk save log data
     * @param {Object} opts Optional parameters
     * @param {Array.<module:model/LogEntry>} opts.logEntry 
     * @param {module:api/LockAuditApi~bulkSaveLogDataCallback} callback The callback function, accepting three arguments: error, data, response
     */
    bulkSaveLogData(opts, callback) {
      opts = opts || {};
      let postBody = opts['logEntry'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = null;
      return this.apiClient.callApi(
        '/lock/audit/log/bulk', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the bulkSaveTelemetryData operation.
     * @callback module:api/LockAuditApi~bulkSaveTelemetryDataCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Bulk save telemetry data
     * Bulk save telemetry data
     * @param {Object} opts Optional parameters
     * @param {Array.<module:model/TelemetryEntry>} opts.telemetryEntry 
     * @param {module:api/LockAuditApi~bulkSaveTelemetryDataCallback} callback The callback function, accepting three arguments: error, data, response
     */
    bulkSaveTelemetryData(opts, callback) {
      opts = opts || {};
      let postBody = opts['telemetryEntry'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = null;
      return this.apiClient.callApi(
        '/lock/audit/telemetry/bulk', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the requestLockHealthRecordsEventRange operation.
     * @callback module:api/LockAuditApi~requestLockHealthRecordsEventRangeCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/HealthEntry>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Rerquest health records for specific event range
     * Rerquest health records for specific event range
     * @param {String} eventStartDate Event start date in ISO8601 format
     * @param {String} eventEndDate Event end date in ISO8601 format
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {module:api/LockAuditApi~requestLockHealthRecordsEventRangeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/HealthEntry>}
     */
    requestLockHealthRecordsEventRange(eventStartDate, eventEndDate, opts, callback) {
      opts = opts || {};
      let postBody = null;
      // verify the required parameter 'eventStartDate' is set
      if (eventStartDate === undefined || eventStartDate === null) {
        throw new Error("Missing the required parameter 'eventStartDate' when calling requestLockHealthRecordsEventRange");
      }
      // verify the required parameter 'eventEndDate' is set
      if (eventEndDate === undefined || eventEndDate === null) {
        throw new Error("Missing the required parameter 'eventEndDate' when calling requestLockHealthRecordsEventRange");
      }

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'eventStartDate': eventStartDate,
        'eventEndDate': eventEndDate
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [HealthEntry];
      return this.apiClient.callApi(
        '/lock/audit/health/search', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the requestLockTelemetryRecordsEventRange operation.
     * @callback module:api/LockAuditApi~requestLockTelemetryRecordsEventRangeCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/TelemetryEntry>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Request telemetry records for specific event range
     * Rerquest telemetry records for specific event range
     * @param {String} eventStartDate Event start date in ISO8601 format
     * @param {String} eventEndDate Event end date in ISO8601 format
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {module:api/LockAuditApi~requestLockTelemetryRecordsEventRangeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/TelemetryEntry>}
     */
    requestLockTelemetryRecordsEventRange(eventStartDate, eventEndDate, opts, callback) {
      opts = opts || {};
      let postBody = null;
      // verify the required parameter 'eventStartDate' is set
      if (eventStartDate === undefined || eventStartDate === null) {
        throw new Error("Missing the required parameter 'eventStartDate' when calling requestLockTelemetryRecordsEventRange");
      }
      // verify the required parameter 'eventEndDate' is set
      if (eventEndDate === undefined || eventEndDate === null) {
        throw new Error("Missing the required parameter 'eventEndDate' when calling requestLockTelemetryRecordsEventRange");
      }

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'eventStartDate': eventStartDate,
        'eventEndDate': eventEndDate
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [TelemetryEntry];
      return this.apiClient.callApi(
        '/lock/audit/telemetry/search', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the saveHealthData operation.
     * @callback module:api/LockAuditApi~saveHealthDataCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Save health data
     * Save health data
     * @param {Object} opts Optional parameters
     * @param {module:model/HealthEntry} opts.healthEntry 
     * @param {module:api/LockAuditApi~saveHealthDataCallback} callback The callback function, accepting three arguments: error, data, response
     */
    saveHealthData(opts, callback) {
      opts = opts || {};
      let postBody = opts['healthEntry'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = null;
      return this.apiClient.callApi(
        '/lock/audit/health', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the saveLogData operation.
     * @callback module:api/LockAuditApi~saveLogDataCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Save log data
     * Save log data
     * @param {Object} opts Optional parameters
     * @param {module:model/LogEntry} opts.logEntry 
     * @param {module:api/LockAuditApi~saveLogDataCallback} callback The callback function, accepting three arguments: error, data, response
     */
    saveLogData(opts, callback) {
      opts = opts || {};
      let postBody = opts['logEntry'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = null;
      return this.apiClient.callApi(
        '/lock/audit/log', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the saveTelemetryData operation.
     * @callback module:api/LockAuditApi~saveTelemetryDataCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Save telemetry data
     * Save telemetry data
     * @param {Object} opts Optional parameters
     * @param {module:model/TelemetryEntry} opts.telemetryEntry 
     * @param {module:api/LockAuditApi~saveTelemetryDataCallback} callback The callback function, accepting three arguments: error, data, response
     */
    saveTelemetryData(opts, callback) {
      opts = opts || {};
      let postBody = opts['telemetryEntry'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = null;
      return this.apiClient.callApi(
        '/lock/audit/telemetry', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
