/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import HealthStatus from '../model/HealthStatus';
import StatsData from '../model/StatsData';
import Status from '../model/Status';

/**
* HealthCheck service.
* @module api/HealthCheckApi
* @version OAS Version
*/
export default class HealthCheckApi {

    /**
    * Constructs a new HealthCheckApi. 
    * @alias module:api/HealthCheckApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the getAppVersion operation.
     * @callback module:api/HealthCheckApi~getAppVersionCallback
     * @param {String} error Error message, if any.
     * @param {Object} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns application version
     * Returns application version
     * @param {Object} opts Optional parameters
     * @param {String} opts.artifact artifact name for which version is requied else ALL (default to 'all')
     * @param {module:api/HealthCheckApi~getAppVersionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Object}
     */
    getAppVersion(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'artifact': opts['artifact']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Object;
      return this.apiClient.callApi(
        '/api/v1/health/app-version', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getConfigHealth operation.
     * @callback module:api/HealthCheckApi~getConfigHealthCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/HealthStatus>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns application health status
     * Returns application health status
     * @param {module:api/HealthCheckApi~getConfigHealthCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/HealthStatus>}
     */
    getConfigHealth(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [HealthStatus];
      return this.apiClient.callApi(
        '/api/v1/health', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getConfigHealthLive operation.
     * @callback module:api/HealthCheckApi~getConfigHealthLiveCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Status} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns application liveness status
     * Returns application liveness status
     * @param {module:api/HealthCheckApi~getConfigHealthLiveCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Status}
     */
    getConfigHealthLive(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Status;
      return this.apiClient.callApi(
        '/api/v1/health/live', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getConfigHealthReady operation.
     * @callback module:api/HealthCheckApi~getConfigHealthReadyCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Status} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns application readiness status
     * Returns application readiness status
     * @param {module:api/HealthCheckApi~getConfigHealthReadyCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Status}
     */
    getConfigHealthReady(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Status;
      return this.apiClient.callApi(
        '/api/v1/health/ready', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getServerStat operation.
     * @callback module:api/HealthCheckApi~getServerStatCallback
     * @param {String} error Error message, if any.
     * @param {module:model/StatsData} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns application server status
     * Returns application server status
     * @param {module:api/HealthCheckApi~getServerStatCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/StatsData}
     */
    getServerStat(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = [];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = StatsData;
      return this.apiClient.callApi(
        '/api/v1/health/server-stat', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getServiceStatus operation.
     * @callback module:api/HealthCheckApi~getServiceStatusCallback
     * @param {String} error Error message, if any.
     * @param {Object} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch service status
     * Fetch service status
     * @param {Object} opts Optional parameters
     * @param {String} opts.service Service name to check status (default to 'all')
     * @param {module:api/HealthCheckApi~getServiceStatusCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Object}
     */
    getServiceStatus(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'service': opts['service']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Object;
      return this.apiClient.callApi(
        '/api/v1/health/service-status', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
