/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import SessionId from '../model/SessionId';
import SessionPagedResult from '../model/SessionPagedResult';

/**
* AuthSessionManagement service.
* @module api/AuthSessionManagementApi
* @version OAS Version
*/
export default class AuthSessionManagementApi {

    /**
    * Constructs a new AuthSessionManagementApi. 
    * @alias module:api/AuthSessionManagementApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteSession operation.
     * @callback module:api/AuthSessionManagementApi~deleteSessionCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete a session.
     * Delete a session.
     * @param {String} sid Session identifier.
     * @param {module:api/AuthSessionManagementApi~deleteSessionCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteSession(sid, callback) {
      let postBody = null;
      // verify the required parameter 'sid' is set
      if (sid === undefined || sid === null) {
        throw new Error("Missing the required parameter 'sid' when calling deleteSession");
      }

      let pathParams = {
        'sid': sid
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/v1/jans-auth-server/session/sid/{sid}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getSessionById operation.
     * @callback module:api/AuthSessionManagementApi~getSessionByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SessionId} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get session by id.
     * Get session by id.
     * @param {String} sid Session identifier.
     * @param {module:api/AuthSessionManagementApi~getSessionByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SessionId}
     */
    getSessionById(sid, callback) {
      let postBody = null;
      // verify the required parameter 'sid' is set
      if (sid === undefined || sid === null) {
        throw new Error("Missing the required parameter 'sid' when calling getSessionById");
      }

      let pathParams = {
        'sid': sid
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = SessionId;
      return this.apiClient.callApi(
        '/api/v1/jans-auth-server/session/sid/{sid}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getSessions operation.
     * @callback module:api/AuthSessionManagementApi~getSessionsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SessionPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Return all session
     * Return all session
     * @param {module:api/AuthSessionManagementApi~getSessionsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SessionPagedResult}
     */
    getSessions(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = SessionPagedResult;
      return this.apiClient.callApi(
        '/api/v1/jans-auth-server/session', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the revokeUserSession operation.
     * @callback module:api/AuthSessionManagementApi~revokeUserSessionCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Revoke all sessions by userDn
     * Revoke all sessions by userDn
     * @param {String} userDn User domain name
     * @param {module:api/AuthSessionManagementApi~revokeUserSessionCallback} callback The callback function, accepting three arguments: error, data, response
     */
    revokeUserSession(userDn, callback) {
      let postBody = null;
      // verify the required parameter 'userDn' is set
      if (userDn === undefined || userDn === null) {
        throw new Error("Missing the required parameter 'userDn' when calling revokeUserSession");
      }

      let pathParams = {
        'userDn': userDn
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/v1/jans-auth-server/session/user/{userDn}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the searchSession operation.
     * @callback module:api/AuthSessionManagementApi~searchSessionCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SessionPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Search session
     * Search session
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'jansId')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/AuthSessionManagementApi~searchSessionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SessionPagedResult}
     */
    searchSession(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = SessionPagedResult;
      return this.apiClient.callApi(
        '/api/v1/jans-auth-server/session/search', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
