/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import AuiFeature from '../model/AuiFeature';
import GenericResponse from '../model/GenericResponse';
import PagedResult from '../model/PagedResult';
import Scope from '../model/Scope';
import ShortCodeRequest from '../model/ShortCodeRequest';
import WebhookEntry from '../model/WebhookEntry';

/**
* AdminUIWebhooks service.
* @module api/AdminUIWebhooksApi
* @version OAS Version
*/
export default class AdminUIWebhooksApi {

    /**
    * Constructs a new AdminUIWebhooksApi. 
    * @alias module:api/AdminUIWebhooksApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteWebhookByInum operation.
     * @callback module:api/AdminUIWebhooksApi~deleteWebhookByInumCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete Webhook
     * Delete Webhook
     * @param {String} webhookId Webhook identifier
     * @param {module:api/AdminUIWebhooksApi~deleteWebhookByInumCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteWebhookByInum(webhookId, callback) {
      let postBody = null;
      // verify the required parameter 'webhookId' is set
      if (webhookId === undefined || webhookId === null) {
        throw new Error("Missing the required parameter 'webhookId' when calling deleteWebhookByInum");
      }

      let pathParams = {
        'webhookId': webhookId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = null;
      return this.apiClient.callApi(
        '/admin-ui/webhook/{webhookId}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAllFeatures operation.
     * @callback module:api/AdminUIWebhooksApi~getAllFeaturesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/AuiFeature} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of Admin UI features
     * Gets list of Admin UI features
     * @param {module:api/AdminUIWebhooksApi~getAllFeaturesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/AuiFeature}
     */
    getAllFeatures(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = AuiFeature;
      return this.apiClient.callApi(
        '/admin-ui/webhook/features', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAllWebhooks operation.
     * @callback module:api/AdminUIWebhooksApi~getAllWebhooksCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of webhooks
     * Gets list of webhooks
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/AdminUIWebhooksApi~getAllWebhooksCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
    getAllWebhooks(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = PagedResult;
      return this.apiClient.callApi(
        '/admin-ui/webhook', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getFeaturesByWebhookId operation.
     * @callback module:api/AdminUIWebhooksApi~getFeaturesByWebhookIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/AuiFeature} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of Admin UI features mapped to webhookId
     * Gets list of Admin UI features mapped to webhookId
     * @param {String} webhookId Webhook identifier
     * @param {module:api/AdminUIWebhooksApi~getFeaturesByWebhookIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/AuiFeature}
     */
    getFeaturesByWebhookId(webhookId, callback) {
      let postBody = null;
      // verify the required parameter 'webhookId' is set
      if (webhookId === undefined || webhookId === null) {
        throw new Error("Missing the required parameter 'webhookId' when calling getFeaturesByWebhookId");
      }

      let pathParams = {
        'webhookId': webhookId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = AuiFeature;
      return this.apiClient.callApi(
        '/admin-ui/webhook/features/{webhookId}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getWebhooksByFeatureId operation.
     * @callback module:api/AdminUIWebhooksApi~getWebhooksByFeatureIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/WebhookEntry} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of Admin UI Webhooks mapped to featureId
     * Gets list of Admin UI Webhooks mapped to featureId
     * @param {String} featureId Feature identifier
     * @param {module:api/AdminUIWebhooksApi~getWebhooksByFeatureIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/WebhookEntry}
     */
    getWebhooksByFeatureId(featureId, callback) {
      let postBody = null;
      // verify the required parameter 'featureId' is set
      if (featureId === undefined || featureId === null) {
        throw new Error("Missing the required parameter 'featureId' when calling getWebhooksByFeatureId");
      }

      let pathParams = {
        'featureId': featureId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = WebhookEntry;
      return this.apiClient.callApi(
        '/admin-ui/webhook/{featureId}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postWebhook operation.
     * @callback module:api/AdminUIWebhooksApi~postWebhookCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Scope} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create Webhook
     * Create Webhook
     * @param {Object} opts Optional parameters
     * @param {module:model/WebhookEntry} opts.webhookEntry Webhook object
     * @param {module:api/AdminUIWebhooksApi~postWebhookCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Scope}
     */
    postWebhook(opts, callback) {
      opts = opts || {};
      let postBody = opts['webhookEntry'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = Scope;
      return this.apiClient.callApi(
        '/admin-ui/webhook', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the putWebhook operation.
     * @callback module:api/AdminUIWebhooksApi~putWebhookCallback
     * @param {String} error Error message, if any.
     * @param {module:model/WebhookEntry} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update Webhook
     * Update Webhook
     * @param {Object} opts Optional parameters
     * @param {module:model/WebhookEntry} opts.webhookEntry Webhook object
     * @param {module:api/AdminUIWebhooksApi~putWebhookCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/WebhookEntry}
     */
    putWebhook(opts, callback) {
      opts = opts || {};
      let postBody = opts['webhookEntry'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = WebhookEntry;
      return this.apiClient.callApi(
        '/admin-ui/webhook', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the triggerWebhook operation.
     * @callback module:api/AdminUIWebhooksApi~triggerWebhookCallback
     * @param {String} error Error message, if any.
     * @param {module:model/AuiFeature} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Trigger webhooks mapped to featureId
     * Trigger webhooks mapped to featureId
     * @param {String} featureId Admin UI feature identifier
     * @param {Object} opts Optional parameters
     * @param {module:model/ShortCodeRequest} opts.shortCodeRequest Webhook object
     * @param {module:api/AdminUIWebhooksApi~triggerWebhookCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/AuiFeature}
     */
    triggerWebhook(featureId, opts, callback) {
      opts = opts || {};
      let postBody = opts['shortCodeRequest'];
      // verify the required parameter 'featureId' is set
      if (featureId === undefined || featureId === null) {
        throw new Error("Missing the required parameter 'featureId' when calling triggerWebhook");
      }

      let pathParams = {
        'featureId': featureId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = AuiFeature;
      return this.apiClient.callApi(
        '/admin-ui/webhook/trigger/{featureId}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
