# JansConfigApi.TokenApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getTokenByClient**](TokenApi.md#getTokenByClient) | **GET** /api/v1/token/client/{clientId} | Get token details by client.
[**getTokenById**](TokenApi.md#getTokenById) | **GET** /api/v1/token/tknCde/{tknCde} | Get token details by Id.
[**revokeToken**](TokenApi.md#revokeToken) | **DELETE** /api/v1/token/revoke/{tknCde} | Revoke client token.
[**searchToken**](TokenApi.md#searchToken) | **GET** /api/v1/token/search | Search tokens



## getTokenByClient

> TokenEntityPagedResult getTokenByClient(clientId)

Get token details by client.

Get token details by client.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.TokenApi();
let clientId = "clientId_example"; // String | Client identifier
apiInstance.getTokenByClient(clientId, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **clientId** | **String**| Client identifier | 

### Return type

[**TokenEntityPagedResult**](TokenEntityPagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getTokenById

> TokenEntity getTokenById(tknCde)

Get token details by Id.

Get token details by Id.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.TokenApi();
let tknCde = "tknCde_example"; // String | Token identifier
apiInstance.getTokenById(tknCde, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tknCde** | **String**| Token identifier | 

### Return type

[**TokenEntity**](TokenEntity.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## revokeToken

> revokeToken(tknCde)

Revoke client token.

Revoke client token.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.TokenApi();
let tknCde = "tknCde_example"; // String | Token Code
apiInstance.revokeToken(tknCde, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tknCde** | **String**| Token Code | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## searchToken

> TokenEntityPagedResult searchToken(opts)

Search tokens

Search tokens

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.TokenApi();
let opts = {
  'limit': 50, // Number | Search size - max size of the results to return
  'pattern': "''", // String | Search pattern
  'startIndex': 0, // Number | The 1-based index of the first query result
  'sortBy': "'tknCde'", // String | Attribute whose value will be used to order the returned response
  'sortOrder': "'ascending'", // String | Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"
  'fieldValuePair': grtTyp=client_credentials,tknTyp=access_token // String | Field and value pair for seraching
};
apiInstance.searchToken(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]
 **pattern** | **String**| Search pattern | [optional] [default to &#39;&#39;]
 **startIndex** | **Number**| The 1-based index of the first query result | [optional] [default to 0]
 **sortBy** | **String**| Attribute whose value will be used to order the returned response | [optional] [default to &#39;tknCde&#39;]
 **sortOrder** | **String**| Order in which the sortBy param is applied. Allowed values are \&quot;ascending\&quot; and \&quot;descending\&quot; | [optional] [default to &#39;ascending&#39;]
 **fieldValuePair** | **String**| Field and value pair for seraching | [optional] [default to &#39;&#39;]

### Return type

[**TokenEntityPagedResult**](TokenEntityPagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

