# JansConfigApi.SAMLTrustRelationshipApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteTrustRelationship**](SAMLTrustRelationshipApi.md#deleteTrustRelationship) | **DELETE** /kc/saml/trust-relationship/{id} | Delete TrustRelationship
[**getTrustRelationshipById**](SAMLTrustRelationshipApi.md#getTrustRelationshipById) | **GET** /kc/saml/trust-relationship/id/{id} | Get TrustRelationship by Id
[**getTrustRelationshipFileMetadata**](SAMLTrustRelationshipApi.md#getTrustRelationshipFileMetadata) | **GET** /kc/saml/trust-relationship/sp-metadata-file/{id} | Get TrustRelationship file metadata
[**getTrustRelationships**](SAMLTrustRelationshipApi.md#getTrustRelationships) | **GET** /kc/saml/trust-relationship | Get all Trust Relationship
[**postTrustRelationshipMetadataFile**](SAMLTrustRelationshipApi.md#postTrustRelationshipMetadataFile) | **POST** /kc/saml/trust-relationship/upload | Create Trust Relationship with Metadata File
[**putTrustRelationship**](SAMLTrustRelationshipApi.md#putTrustRelationship) | **PUT** /kc/saml/trust-relationship/upload | Update TrustRelationship



## deleteTrustRelationship

> deleteTrustRelationship(id)

Delete TrustRelationship

Delete TrustRelationship

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLTrustRelationshipApi();
let id = "id_example"; // String | Unique Id of Trust Relationship
apiInstance.deleteTrustRelationship(id, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Unique Id of Trust Relationship | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getTrustRelationshipById

> TrustRelationship getTrustRelationshipById(id)

Get TrustRelationship by Id

Get TrustRelationship by Id

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLTrustRelationshipApi();
let id = "id_example"; // String | Unique identifier - Id
apiInstance.getTrustRelationshipById(id, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Unique identifier - Id | 

### Return type

[**TrustRelationship**](TrustRelationship.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getTrustRelationshipFileMetadata

> File getTrustRelationshipFileMetadata(id)

Get TrustRelationship file metadata

Get TrustRelationship file metadata

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLTrustRelationshipApi();
let id = "id_example"; // String | TrustRelationship inum
apiInstance.getTrustRelationshipFileMetadata(id, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| TrustRelationship inum | 

### Return type

**File**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/xml, application/json


## getTrustRelationships

> [TrustRelationship] getTrustRelationships()

Get all Trust Relationship

Get all TrustRelationship.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLTrustRelationshipApi();
apiInstance.getTrustRelationships((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**[TrustRelationship]**](TrustRelationship.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## postTrustRelationshipMetadataFile

> TrustRelationship postTrustRelationshipMetadataFile(trustRelationship, metaDataFile)

Create Trust Relationship with Metadata File

Create Trust Relationship with Metadata File

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLTrustRelationshipApi();
let trustRelationship = new JansConfigApi.TrustRelationship(); // TrustRelationship | 
let metaDataFile = "/path/to/file"; // File | 
apiInstance.postTrustRelationshipMetadataFile(trustRelationship, metaDataFile, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trustRelationship** | [**TrustRelationship**](TrustRelationship.md)|  | 
 **metaDataFile** | **File**|  | 

### Return type

[**TrustRelationship**](TrustRelationship.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: multipart/form-data
- **Accept**: application/json


## putTrustRelationship

> TrustRelationship putTrustRelationship(trustRelationship, metaDataFile)

Update TrustRelationship

Update TrustRelationship

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLTrustRelationshipApi();
let trustRelationship = new JansConfigApi.TrustRelationship(); // TrustRelationship | 
let metaDataFile = "/path/to/file"; // File | 
apiInstance.putTrustRelationship(trustRelationship, metaDataFile, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trustRelationship** | [**TrustRelationship**](TrustRelationship.md)|  | 
 **metaDataFile** | **File**|  | 

### Return type

[**TrustRelationship**](TrustRelationship.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: multipart/form-data
- **Accept**: application/json

