# JansConfigApi.SAMLConfigurationApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getSamlProperties**](SAMLConfigurationApi.md#getSamlProperties) | **GET** /kc/samlConfig | Gets SAML configuration properties
[**patchSamlProperties**](SAMLConfigurationApi.md#patchSamlProperties) | **PATCH** /kc/samlConfig | Partially modifies SAML configuration properties.
[**putSamlProperties**](SAMLConfigurationApi.md#putSamlProperties) | **PUT** /kc/samlConfig | Update SAML configuration properties



## getSamlProperties

> SamlAppConfiguration getSamlProperties()

Gets SAML configuration properties

Gets SAML configuration properties

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLConfigurationApi();
apiInstance.getSamlProperties((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**SamlAppConfiguration**](SamlAppConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchSamlProperties

> SamlAppConfiguration patchSamlProperties(opts)

Partially modifies SAML configuration properties.

Partially modifies SAML Configuration properties.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLConfigurationApi();
let opts = {
  'requestBody': [{
    "op": "replace",
    "path": "/samlEnabled",
    "value": false
},
{
   "op": "add",
    "path": "/idpConfigs/1",
    "value":  {
            "configId": "shibboleth",
            "rootDir": "/opt/idp/configs/shibboleth",
            "enabled": false,
            "metadataTempDir": "/opt/idp/configs/shibboleth/temp_metadata",
            "metadataDir": "/opt/idp/configs/shibboleth/metadata",
            "metadataFilePattern": "%s-idp-metadata.xml"
        }
}
]
 // [Object] | String representing patch-document.
};
apiInstance.patchSamlProperties(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**SamlAppConfiguration**](SamlAppConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## putSamlProperties

> SamlAppConfiguration putSamlProperties(opts)

Update SAML configuration properties

Update SAML configuration properties

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SAMLConfigurationApi();
let opts = {
  'samlAppConfiguration': {
  "applicationName":"saml",
  "samlTrustRelationshipDn":"ou=trustRelationships,o=jans",
  "samlEnabled": "true",
  "selectedIdp": "keycloak",
  "idpRootDir": "/opt/idp/configs/",
  "idpMetadataFilePattern":"%s-idp-metadata.xml",
  "spMetadataFilePattern":"%s-sp-metadata.xml",
  "idpConfigs":[
    {
      "configId":"keycloak",
      "rootDir":"/opt/idp/configs/keycloak",
      "enabled": "true",
      "metadataTempDir": "/opt/idp/configs/keycloak/temp_metadata",
      "metadataDir":"/opt/idp/configs/keycloak/metadata",
      "metadataFilePattern":"%s-idp-metadata.xml"
    }
  ]
}
 // SamlAppConfiguration | GluuAttribute object
};
apiInstance.putSamlProperties(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **samlAppConfiguration** | [**SamlAppConfiguration**](SamlAppConfiguration.md)| GluuAttribute object | [optional] 

### Return type

[**SamlAppConfiguration**](SamlAppConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

