# JansConfigApi.OAuthUMAResourcesApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteOauthUmaResourcesById**](OAuthUMAResourcesApi.md#deleteOauthUmaResourcesById) | **DELETE** /api/v1/uma/resources/{id} | Deletes an UMA resource
[**getOauthUmaResources**](OAuthUMAResourcesApi.md#getOauthUmaResources) | **GET** /api/v1/uma/resources | Gets list of UMA resources
[**getOauthUmaResourcesByClientid**](OAuthUMAResourcesApi.md#getOauthUmaResourcesByClientid) | **GET** /api/v1/uma/resources/clientId/{clientId} | Fetch uma resources by client id
[**getOauthUmaResourcesById**](OAuthUMAResourcesApi.md#getOauthUmaResourcesById) | **GET** /api/v1/uma/resources/{id} | Gets an UMA resource by ID
[**patchOauthUmaResourcesById**](OAuthUMAResourcesApi.md#patchOauthUmaResourcesById) | **PATCH** /api/v1/uma/resources/{id} | Patch UMA resource
[**postOauthUmaResources**](OAuthUMAResourcesApi.md#postOauthUmaResources) | **POST** /api/v1/uma/resources | Creates an UMA resource
[**putOauthUmaResources**](OAuthUMAResourcesApi.md#putOauthUmaResources) | **PUT** /api/v1/uma/resources | Updates an UMA resource



## deleteOauthUmaResourcesById

> deleteOauthUmaResourcesById(id)

Deletes an UMA resource

Deletes an UMA resource

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthUMAResourcesApi();
let id = "id_example"; // String | Resource description ID
apiInstance.deleteOauthUmaResourcesById(id, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Resource description ID | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getOauthUmaResources

> PagedResult getOauthUmaResources(opts)

Gets list of UMA resources

Gets list of UMA resources

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthUMAResourcesApi();
let opts = {
  'limit': 50, // Number | Search size - max size of the results to return
  'pattern': "''", // String | Search pattern
  'startIndex': 0, // Number | The 1-based index of the first query result
  'sortBy': "'inum'", // String | Attribute whose value will be used to order the returned response
  'sortOrder': "'ascending'", // String | Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"
  'fieldValuePair': deletable=true // String | Field and value pair for seraching
};
apiInstance.getOauthUmaResources(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]
 **pattern** | **String**| Search pattern | [optional] [default to &#39;&#39;]
 **startIndex** | **Number**| The 1-based index of the first query result | [optional] [default to 0]
 **sortBy** | **String**| Attribute whose value will be used to order the returned response | [optional] [default to &#39;inum&#39;]
 **sortOrder** | **String**| Order in which the sortBy param is applied. Allowed values are \&quot;ascending\&quot; and \&quot;descending\&quot; | [optional] [default to &#39;ascending&#39;]
 **fieldValuePair** | **String**| Field and value pair for seraching | [optional] [default to &#39;&#39;]

### Return type

[**PagedResult**](PagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getOauthUmaResourcesByClientid

> [UmaResource] getOauthUmaResourcesByClientid(clientId)

Fetch uma resources by client id

Fetch uma resources by client id

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthUMAResourcesApi();
let clientId = "clientId_example"; // String | Client ID
apiInstance.getOauthUmaResourcesByClientid(clientId, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **clientId** | **String**| Client ID | 

### Return type

[**[UmaResource]**](UmaResource.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getOauthUmaResourcesById

> UmaResource getOauthUmaResourcesById(id)

Gets an UMA resource by ID

Gets an UMA resource by ID

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthUMAResourcesApi();
let id = "id_example"; // String | Resource description ID
apiInstance.getOauthUmaResourcesById(id, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Resource description ID | 

### Return type

[**UmaResource**](UmaResource.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchOauthUmaResourcesById

> UmaResource patchOauthUmaResourcesById(id, opts)

Patch UMA resource

Patch UMA resource

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthUMAResourcesApi();
let id = "id_example"; // String | Resource description ID
let opts = {
  'requestBody': example/uma/resources/uma-resources-patch // [Object] | String representing patch-document.
};
apiInstance.patchOauthUmaResourcesById(id, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **String**| Resource description ID | 
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**UmaResource**](UmaResource.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## postOauthUmaResources

> UmaResource postOauthUmaResources(opts)

Creates an UMA resource

Creates an UMA resource

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthUMAResourcesApi();
let opts = {
  'umaResource':  {
        "name": "config-api-resource",
        "iconUri": "https://config-api.com",
        "clients": [
            "inum=1800.e9131b86-f39f-421c-9dde-b7f90c21a2fe,ou=clients,o=jans"
        ],
        "scopes":[
            "inum=ab47c599-d188-44b6-a32a-91e6b173856a,ou=scopes,o=jans"
        ],
        "description": "Uma resource config api",
        "deletable": false
    }
 // UmaResource | UmaResource object
};
apiInstance.postOauthUmaResources(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **umaResource** | [**UmaResource**](UmaResource.md)| UmaResource object | [optional] 

### Return type

[**UmaResource**](UmaResource.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## putOauthUmaResources

> UmaResource putOauthUmaResources(opts)

Updates an UMA resource

Updates an UMA resource

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.OAuthUMAResourcesApi();
let opts = {
  'umaResource': {
    "dn": "jansId=55d70ecd-8572-43dd-895f-ecfaf09bf513,ou=resources,ou=uma,o=jans",
    "id": "55d70ecd-8572-43dd-895f-ecfaf09bf513",
    "name": "config-api-resource",
    "iconUri": "https://config-api.com",
    "scopes": [
        "inum=ab47c599-d188-44b6-a32a-91e6b173856a,ou=scopes,o=jans"
    ],
    "clients": [
        "inum=1800.e9131b86-f39f-421c-9dde-b7f90c21a2fe,ou=clients,o=jans"
    ],
    "description": "Uma resource config api",
    "deletable": false
}
 // UmaResource | UmaResource object
};
apiInstance.putOauthUmaResources(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **umaResource** | [**UmaResource**](UmaResource.md)| UmaResource object | [optional] 

### Return type

[**UmaResource**](UmaResource.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

