# JansConfigApi.LockConfigurationApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getLockProperties**](LockConfigurationApi.md#getLockProperties) | **GET** /lock/lockConfig | Gets Lock configuration properties
[**patchLockProperties**](LockConfigurationApi.md#patchLockProperties) | **PATCH** /lock/lockConfig | Partially modifies Lock configuration properties.
[**putLockProperties**](LockConfigurationApi.md#putLockProperties) | **PUT** /lock/lockConfig | Update Lock configuration properties



## getLockProperties

> AppConfiguration5 getLockProperties()

Gets Lock configuration properties

Gets Lock configuration properties

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.LockConfigurationApi();
apiInstance.getLockProperties((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**AppConfiguration5**](AppConfiguration5.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchLockProperties

> AppConfiguration5 patchLockProperties(opts)

Partially modifies Lock configuration properties.

Partially modifies Lock configuration properties.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.LockConfigurationApi();
let opts = {
  'requestBody':  // [Object] | String representing patch-document.
};
apiInstance.patchLockProperties(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**AppConfiguration5**](AppConfiguration5.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## putLockProperties

> AppConfiguration5 putLockProperties(opts)

Update Lock configuration properties

Update Lock configuration properties

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.LockConfigurationApi();
let opts = {
  'appConfiguration5':  // AppConfiguration5 | GluuAttribute object
};
apiInstance.putLockProperties(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **appConfiguration5** | [**AppConfiguration5**](AppConfiguration5.md)| GluuAttribute object | [optional] 

### Return type

[**AppConfiguration5**](AppConfiguration5.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

