# JansConfigApi.Fido2RegistrationApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteFido2Data**](Fido2RegistrationApi.md#deleteFido2Data) | **DELETE** /fido2/registration/id/{jansId} | Delete Fido2 Device Data based on device UID
[**getFido2ById**](Fido2RegistrationApi.md#getFido2ById) | **GET** /fido2/registration/id/{jansId} | Fetch Fido2RegistrationEntry by Id.
[**getRegistrationEntriesFido2**](Fido2RegistrationApi.md#getRegistrationEntriesFido2) | **GET** /fido2/registration/entries/{username} | Get details of connected FIDO2 devices registered to user
[**searchFido2RegistrationData**](Fido2RegistrationApi.md#searchFido2RegistrationData) | **GET** /fido2/registration | Get a list of Fido2RegistrationEntry.



## deleteFido2Data

> deleteFido2Data(jansId)

Delete Fido2 Device Data based on device UID

Delete Fido2 Device Data based on device UID

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.Fido2RegistrationApi();
let jansId = "jansId_example"; // String | Fido2Registration Unique identifier.
apiInstance.deleteFido2Data(jansId, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **jansId** | **String**| Fido2Registration Unique identifier. | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getFido2ById

> Fido2RegistrationEntry getFido2ById(jansId)

Fetch Fido2RegistrationEntry by Id.

Fetch Fido2RegistrationEntry by Id.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.Fido2RegistrationApi();
let jansId = "jansId_example"; // String | Fido2Registration identifier
apiInstance.getFido2ById(jansId, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **jansId** | **String**| Fido2Registration identifier | 

### Return type

[**Fido2RegistrationEntry**](Fido2RegistrationEntry.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getRegistrationEntriesFido2

> Fido2RegistrationEntryPagedResult getRegistrationEntriesFido2(username)

Get details of connected FIDO2 devices registered to user

Get details of connected FIDO2 devices registered to user

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.Fido2RegistrationApi();
let username = "username_example"; // String | User name
apiInstance.getRegistrationEntriesFido2(username, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **username** | **String**| User name | 

### Return type

[**Fido2RegistrationEntryPagedResult**](Fido2RegistrationEntryPagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## searchFido2RegistrationData

> Fido2RegistrationEntryPagedResult searchFido2RegistrationData(opts)

Get a list of Fido2RegistrationEntry.

Get a list of Fido2RegistrationEntry.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.Fido2RegistrationApi();
let opts = {
  'limit': 50, // Number | Search size - max size of the results to return
  'pattern': "''", // String | Search pattern
  'startIndex': 0, // Number | The 1-based index of the first query result
  'sortBy': "'jansId'", // String | Data whose value will be used to order the returned response
  'sortOrder': "'ascending'", // String | Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"
  'fieldValuePair': mail=abc@mail.com,jansStatus=true // String | Field and value pair for seraching
};
apiInstance.searchFido2RegistrationData(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]
 **pattern** | **String**| Search pattern | [optional] [default to &#39;&#39;]
 **startIndex** | **Number**| The 1-based index of the first query result | [optional] [default to 0]
 **sortBy** | **String**| Data whose value will be used to order the returned response | [optional] [default to &#39;jansId&#39;]
 **sortOrder** | **String**| Order in which the sortBy param is applied. Allowed values are \&quot;ascending\&quot; and \&quot;descending\&quot; | [optional] [default to &#39;ascending&#39;]
 **fieldValuePair** | **String**| Field and value pair for seraching | [optional] [default to &#39;&#39;]

### Return type

[**Fido2RegistrationEntryPagedResult**](Fido2RegistrationEntryPagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

