# JansConfigApi.DatabaseLDAPConfigurationApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteConfigDatabaseLdapByName**](DatabaseLDAPConfigurationApi.md#deleteConfigDatabaseLdapByName) | **DELETE** /api/v1/config/database/ldap/{name} | Deletes an LDAP configuration
[**getConfigDatabaseLdap**](DatabaseLDAPConfigurationApi.md#getConfigDatabaseLdap) | **GET** /api/v1/config/database/ldap | Gets list of existing LDAP configurations.
[**getConfigDatabaseLdapByName**](DatabaseLDAPConfigurationApi.md#getConfigDatabaseLdapByName) | **GET** /api/v1/config/database/ldap/{name} | Gets an LDAP configuration by name.
[**patchConfigDatabaseLdapByName**](DatabaseLDAPConfigurationApi.md#patchConfigDatabaseLdapByName) | **PATCH** /api/v1/config/database/ldap/{name} | Patches a LDAP configuration by name
[**postConfigDatabaseLdap**](DatabaseLDAPConfigurationApi.md#postConfigDatabaseLdap) | **POST** /api/v1/config/database/ldap | Adds a new LDAP configuration
[**postConfigDatabaseLdapTest**](DatabaseLDAPConfigurationApi.md#postConfigDatabaseLdapTest) | **POST** /api/v1/config/database/ldap/test | Tests an LDAP configuration
[**putConfigDatabaseLdap**](DatabaseLDAPConfigurationApi.md#putConfigDatabaseLdap) | **PUT** /api/v1/config/database/ldap | Updates LDAP configuration



## deleteConfigDatabaseLdapByName

> GluuLdapConfiguration deleteConfigDatabaseLdapByName(name)

Deletes an LDAP configuration

Deletes an LDAP configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.DatabaseLDAPConfigurationApi();
let name = "name_example"; // String | 
apiInstance.deleteConfigDatabaseLdapByName(name, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**|  | 

### Return type

[**GluuLdapConfiguration**](GluuLdapConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getConfigDatabaseLdap

> [GluuLdapConfiguration] getConfigDatabaseLdap()

Gets list of existing LDAP configurations.

Gets list of existing LDAP configurations.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.DatabaseLDAPConfigurationApi();
apiInstance.getConfigDatabaseLdap((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**[GluuLdapConfiguration]**](GluuLdapConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getConfigDatabaseLdapByName

> GluuLdapConfiguration getConfigDatabaseLdapByName(name)

Gets an LDAP configuration by name.

Gets an LDAP configuration by name.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.DatabaseLDAPConfigurationApi();
let name = "name_example"; // String | Name of LDAP configuration
apiInstance.getConfigDatabaseLdapByName(name, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Name of LDAP configuration | 

### Return type

[**GluuLdapConfiguration**](GluuLdapConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchConfigDatabaseLdapByName

> GluuLdapConfiguration patchConfigDatabaseLdapByName(name, opts)

Patches a LDAP configuration by name

Patches a LDAP configuration by name

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.DatabaseLDAPConfigurationApi();
let name = "name_example"; // String | Name of LDAP configuration
let opts = {
  'requestBody': example/auth/database/ldap/ldap-patch // [Object] | JsonPatch object
};
apiInstance.patchConfigDatabaseLdapByName(name, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Name of LDAP configuration | 
 **requestBody** | [**[Object]**](Object.md)| JsonPatch object | [optional] 

### Return type

[**GluuLdapConfiguration**](GluuLdapConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## postConfigDatabaseLdap

> GluuLdapConfiguration postConfigDatabaseLdap(opts)

Adds a new LDAP configuration

Adds a new LDAP configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.DatabaseLDAPConfigurationApi();
let opts = {
  'gluuLdapConfiguration': {
    "configId": "auth_ldap_server",
    "bindDN": "cn=directory manager",
    "bindPassword": "axby+nlegh9DhpQ==",
    "servers": [
        "jans.server2:1636"
    ],
    "maxConnections": 1000,
    "useSSL": true,
    "baseDNs": [
        "ou=people,o=jans"
    ],
    "primaryKey": "uid",
    "localPrimaryKey": "uid",
    "useAnonymousBind": false,
    "enabled": false,
    "version": 0,
    "level": 0
}
 // GluuLdapConfiguration | GluuLdapConfiguration object
};
apiInstance.postConfigDatabaseLdap(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **gluuLdapConfiguration** | [**GluuLdapConfiguration**](GluuLdapConfiguration.md)| GluuLdapConfiguration object | [optional] 

### Return type

[**GluuLdapConfiguration**](GluuLdapConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## postConfigDatabaseLdapTest

> Boolean postConfigDatabaseLdapTest(opts)

Tests an LDAP configuration

Tests an LDAP configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.DatabaseLDAPConfigurationApi();
let opts = {
  'gluuLdapConfiguration': [{ "op": "replace", "path": "/maxConnections", "value":800}] 
 // GluuLdapConfiguration | GluuLdapConfiguration object
};
apiInstance.postConfigDatabaseLdapTest(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **gluuLdapConfiguration** | [**GluuLdapConfiguration**](GluuLdapConfiguration.md)| GluuLdapConfiguration object | [optional] 

### Return type

**Boolean**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## putConfigDatabaseLdap

> GluuLdapConfiguration putConfigDatabaseLdap(opts)

Updates LDAP configuration

Updates LDAP configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.DatabaseLDAPConfigurationApi();
let opts = {
  'gluuLdapConfiguration': {
    "configId": "auth_ldap_server",
    "bindDN": "cn=directory manager",
    "bindPassword": "axby+nlegh9DhpQ==",
    "servers": [
        "jans.server2:1636"
    ],
    "maxConnections": 1000,
    "useSSL": true,
    "baseDNs": [
        "ou=people,o=jans"
    ],
    "primaryKey": "uid",
    "localPrimaryKey": "uid",
    "useAnonymousBind": false,
    "enabled": false,
    "version": 0,
    "level": 0
}
 // GluuLdapConfiguration | GluuLdapConfiguration object
};
apiInstance.putConfigDatabaseLdap(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **gluuLdapConfiguration** | [**GluuLdapConfiguration**](GluuLdapConfiguration.md)| GluuLdapConfiguration object | [optional] 

### Return type

[**GluuLdapConfiguration**](GluuLdapConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

