# JansConfigApi.CustomScriptsApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteConfigScriptsByInum**](CustomScriptsApi.md#deleteConfigScriptsByInum) | **DELETE** /api/v1/config/scripts/{inum} | Deletes a custom script
[**getConfigScripts**](CustomScriptsApi.md#getConfigScripts) | **GET** /api/v1/config/scripts | Gets a list of custom scripts
[**getConfigScriptsByInum**](CustomScriptsApi.md#getConfigScriptsByInum) | **GET** /api/v1/config/scripts/inum/{inum} | Gets a script by Inum
[**getConfigScriptsByType**](CustomScriptsApi.md#getConfigScriptsByType) | **GET** /api/v1/config/scripts/type/{type} | Gets list of scripts by type
[**getCustomScriptByName**](CustomScriptsApi.md#getCustomScriptByName) | **GET** /api/v1/config/scripts/name/{name} | Fetch custom script by name
[**getCustomScriptType**](CustomScriptsApi.md#getCustomScriptType) | **GET** /api/v1/config/scripts/types | Fetch custom script types
[**getCustomScriptTypes**](CustomScriptsApi.md#getCustomScriptTypes) | **GET** /api/v1/config/scripts/script-types | Fetch custom script types
[**patchConfigScriptsByInum**](CustomScriptsApi.md#patchConfigScriptsByInum) | **PATCH** /api/v1/config/scripts/{inum} | Patches a custom script
[**postConfigScripts**](CustomScriptsApi.md#postConfigScripts) | **POST** /api/v1/config/scripts | Adds a new custom script
[**putConfigScripts**](CustomScriptsApi.md#putConfigScripts) | **PUT** /api/v1/config/scripts | Updates a custom script



## deleteConfigScriptsByInum

> deleteConfigScriptsByInum(inum)

Deletes a custom script

Deletes a custom script

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CustomScriptsApi();
let inum = "inum_example"; // String | Script identifier
apiInstance.deleteConfigScriptsByInum(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Script identifier | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getConfigScripts

> PagedResult getConfigScripts(opts)

Gets a list of custom scripts

Gets a list of custom scripts

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CustomScriptsApi();
let opts = {
  'limit': 50, // Number | Search size - max size of the results to return
  'pattern': "''", // String | Search pattern
  'startIndex': 0, // Number | The 1-based index of the first query result
  'sortBy': "'inum'", // String | Attribute whose value will be used to order the returned response
  'sortOrder': "'ascending'", // String | Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"
  'fieldValuePair': adminCanEdit=true,dataType=string // String | Field and value pair for seraching
};
apiInstance.getConfigScripts(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]
 **pattern** | **String**| Search pattern | [optional] [default to &#39;&#39;]
 **startIndex** | **Number**| The 1-based index of the first query result | [optional] [default to 0]
 **sortBy** | **String**| Attribute whose value will be used to order the returned response | [optional] [default to &#39;inum&#39;]
 **sortOrder** | **String**| Order in which the sortBy param is applied. Allowed values are \&quot;ascending\&quot; and \&quot;descending\&quot; | [optional] [default to &#39;ascending&#39;]
 **fieldValuePair** | **String**| Field and value pair for seraching | [optional] [default to &#39;&#39;]

### Return type

[**PagedResult**](PagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getConfigScriptsByInum

> CustomScript getConfigScriptsByInum(inum)

Gets a script by Inum

Gets a script by Inum

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CustomScriptsApi();
let inum = "inum_example"; // String | Script identifier
apiInstance.getConfigScriptsByInum(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Script identifier | 

### Return type

[**CustomScript**](CustomScript.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getConfigScriptsByType

> PagedResult getConfigScriptsByType(type, opts)

Gets list of scripts by type

Gets list of scripts by type

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CustomScriptsApi();
let type = "type_example"; // String | Script type
let opts = {
  'limit': 50, // Number | Search size - max size of the results to return
  'pattern': "''", // String | Search pattern
  'startIndex': 0, // Number | The 1-based index of the first query result
  'sortBy': "'inum'", // String | Attribute whose value will be used to order the returned response
  'sortOrder': "'ascending'", // String | Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"
  'fieldValuePair': adminCanEdit=true,dataType=string // String | Field and value pair for seraching
};
apiInstance.getConfigScriptsByType(type, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **String**| Script type | 
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]
 **pattern** | **String**| Search pattern | [optional] [default to &#39;&#39;]
 **startIndex** | **Number**| The 1-based index of the first query result | [optional] [default to 0]
 **sortBy** | **String**| Attribute whose value will be used to order the returned response | [optional] [default to &#39;inum&#39;]
 **sortOrder** | **String**| Order in which the sortBy param is applied. Allowed values are \&quot;ascending\&quot; and \&quot;descending\&quot; | [optional] [default to &#39;ascending&#39;]
 **fieldValuePair** | **String**| Field and value pair for seraching | [optional] [default to &#39;&#39;]

### Return type

[**PagedResult**](PagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getCustomScriptByName

> CustomScript getCustomScriptByName(name)

Fetch custom script by name

Fetch custom script by name

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CustomScriptsApi();
let name = "name_example"; // String | Script name
apiInstance.getCustomScriptByName(name, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Script name | 

### Return type

[**CustomScript**](CustomScript.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getCustomScriptType

> [String] getCustomScriptType()

Fetch custom script types

Fetch custom script types

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CustomScriptsApi();
apiInstance.getCustomScriptType((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

**[String]**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getCustomScriptTypes

> [String] getCustomScriptTypes()

Fetch custom script types

Fetch custom script types

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CustomScriptsApi();
apiInstance.getCustomScriptTypes((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

**[String]**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchConfigScriptsByInum

> CustomScript patchConfigScriptsByInum(inum, opts)

Patches a custom script

Patches a custom script

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CustomScriptsApi();
let inum = "inum_example"; // String | Script identifier
let opts = {
  'requestBody': [{ "op": "replace", "path": "/enabled", "value":false},{ "op": "replace", "path": "/revision", "value":2}] 
 // [Object] | JsonPatch object
};
apiInstance.patchConfigScriptsByInum(inum, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Script identifier | 
 **requestBody** | [**[Object]**](Object.md)| JsonPatch object | [optional] 

### Return type

[**CustomScript**](CustomScript.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## postConfigScripts

> CustomScript postConfigScripts(opts)

Adds a new custom script

Adds a new custom script

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CustomScriptsApi();
let opts = {
  'addScriptTemplate': false, // Boolean | Boolean flag to indicate if script template is to be added. If CustomScript request object has script populated then script template will not be added.
  'customScript': {
            "name": "test_application_session_test",
            "description": "Sample Application Session script",
            "script": "# oxAuth is available under the MIT License (2008). See http://opensource.org/licenses/MIT for full text.\n# Copyright (c) 2016, Janssen\n#\n# Author: Yuriy Movchan\n#\n\nfrom io.jans.model.custom.script.type.session import ApplicationSessionType\nfrom io.jans.service.cdi.util import CdiUtil\nfrom io.jans.persist import PersistenceEntryManager\nfrom io.jans.as.model.config import StaticConfiguration\nfrom io.jans.as.model.ldap import TokenEntity\nfrom jakarta.faces.application import FacesMessage\nfrom io.jans.jsf2.message import FacesMessages\nfrom io.jans.util import StringHelper, ArrayHelper\nfrom io.jans.as.model.config import Constants\nfrom java.util import Arrays, ArrayList\nfrom io.jans.as.service.external.session import SessionEventType\n\nimport java\n\nclass ApplicationSession(ApplicationSessionType):\n    def __init__(self, currentTimeMillis):\n        self.currentTimeMillis = currentTimeMillis\n\n    def init(self, customScript, configurationAttributes):\n        print \"Application session. Initialization\"\n\n        self.entryManager = CdiUtil.bean(PersistenceEntryManager)\n        self.staticConfiguration = CdiUtil.bean(StaticConfiguration)\n\n        print \"Application session. Initialized successfully\"\n\n        return True   \n\n    def destroy(self, configurationAttributes):\n        print \"Application session. Destroy\"\n        print \"Application session. Destroyed successfully\"\n        return True   \n\n    def getApiVersion(self):\n        return 11\n\n    # Called each time specific session event occurs\n    # event is io.jans.as.service.external.session.SessionEvent\n    def onEvent(self, event):\n        if event.getType() == SessionEventType.AUTHENTICATED:\n            print \"Session is authenticated, session: \" + event.getSessionId().getId()\n        return\n\n    # Application calls it at start session request to allow notify 3rd part systems\n    #   httpRequest is jakarta.servlet.http.HttpServletRequest\n    #   sessionId is io.jans.as.model.common.SessionId\n    #   configurationAttributes is java.util.Map<String, SimpleCustomProperty>\n    def startSession(self, httpRequest, sessionId, configurationAttributes):\n        print \"Application session. Starting external session\"\n\n        user_name = sessionId.getSessionAttributes().get(Constants.AUTHENTICATED_USER)\n\n        first_session = self.isFirstSession(user_name)\n        if not first_session:\n            facesMessages = CdiUtil.bean(FacesMessages)\n            facesMessages.add(FacesMessage.SEVERITY_ERROR, \"Please, end active session first!\")\n            return False\n\n        print \"Application session. External session started successfully\"\n        return True\n\n    # Application calls it at end session request to allow notify 3rd part systems\n    #   httpRequest is jakarta.servlet.http.HttpServletRequest\n    #   sessionId is io.jans.as.model.common.SessionId\n    #   configurationAttributes is java.util.Map<String, SimpleCustomProperty>\n    def endSession(self, httpRequest, sessionId, configurationAttributes):\n        print \"Application session. Starting external session end\"\n\n        print \"Application session. External session ended successfully\"\n        return True\n\n    # Application calls it during /session/active endpoint call to modify response if needed\n    #   jsonArray is org.json.JSONArray\n    #   context is io.jans.as.server.model.common.ExecutionContext\n    def modifyActiveSessionsResponse(self, jsonArray, context):\n        return False\n\n    def isFirstSession(self, user_name):\n        tokenLdap = TokenEntity()\n        tokenLdap.setDn(self.staticConfiguration.getBaseDn().getClients())\n        tokenLdap.setUserId(user_name)\n\n        tokenLdapList = self.entryManager.findEntries(tokenLdap, 1)\n        print \"Application session. isFirstSession. Get result: '%s'\" % tokenLdapList\n\n        if (tokenLdapList != None) and (tokenLdapList.size() > 0):\n            print \"Application session. isFirstSession: False\"\n            return False\n\n        print \"Application session. isFirstSession: True\"\n        return True\n",
            "scriptType": "application_session",
            "programmingLanguage": "python",
            "moduleProperties": [
                {
                    "value1": "location_type",
                    "value2": "ldap"
                }
            ],
            "level": 800,
            "revision": 8,
            "enabled": false,
            "modified": false,
            "internal": false,
            "locationType": "ldap"
        }
 // CustomScript | CustomScript object
};
apiInstance.postConfigScripts(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **addScriptTemplate** | **Boolean**| Boolean flag to indicate if script template is to be added. If CustomScript request object has script populated then script template will not be added. | [optional] [default to false]
 **customScript** | [**CustomScript**](CustomScript.md)| CustomScript object | [optional] 

### Return type

[**CustomScript**](CustomScript.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## putConfigScripts

> CustomScript putConfigScripts(opts)

Updates a custom script

Updates a custom script

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CustomScriptsApi();
let opts = {
  'customScript': {
            "name": "test_application_session_test",
            "description": "Sample Application Session script",
            "script": "# oxAuth is available under the MIT License (2008). See http://opensource.org/licenses/MIT for full text.\n# Copyright (c) 2016, Janssen\n#\n# Author: Yuriy Movchan\n#\n\nfrom io.jans.model.custom.script.type.session import ApplicationSessionType\nfrom io.jans.service.cdi.util import CdiUtil\nfrom io.jans.persist import PersistenceEntryManager\nfrom io.jans.as.model.config import StaticConfiguration\nfrom io.jans.as.model.ldap import TokenEntity\nfrom jakarta.faces.application import FacesMessage\nfrom io.jans.jsf2.message import FacesMessages\nfrom io.jans.util import StringHelper, ArrayHelper\nfrom io.jans.as.model.config import Constants\nfrom java.util import Arrays, ArrayList\nfrom io.jans.as.service.external.session import SessionEventType\n\nimport java\n\nclass ApplicationSession(ApplicationSessionType):\n    def __init__(self, currentTimeMillis):\n        self.currentTimeMillis = currentTimeMillis\n\n    def init(self, customScript, configurationAttributes):\n        print \"Application session. Initialization\"\n\n        self.entryManager = CdiUtil.bean(PersistenceEntryManager)\n        self.staticConfiguration = CdiUtil.bean(StaticConfiguration)\n\n        print \"Application session. Initialized successfully\"\n\n        return True   \n\n    def destroy(self, configurationAttributes):\n        print \"Application session. Destroy\"\n        print \"Application session. Destroyed successfully\"\n        return True   \n\n    def getApiVersion(self):\n        return 11\n\n    # Called each time specific session event occurs\n    # event is io.jans.as.service.external.session.SessionEvent\n    def onEvent(self, event):\n        if event.getType() == SessionEventType.AUTHENTICATED:\n            print \"Session is authenticated, session: \" + event.getSessionId().getId()\n        return\n\n    # Application calls it at start session request to allow notify 3rd part systems\n    #   httpRequest is jakarta.servlet.http.HttpServletRequest\n    #   sessionId is io.jans.as.model.common.SessionId\n    #   configurationAttributes is java.util.Map<String, SimpleCustomProperty>\n    def startSession(self, httpRequest, sessionId, configurationAttributes):\n        print \"Application session. Starting external session\"\n\n        user_name = sessionId.getSessionAttributes().get(Constants.AUTHENTICATED_USER)\n\n        first_session = self.isFirstSession(user_name)\n        if not first_session:\n            facesMessages = CdiUtil.bean(FacesMessages)\n            facesMessages.add(FacesMessage.SEVERITY_ERROR, \"Please, end active session first!\")\n            return False\n\n        print \"Application session. External session started successfully\"\n        return True\n\n    # Application calls it at end session request to allow notify 3rd part systems\n    #   httpRequest is jakarta.servlet.http.HttpServletRequest\n    #   sessionId is io.jans.as.model.common.SessionId\n    #   configurationAttributes is java.util.Map<String, SimpleCustomProperty>\n    def endSession(self, httpRequest, sessionId, configurationAttributes):\n        print \"Application session. Starting external session end\"\n\n        print \"Application session. External session ended successfully\"\n        return True\n\n    # Application calls it during /session/active endpoint call to modify response if needed\n    #   jsonArray is org.json.JSONArray\n    #   context is io.jans.as.server.model.common.ExecutionContext\n    def modifyActiveSessionsResponse(self, jsonArray, context):\n        return False\n\n    def isFirstSession(self, user_name):\n        tokenLdap = TokenEntity()\n        tokenLdap.setDn(self.staticConfiguration.getBaseDn().getClients())\n        tokenLdap.setUserId(user_name)\n\n        tokenLdapList = self.entryManager.findEntries(tokenLdap, 1)\n        print \"Application session. isFirstSession. Get result: '%s'\" % tokenLdapList\n\n        if (tokenLdapList != None) and (tokenLdapList.size() > 0):\n            print \"Application session. isFirstSession: False\"\n            return False\n\n        print \"Application session. isFirstSession: True\"\n        return True\n",
            "scriptType": "application_session",
            "programmingLanguage": "python",
            "moduleProperties": [
                {
                    "value1": "location_type",
                    "value2": "ldap"
                }
            ],
            "level": 800,
            "revision": 8,
            "enabled": false,
            "modified": false,
            "internal": false,
            "locationType": "ldap"
        }
 // CustomScript | CustomScript object
};
apiInstance.putConfigScripts(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customScript** | [**CustomScript**](CustomScript.md)| CustomScript object | [optional] 

### Return type

[**CustomScript**](CustomScript.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

