# JansConfigApi.ConfigurationUserManagementApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteUser**](ConfigurationUserManagementApi.md#deleteUser) | **DELETE** /mgt/configuser/{inum} | Delete User
[**getUser**](ConfigurationUserManagementApi.md#getUser) | **GET** /mgt/configuser | Gets list of users
[**getUserByInum**](ConfigurationUserManagementApi.md#getUserByInum) | **GET** /mgt/configuser/{inum} | Get User by Inum
[**patchUserByInum**](ConfigurationUserManagementApi.md#patchUserByInum) | **PATCH** /mgt/configuser/{inum} | Patch user properties by Inum
[**postUser**](ConfigurationUserManagementApi.md#postUser) | **POST** /mgt/configuser | Create new User
[**putUser**](ConfigurationUserManagementApi.md#putUser) | **PUT** /mgt/configuser | Update User



## deleteUser

> deleteUser(inum)

Delete User

Delete User

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationUserManagementApi();
let inum = "inum_example"; // String | User identifier
apiInstance.deleteUser(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| User identifier | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getUser

> UserPagedResult getUser(opts)

Gets list of users

Gets list of users

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationUserManagementApi();
let opts = {
  'limit': 50, // Number | Search size - max size of the results to return
  'pattern': "''", // String | Search pattern
  'startIndex': 0, // Number | The 1-based index of the first query result
  'sortBy': "'inum'", // String | Attribute whose value will be used to order the returned response
  'sortOrder': "'ascending'", // String | Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"
  'fieldValuePair': mail=abc@mail.com,jansStatus=true // String | Field and value pair for seraching
};
apiInstance.getUser(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]
 **pattern** | **String**| Search pattern | [optional] [default to &#39;&#39;]
 **startIndex** | **Number**| The 1-based index of the first query result | [optional] [default to 0]
 **sortBy** | **String**| Attribute whose value will be used to order the returned response | [optional] [default to &#39;inum&#39;]
 **sortOrder** | **String**| Order in which the sortBy param is applied. Allowed values are \&quot;ascending\&quot; and \&quot;descending\&quot; | [optional] [default to &#39;ascending&#39;]
 **fieldValuePair** | **String**| Field and value pair for seraching | [optional] [default to &#39;&#39;]

### Return type

[**UserPagedResult**](UserPagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getUserByInum

> CustomUser getUserByInum(inum)

Get User by Inum

Get User by Inum

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationUserManagementApi();
let inum = "inum_example"; // String | User identifier
apiInstance.getUserByInum(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| User identifier | 

### Return type

[**CustomUser**](CustomUser.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchUserByInum

> CustomUser patchUserByInum(inum, opts)

Patch user properties by Inum

Patch user properties by Inum

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationUserManagementApi();
let inum = "inum_example"; // String | User identifier
let opts = {
  'removeNonLDAPAttributes': true, // Boolean | Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request.
  'userPatchRequest': {
   "jsonPatchString": "[ {\"op\":\"add\", \"path\": \"/userId\", \"value\":\"config_test_user_100_final_patch\" } ]",
   "customAttributes": [{
            "name": "emailVerified",
            "multiValued": false,
            "values": [
                "TRUE"
            ],
            "value": "TRUE",
            "displayValue": "TRUE"
        },
		{
            "name": "secretAnswer",
            "multiValued": false,
            "values": [
                "james-bond@123"
            ],
            "value": "james-bond@123",
            "displayValue": "james-bond@123"
        },
        {
            "name": "jansImsValue",
            "multiValued": true,
            "values": [{
			  "value": "123456",
			  "display": "Home phone",
			  "type": "home",
			  "primary": true			
			},
			{
			  "value": "9821789",
			  "display": "Work phone",
			  "type": "work",
			  "primary": false			
			}
                
            ]
        }
        ]
}
 // UserPatchRequest | UserPatchRequest
};
apiInstance.patchUserByInum(inum, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| User identifier | 
 **removeNonLDAPAttributes** | **Boolean**| Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request. | [optional] [default to true]
 **userPatchRequest** | [**UserPatchRequest**](UserPatchRequest.md)| UserPatchRequest | [optional] 

### Return type

[**CustomUser**](CustomUser.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## postUser

> CustomUser postUser(opts)

Create new User

Create new User

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationUserManagementApi();
let opts = {
  'removeNonLDAPAttributes': true, // Boolean | Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request.
  'customUser': {
    "userId": "testUser1",
    "createdAt": "2022-05-30T20:06:57",
    "customAttributes": [
        {
            "name": "emailVerified",
            "multiValued": false,
            "values": [
                "TRUE"
            ],
            "value": "TRUE",
            "displayValue": "TRUE"
        },
        {
            "name": "jansAdminUIRole",
            "multiValued": false,
            "values": [
                "api-admin"
            ],
            "value": "api-admin",
            "displayValue": "api-admin"
        },
        {
            "name": "memberOf",
            "multiValued": false,
            "values": [
                "inum=60B7,ou=groups,o=jans"
            ],
            "value": "inum=60B7,ou=groups,o=jans",
            "displayValue": "inum=60B7,ou=groups,o=jans"
        },
        {
            "name": "middleName",
            "multiValued": false,
            "values": [
                "Test USer 3"
            ],
            "value": "Test USer 3",
            "displayValue": "Test USer 3"
        },
        {
            "name": "nickname",
            "multiValued": false,
            "values": [
                "Test USer 3"
            ],
            "value": "Test USer 3",
            "displayValue": "Test USer 3"
        },
        {
            "name": "sn",
            "multiValued": false,
            "values": [
                "User3"
            ],
            "value": "User3",
            "displayValue": "User3"
        },{
                "name": "birthdate",
                "multiValued": false,
                "values": [
                    "20001231041508.553Z"
                ],
                "value": "20001231041508.553Z",
                "displayValue": "20001231041508.553Z"
            }
    ],
    "customObjectClasses": [
        "top",
        "jansCustomPerson"
    ],
    "mail": "test3@jans.server",
    "displayName": "Default Test User 32",
    "jansStatus": "active",
    "givenName": "Test3",
    "userPassword": "test123"
}
 // CustomUser | User object
};
apiInstance.postUser(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **removeNonLDAPAttributes** | **Boolean**| Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request. | [optional] [default to true]
 **customUser** | [**CustomUser**](CustomUser.md)| User object | [optional] 

### Return type

[**CustomUser**](CustomUser.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## putUser

> CustomUser putUser(opts)

Update User

Update User

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationUserManagementApi();
let opts = {
  'removeNonLDAPAttributes': true, // Boolean | Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request.
  'customUser': {
    "dn": "inum=559a7e26-7a33-4e11-9d42-13266d33261e,ou=people,o=jans",
    "userId": "testUser1",
    "createdAt": "2022-10-27T22:45:48",
    "customAttributes": [
        {
            "name": "birthdate",
            "multiValued": false,
            "values": [
                "20001231041508.553Z"
            ],
            "value": "20001231041508.553Z",
            "displayValue": "20001231041508.553Z"
        },
        {
            "name": "emailVerified",
            "multiValued": false,
            "values": [
                "TRUE"
            ],
            "value": "TRUE",
            "displayValue": "TRUE"
        },
        {
            "name": "jansAdminUIRole",
            "multiValued": false,
            "values": [
                "api-admin"
            ],
            "value": "api-admin",
            "displayValue": "api-admin"
        },
        {
            "name": "memberOf",
            "multiValued": false,
            "values": [
                "inum=60B7,ou=groups,o=jans"
            ],
            "value": "inum=60B7,ou=groups,o=jans",
            "displayValue": "inum=60B7,ou=groups,o=jans"
        },
        {
            "name": "middleName",
            "multiValued": false,
            "values": [
                "Test USer 3"
            ],
            "value": "Test USer 3",
            "displayValue": "Test USer 3"
        },
        {
            "name": "nickname",
            "multiValued": false,
            "values": [
                "Test USer 3"
            ],
            "value": "Test USer 3",
            "displayValue": "Test USer 3"
        },
        {
            "name": "sn",
            "multiValued": false,
            "values": [
                "User3"
            ],
            "value": "User3",
            "displayValue": "User3"
        }
    ],
    "customObjectClasses": [
        "top",
        "jansCustomPerson"
    ],
    "inum": "559a7e26-7a33-4e11-9d42-13266d33261e",
    "mail": "test3@jans.server",
    "displayName": "Default Test User 32",
    "jansStatus": "active",
    "givenName": "Test3",
    "baseDn": "inum=559a7e26-7a33-4e11-9d42-13266d33261e,ou=people,o=jans"
}
 // CustomUser | User object
};
apiInstance.putUser(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **removeNonLDAPAttributes** | **Boolean**| Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request. | [optional] [default to true]
 **customUser** | [**CustomUser**](CustomUser.md)| User object | [optional] 

### Return type

[**CustomUser**](CustomUser.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

