# JansConfigApi.ConfigurationLoggingApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getConfigLogging**](ConfigurationLoggingApi.md#getConfigLogging) | **GET** /api/v1/logging | Returns Jans Authorization Server logging settings
[**putConfigLogging**](ConfigurationLoggingApi.md#putConfigLogging) | **PUT** /api/v1/logging | Updates Jans Authorization Server logging settings



## getConfigLogging

> Logging getConfigLogging()

Returns Jans Authorization Server logging settings

Returns Jans Authorization Server logging settings

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationLoggingApi();
apiInstance.getConfigLogging((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**Logging**](Logging.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## putConfigLogging

> Logging putConfigLogging(opts)

Updates Jans Authorization Server logging settings

Updates Jans Authorization Server logging settings

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationLoggingApi();
let opts = {
  'logging': {
    "loggingLevel": "TRACE",
    "loggingLayout": "text",
    "httpLoggingEnabled": false,
    "disableJdkLogger": true,
    "enabledOAuthAuditLogging": false
}
 // Logging | Logging object
};
apiInstance.putConfigLogging(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **logging** | [**Logging**](Logging.md)| Logging object | [optional] 

### Return type

[**Logging**](Logging.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

