# JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteConfigJwkKid**](ConfigurationJWKJSONWebKeyJWKApi.md#deleteConfigJwkKid) | **DELETE** /api/v1/config/jwks/{kid} | Delete a JSON Web Key based on kid
[**getConfigJwks**](ConfigurationJWKJSONWebKeyJWKApi.md#getConfigJwks) | **GET** /api/v1/config/jwks | Gets list of JSON Web Key (JWK) used by server
[**getJwkByKid**](ConfigurationJWKJSONWebKeyJWKApi.md#getJwkByKid) | **GET** /api/v1/config/jwks/{kid} | Get a JSON Web Key based on kid
[**patchConfigJwkKid**](ConfigurationJWKJSONWebKeyJWKApi.md#patchConfigJwkKid) | **PATCH** /api/v1/config/jwks/{kid} | Patch a specific JSON Web Key based on kid
[**patchConfigJwks**](ConfigurationJWKJSONWebKeyJWKApi.md#patchConfigJwks) | **PATCH** /api/v1/config/jwks | Patches JSON Web Keys
[**postConfigJwksKey**](ConfigurationJWKJSONWebKeyJWKApi.md#postConfigJwksKey) | **POST** /api/v1/config/jwks/key | Configuration – JWK - JSON Web Key (JWK)
[**putConfigJwks**](ConfigurationJWKJSONWebKeyJWKApi.md#putConfigJwks) | **PUT** /api/v1/config/jwks | Replaces JSON Web Keys



## deleteConfigJwkKid

> deleteConfigJwkKid(kid)

Delete a JSON Web Key based on kid

Delete a JSON Web Key based on kid

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi();
let kid = "kid_example"; // String | The unique identifier for the key
apiInstance.deleteConfigJwkKid(kid, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **kid** | **String**| The unique identifier for the key | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getConfigJwks

> WebKeysConfiguration getConfigJwks()

Gets list of JSON Web Key (JWK) used by server

Gets list of JSON Web Key (JWK) used by server

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi();
apiInstance.getConfigJwks((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**WebKeysConfiguration**](WebKeysConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getJwkByKid

> JSONWebKey getJwkByKid(kid)

Get a JSON Web Key based on kid

Get a JSON Web Key based on kid

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi();
let kid = "kid_example"; // String | The unique identifier for the key
apiInstance.getJwkByKid(kid, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **kid** | **String**| The unique identifier for the key | 

### Return type

[**JSONWebKey**](JSONWebKey.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchConfigJwkKid

> JSONWebKey patchConfigJwkKid(kid, opts)

Patch a specific JSON Web Key based on kid

Patch a specific JSON Web Key based on kid

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi();
let kid = "kid_example"; // String | The unique identifier for the key
let opts = {
  'requestBody': [
    { "op": "replace", "path": "/use", "value":"enc"},
    { "op": "replace", "path": "/e", "value":"Updated_XYZ"}
] 
 // [Object] | JsonPatch object
};
apiInstance.patchConfigJwkKid(kid, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **kid** | **String**| The unique identifier for the key | 
 **requestBody** | [**[Object]**](Object.md)| JsonPatch object | [optional] 

### Return type

[**JSONWebKey**](JSONWebKey.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## patchConfigJwks

> WebKeysConfiguration patchConfigJwks(opts)

Patches JSON Web Keys

Patches JSON Web Keys

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi();
let opts = {
  'requestBody': [
	{ "op": "add", "path": "/keys/1", "value":{
            "descr": "Test Key",
            "kty": "EC",
            "use": "enc",
            "crv": "P-256",
            "kid": "1234a2b9-1200-42a2-9b12-e2fa89ce3bd0_enc_ecdh-es",
            "x5c": [
                "tE24Ofz3eFhtBAIhAINgdWN86TOOEAUXUr2ijmaAPBgn7mGoeg4c7FfyZTxn"
            ],
            "name": "test-key",
            "x": "NBJAtpZ-jWGjaXDFYgt38",
            "y": "7n6oS9y5vN2XrTKMKilo",
            "exp": 1666775666429,
            "alg": "ECDH-ES"
        }
	}
] 
 // [Object] | JsonPatch object
};
apiInstance.patchConfigJwks(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| JsonPatch object | [optional] 

### Return type

[**WebKeysConfiguration**](WebKeysConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## postConfigJwksKey

> JSONWebKey postConfigJwksKey(opts)

Configuration – JWK - JSON Web Key (JWK)

Configuration – JWK - JSON Web Key (JWK)

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi();
let opts = {
  'jSONWebKey': {
      "kty": "RSA",
      "e": "AQAB",
      "use": "sig",
      "crv": "",
      "kid": "1230bfb-276a-44aa-a97d-667b57587108_sig_rs256",
      "x5c": [
        "A0GCSqGSIb3DQEBCwUAMCExHzAdBgNVBAMMFm94QXV0aCBDQSBDZXJ0aWZpY2F0ZXMwHhcNMjAwOTA4MTUzMjE3WhcNMjAwOTEwMTUzMjI2WjAhMR8wHQYDVQQDDBZveEF1dGggQ0EgQ2VydGlmaWNhdGVzMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzj1NEHyGk/ywG25py2s/zVVrRggzRO0jE6VOUvqUzsEJwt1aszQ4onFu6vgtjNwq2ZmEFZbw1Jw7dlz4Xrdj12pQlLVuEhyVaTziQp3LvspqxyACHQb8XSKFdKZaa1eBF8PGN5zDN/d+tIrAZYnQS2gH8BoPIuB3Z9AoCLTzifnPvmOwW/e+/Wags/ApZiEfF2Po0InV5NeJAyoIpaGhlwjqqOWXm/GpCASAk9ZD8Ebnmy9RM71zDCgmvq/hPueKnbNTZdQ3TQdzEuSwxbWEHu16v5MbF7QtNzvFSFlllhgwqI2ccEljDbs18j3DUS2B1VTTAr/DLR3SVyCYbKBbRQIDAQABoycwJTAjBgNVHSUEHDAaBggrBgEFBQcDAQYIKwYBBQUHAwIGBFUdJQAwDQYJKoZIhvcNAQELBQADggEBADaqrfVH1FX0FLp99TG9fHOiOMD12vsIPANb9QbIADineFrSvUI3zIX56PpvMT+EApaLPcIYSwG1YziWT1oGDGkfyinofSRGl4JcC63slChUBfjlBZlXTIlc7CJA7CfzO6BW3SvO0GPF0NStCUD9Ou4oOVaIc3XrPzhIAp71cF9iLFnQUK1hiD9NhQUm5v2Nq+sQdjAxSlqigXnc+rB9+V8snCkr9x9q1cysq1ZyCRT55psa53Irqtc50T2PHA6kyzEVW51+yFaZa8z+WMoofr6ndx2DFI7n5+8jFGs9WoP+/zV8E/XK61iy+EdXVjXQYVcArjEzeIahn8QOd/hUcfo="
      ],
      "exp": 1599751946863,
      "alg": "RS256",
      "n": "EFZbw1Jw7dlz4Xrdj12pQlLVuEhyVaTziQp3LvspqxyACHQb8XSKFdKZaa1eBF8PGN5zDN_d-tIrAZYnQS2gH8BoPIuB3Z9AoCLTzifnPvmOwW_e-_Wags_ApZiEfF2Po0InV5NeJAyoIpaGhlwjqqOWXm_GpCASAk9ZD8Ebnmy9RM71zDCgmvq_hPueKnbNTZdQ3TQdzEuSwxbWEHu16v5MbF7QtNzvFSFlllhgwqI2ccEljDbs18j3DUS2B1VTTAr_DLR3SVyCYbKBbRQ"
    }
 // JSONWebKey | JSONWebKey object
};
apiInstance.postConfigJwksKey(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **jSONWebKey** | [**JSONWebKey**](JSONWebKey.md)| JSONWebKey object | [optional] 

### Return type

[**JSONWebKey**](JSONWebKey.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## putConfigJwks

> WebKeysConfiguration putConfigJwks(opts)

Replaces JSON Web Keys

Replaces JSON Web Keys

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ConfigurationJWKJSONWebKeyJWKApi();
let opts = {
  'webKeysConfiguration': {
    "keys": [
        {
            "descr": "Signature Key: RSA RSASSA-PKCS1-v1_5 using SHA-256",
            "kty": "RSA",
            "e": "AQAB",
            "use": "sig",
            "kid": "abc3a91b-dd1b-47b0-b7e7-aaf2ec3b9d5e_sig_rs256",
            "x5c": [
                "E3+Z7Ie9FVpDIqeBo/xI8/q7CCDxCHTtiTQjGS5j/XV4VcPt7i9mrQsajbndCAmynVw=="
            ],
            "name": "id_token RS256 Sign Key",
            "exp": 1666775666429,
            "alg": "RS256",
            "n": "qzu2jRl6UoTnnUJS6zg7ghavupiUQ3Ux4fAH6H7DCXF-cuOgelBjUj_GLPqz5FeOCnQ"
        },
		{
            "descr": "Encryption Key: Elliptic Curve Diffie-Hellman Ephemeral Static key agreement using Concat KDF",
            "kty": "EC",
            "use": "enc",
            "crv": "P-256",
            "kid": "0870a2b9-1200-42a2-9b12-e2fa89ce3bd0_enc_ecdh-es",
            "x5c": [
                "tE24Ofz3eFhtBAIhAINgdWN86TOOEAUXUr2ijmaAPBgn7mGoeg4c7FfyZTxn"
            ],
            "name": "id_token ECDH-ES Encryption Key",
            "x": "NBJAtpZ-jWGjaXDFYgt38",
            "y": "7n6oS9y5vN2XrTKMKilo",
            "exp": 1666775666429,
            "alg": "ECDH-ES"
        }
    ]
}
 // WebKeysConfiguration | JSON Web Keys object
};
apiInstance.putConfigJwks(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **webKeysConfiguration** | [**WebKeysConfiguration**](WebKeysConfiguration.md)| JSON Web Keys object | [optional] 

### Return type

[**WebKeysConfiguration**](WebKeysConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

