# JansConfigApi.ClientAuthorizationApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteClientAuthorization**](ClientAuthorizationApi.md#deleteClientAuthorization) | **DELETE** /api/v1/clients/authorizations/{userId}/{clientId}/{username} | Revoke client authorization
[**getClientAuthorization**](ClientAuthorizationApi.md#getClientAuthorization) | **GET** /api/v1/clients/authorizations/{userId} | Gets list of client authorization



## deleteClientAuthorization

> deleteClientAuthorization(userId, clientId, username)

Revoke client authorization

Revoke client authorizations

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ClientAuthorizationApi();
let userId = "userId_example"; // String | User identifier
let clientId = "clientId_example"; // String | Client identifier
let username = "username_example"; // String | User name
apiInstance.deleteClientAuthorization(userId, clientId, username, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **String**| User identifier | 
 **clientId** | **String**| Client identifier | 
 **username** | **String**| User name | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getClientAuthorization

> ClientAuth getClientAuthorization(userId)

Gets list of client authorization

Gets list of client authorizations

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.ClientAuthorizationApi();
let userId = "userId_example"; // String | User identifier
apiInstance.getClientAuthorization(userId, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **String**| User identifier | 

### Return type

[**ClientAuth**](ClientAuth.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

