# JansConfigApi.CacheConfigurationNativePersistenceApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getConfigCacheNativePersistence**](CacheConfigurationNativePersistenceApi.md#getConfigCacheNativePersistence) | **GET** /api/v1/config/cache/native-persistence | Returns native persistence cache configuration.
[**patchConfigCacheNativePersistence**](CacheConfigurationNativePersistenceApi.md#patchConfigCacheNativePersistence) | **PATCH** /api/v1/config/cache/native-persistence | Patch native persistence cache configuration.
[**putConfigCacheNativePersistence**](CacheConfigurationNativePersistenceApi.md#putConfigCacheNativePersistence) | **PUT** /api/v1/config/cache/native-persistence | Updates native persistence cache configuration.



## getConfigCacheNativePersistence

> NativePersistenceConfiguration getConfigCacheNativePersistence()

Returns native persistence cache configuration.

Returns native persistence cache configuration.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationNativePersistenceApi();
apiInstance.getConfigCacheNativePersistence((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**NativePersistenceConfiguration**](NativePersistenceConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchConfigCacheNativePersistence

> NativePersistenceConfiguration patchConfigCacheNativePersistence(opts)

Patch native persistence cache configuration.

Patch native persistence cache configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationNativePersistenceApi();
let opts = {
  'requestBody': [{ "op": "replace", "path": "/defaultCleanupBatchSize", "value":10001}] 
 // [Object] | String representing patch-document.
};
apiInstance.patchConfigCacheNativePersistence(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**NativePersistenceConfiguration**](NativePersistenceConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## putConfigCacheNativePersistence

> NativePersistenceConfiguration putConfigCacheNativePersistence(opts)

Updates native persistence cache configuration.

Updates native persistence cache configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationNativePersistenceApi();
let opts = {
  'nativePersistenceConfiguration': {
    "defaultPutExpiration": 60,
    "defaultCleanupBatchSize": 10000,
    "deleteExpiredOnGetRequest": false,
    "disableAttemptUpdateBeforeInsert": false
}
 // NativePersistenceConfiguration | NativePersistenceConfiguration object
};
apiInstance.putConfigCacheNativePersistence(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **nativePersistenceConfiguration** | [**NativePersistenceConfiguration**](NativePersistenceConfiguration.md)| NativePersistenceConfiguration object | [optional] 

### Return type

[**NativePersistenceConfiguration**](NativePersistenceConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

