# JansConfigApi.AgamaApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAgamaPrj**](AgamaApi.md#deleteAgamaPrj) | **DELETE** /api/v1/agama-deployment/{name} | Delete a deployed Agama project.
[**getAgamaPrj**](AgamaApi.md#getAgamaPrj) | **GET** /api/v1/agama-deployment | Retrieve the list of projects deployed currently.
[**getAgamaPrjByName**](AgamaApi.md#getAgamaPrjByName) | **GET** /api/v1/agama-deployment/{name} | Fetches deployed Agama project based on name.
[**getAgamaPrjConfigs**](AgamaApi.md#getAgamaPrjConfigs) | **GET** /api/v1/agama-deployment/configs/{name} | Retrieve the list of configs based on name.
[**getAgamaProject**](AgamaApi.md#getAgamaProject) | **GET** /api/v1/agama-repo/download | Download agama project.
[**getAgamaRepositories**](AgamaApi.md#getAgamaRepositories) | **GET** /api/v1/agama-repo | Gets all agama repositories.
[**postAgamaPrj**](AgamaApi.md#postAgamaPrj) | **POST** /api/v1/agama-deployment/{name} | Deploy an Agama project.
[**putAgamaPrj**](AgamaApi.md#putAgamaPrj) | **PUT** /api/v1/agama-deployment/configs/{name} | Update an Agama project.



## deleteAgamaPrj

> deleteAgamaPrj(name)

Delete a deployed Agama project.

Delete a deployed Agama project.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let name = "name_example"; // String | Agama project name
apiInstance.deleteAgamaPrj(name, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Agama project name | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getAgamaPrj

> PagedResult getAgamaPrj(opts)

Retrieve the list of projects deployed currently.

Retrieve the list of projects deployed currently.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let opts = {
  'start': 56, // Number | Start index for the result
  'count': 56 // Number | Search size - count of the results to return
};
apiInstance.getAgamaPrj(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **start** | **Number**| Start index for the result | [optional] 
 **count** | **Number**| Search size - count of the results to return | [optional] 

### Return type

[**PagedResult**](PagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAgamaPrjByName

> Deployment getAgamaPrjByName(name)

Fetches deployed Agama project based on name.

Fetches deployed Agama project based on name.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let name = "name_example"; // String | Agama project name
apiInstance.getAgamaPrjByName(name, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Agama project name | 

### Return type

[**Deployment**](Deployment.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAgamaPrjConfigs

> String getAgamaPrjConfigs(name)

Retrieve the list of configs based on name.

Retrieve the list of configs based on name.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let name = "name_example"; // String | Agama project name
apiInstance.getAgamaPrjConfigs(name, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Agama project name | 

### Return type

**String**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAgamaProject

> File getAgamaProject(opts)

Download agama project.

Download agama project.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let opts = {
  'downloadLink': "downloadLink_example" // String | Agama project download Link
};
apiInstance.getAgamaProject(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **downloadLink** | **String**| Agama project download Link | [optional] 

### Return type

**File**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAgamaRepositories

> Object getAgamaRepositories()

Gets all agama repositories.

Gets all agama repositories.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
apiInstance.getAgamaRepositories((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

**Object**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## postAgamaPrj

> String postAgamaPrj(name, opts)

Deploy an Agama project.

Deploy an Agama project.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let name = "name_example"; // String | Agama project name
let opts = {
  'autoconfigure': "autoconfigure_example", // String | Boolean value to indicating to auto configure the project 
  'requestBody': [null] // [Blob] | Agama gama file
};
apiInstance.postAgamaPrj(name, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Agama project name | 
 **autoconfigure** | **String**| Boolean value to indicating to auto configure the project  | [optional] 
 **requestBody** | [**[Blob]**](Blob.md)| Agama gama file | [optional] 

### Return type

**String**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/zip
- **Accept**: application/zip


## putAgamaPrj

> String putAgamaPrj(name, opts)

Update an Agama project.

Update an Agama project.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let name = "name_example"; // String | Agama project name
let opts = {
  'requestBody': {key: null} // {String: {String: Object}} | Agama flow config, key is `name` of config property and `value` is the property value. 
};
apiInstance.putAgamaPrj(name, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Agama project name | 
 **requestBody** | [**{String: {String: Object}}**](Object.md)| Agama flow config, key is &#x60;name&#x60; of config property and &#x60;value&#x60; is the property value.  | [optional] 

### Return type

**String**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

