# JansConfigApi.AdminUIRoleApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**addAdminuiRole**](AdminUIRoleApi.md#addAdminuiRole) | **POST** /admin-ui/adminUIRoles | Add admin ui role
[**deleteAdminuiRole**](AdminUIRoleApi.md#deleteAdminuiRole) | **DELETE** /admin-ui/adminUIRoles/{adminUIRole} | Delete admin ui role by role-name
[**editAdminuiRole**](AdminUIRoleApi.md#editAdminuiRole) | **PUT** /admin-ui/adminUIRoles | Edit admin ui role
[**getAdminuiRole**](AdminUIRoleApi.md#getAdminuiRole) | **GET** /admin-ui/adminUIRoles/{adminUIRole} | Get admin ui role details by role-name
[**getAllAdminuiRoles**](AdminUIRoleApi.md#getAllAdminuiRoles) | **GET** /admin-ui/adminUIRoles | Get all admin ui roles



## addAdminuiRole

> [AdminRole] addAdminuiRole(opts)

Add admin ui role

Add admin ui role

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIRoleApi();
let opts = {
  'adminRole': new JansConfigApi.AdminRole() // AdminRole | AdminRole object
};
apiInstance.addAdminuiRole(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **adminRole** | [**AdminRole**](AdminRole.md)| AdminRole object | [optional] 

### Return type

[**[AdminRole]**](AdminRole.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## deleteAdminuiRole

> [AdminRole] deleteAdminuiRole(adminUIRole)

Delete admin ui role by role-name

Delete admin ui role by role-name

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIRoleApi();
let adminUIRole = "adminUIRole_example"; // String | Admin UI role
apiInstance.deleteAdminuiRole(adminUIRole, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **adminUIRole** | **String**| Admin UI role | 

### Return type

[**[AdminRole]**](AdminRole.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## editAdminuiRole

> [AdminRole] editAdminuiRole(opts)

Edit admin ui role

Edit admin ui role

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIRoleApi();
let opts = {
  'adminRole': new JansConfigApi.AdminRole() // AdminRole | AdminRole object
};
apiInstance.editAdminuiRole(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **adminRole** | [**AdminRole**](AdminRole.md)| AdminRole object | [optional] 

### Return type

[**[AdminRole]**](AdminRole.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## getAdminuiRole

> [AdminRole] getAdminuiRole(adminUIRole)

Get admin ui role details by role-name

Get admin ui role details by role-name

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIRoleApi();
let adminUIRole = "adminUIRole_example"; // String | Admin UI role
apiInstance.getAdminuiRole(adminUIRole, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **adminUIRole** | **String**| Admin UI role | 

### Return type

[**[AdminRole]**](AdminRole.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAllAdminuiRoles

> [AdminRole] getAllAdminuiRoles()

Get all admin ui roles

Get all admin ui roles

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIRoleApi();
apiInstance.getAllAdminuiRoles((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**[AdminRole]**](AdminRole.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

