# JansConfigApi.AdminUIPermissionApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**addAdminuiPermission**](AdminUIPermissionApi.md#addAdminuiPermission) | **POST** /admin-ui/adminUIPermissions | Add admin ui permissions
[**deleteAdminuiPermission**](AdminUIPermissionApi.md#deleteAdminuiPermission) | **DELETE** /admin-ui/adminUIPermissions/{adminUIPermission} | Delete admin ui permission by permission-name
[**editAdminuiPermission**](AdminUIPermissionApi.md#editAdminuiPermission) | **PUT** /admin-ui/adminUIPermissions | Edit admin ui permissions
[**getAdminuiPermission**](AdminUIPermissionApi.md#getAdminuiPermission) | **GET** /admin-ui/adminUIPermissions/{adminUIPermission} | Get admin ui permission by permission-name
[**getAllAdminuiPermissions**](AdminUIPermissionApi.md#getAllAdminuiPermissions) | **GET** /admin-ui/adminUIPermissions | Get all admin ui permissions



## addAdminuiPermission

> [AdminPermission] addAdminuiPermission(opts)

Add admin ui permissions

Add admin ui permissions

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIPermissionApi();
let opts = {
  'adminPermission': new JansConfigApi.AdminPermission() // AdminPermission | AdminPermission object
};
apiInstance.addAdminuiPermission(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **adminPermission** | [**AdminPermission**](AdminPermission.md)| AdminPermission object | [optional] 

### Return type

[**[AdminPermission]**](AdminPermission.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## deleteAdminuiPermission

> [AdminPermission] deleteAdminuiPermission(adminUIPermission)

Delete admin ui permission by permission-name

Delete admin ui permission by permission-name

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIPermissionApi();
let adminUIPermission = "adminUIPermission_example"; // String | Admin UI Permission
apiInstance.deleteAdminuiPermission(adminUIPermission, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **adminUIPermission** | **String**| Admin UI Permission | 

### Return type

[**[AdminPermission]**](AdminPermission.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## editAdminuiPermission

> [AdminPermission] editAdminuiPermission(opts)

Edit admin ui permissions

Edit admin ui permissions

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIPermissionApi();
let opts = {
  'adminPermission': new JansConfigApi.AdminPermission() // AdminPermission | AdminPermission object
};
apiInstance.editAdminuiPermission(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **adminPermission** | [**AdminPermission**](AdminPermission.md)| AdminPermission object | [optional] 

### Return type

[**[AdminPermission]**](AdminPermission.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## getAdminuiPermission

> [AdminPermission] getAdminuiPermission(adminUIPermission)

Get admin ui permission by permission-name

Get admin ui permission by permission-name

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIPermissionApi();
let adminUIPermission = "adminUIPermission_example"; // String | Admin UI Permission
apiInstance.getAdminuiPermission(adminUIPermission, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **adminUIPermission** | **String**| Admin UI Permission | 

### Return type

[**[AdminPermission]**](AdminPermission.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAllAdminuiPermissions

> [AdminPermission] getAllAdminuiPermissions()

Get all admin ui permissions

Get all admin ui permissions

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIPermissionApi();
apiInstance.getAllAdminuiPermissions((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**[AdminPermission]**](AdminPermission.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

