"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _AuthenticationFilter = _interopRequireDefault(require("./AuthenticationFilter"));
var _AuthenticationProtectionConfiguration = _interopRequireDefault(require("./AuthenticationProtectionConfiguration"));
var _AuthorizationRequestCustomParameter = _interopRequireDefault(require("./AuthorizationRequestCustomParameter"));
var _CIBAEndUserNotificationConfig = _interopRequireDefault(require("./CIBAEndUserNotificationConfig"));
var _ClientAuthenticationFilter = _interopRequireDefault(require("./ClientAuthenticationFilter"));
var _CorsConfigurationFilter = _interopRequireDefault(require("./CorsConfigurationFilter"));
var _EngineConfig = _interopRequireDefault(require("./EngineConfig"));
var _LockMessageConfig = _interopRequireDefault(require("./LockMessageConfig"));
var _SsaConfiguration = _interopRequireDefault(require("./SsaConfiguration"));
var _SsaValidationConfig = _interopRequireDefault(require("./SsaValidationConfig"));
var _TrustedIssuerConfig = _interopRequireDefault(require("./TrustedIssuerConfig"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
 * The AppConfiguration model module.
 * @module model/AppConfiguration
 * @version OAS Version
 */
var AppConfiguration = /*#__PURE__*/function () {
  /**
   * Constructs a new <code>AppConfiguration</code>.
   * @alias module:model/AppConfiguration
   */
  function AppConfiguration() {
    _classCallCheck(this, AppConfiguration);
    AppConfiguration.initialize(this);
  }

  /**
   * Initializes the fields of this object.
   * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
   * Only for internal use.
   */
  return _createClass(AppConfiguration, null, [{
    key: "initialize",
    value: function initialize(obj) {}

    /**
     * Constructs a <code>AppConfiguration</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/AppConfiguration} obj Optional instance to populate.
     * @return {module:model/AppConfiguration} The populated <code>AppConfiguration</code> instance.
     */
  }, {
    key: "constructFromObject",
    value: function constructFromObject(data, obj) {
      if (data) {
        obj = obj || new AppConfiguration();
        if (data.hasOwnProperty('issuer')) {
          obj['issuer'] = _ApiClient["default"].convertToType(data['issuer'], 'String');
        }
        if (data.hasOwnProperty('baseEndpoint')) {
          obj['baseEndpoint'] = _ApiClient["default"].convertToType(data['baseEndpoint'], 'String');
        }
        if (data.hasOwnProperty('authorizationEndpoint')) {
          obj['authorizationEndpoint'] = _ApiClient["default"].convertToType(data['authorizationEndpoint'], 'String');
        }
        if (data.hasOwnProperty('authorizationChallengeEndpoint')) {
          obj['authorizationChallengeEndpoint'] = _ApiClient["default"].convertToType(data['authorizationChallengeEndpoint'], 'String');
        }
        if (data.hasOwnProperty('tokenEndpoint')) {
          obj['tokenEndpoint'] = _ApiClient["default"].convertToType(data['tokenEndpoint'], 'String');
        }
        if (data.hasOwnProperty('tokenRevocationEndpoint')) {
          obj['tokenRevocationEndpoint'] = _ApiClient["default"].convertToType(data['tokenRevocationEndpoint'], 'String');
        }
        if (data.hasOwnProperty('userInfoEndpoint')) {
          obj['userInfoEndpoint'] = _ApiClient["default"].convertToType(data['userInfoEndpoint'], 'String');
        }
        if (data.hasOwnProperty('clientInfoEndpoint')) {
          obj['clientInfoEndpoint'] = _ApiClient["default"].convertToType(data['clientInfoEndpoint'], 'String');
        }
        if (data.hasOwnProperty('checkSessionIFrame')) {
          obj['checkSessionIFrame'] = _ApiClient["default"].convertToType(data['checkSessionIFrame'], 'String');
        }
        if (data.hasOwnProperty('endSessionEndpoint')) {
          obj['endSessionEndpoint'] = _ApiClient["default"].convertToType(data['endSessionEndpoint'], 'String');
        }
        if (data.hasOwnProperty('jwksUri')) {
          obj['jwksUri'] = _ApiClient["default"].convertToType(data['jwksUri'], 'String');
        }
        if (data.hasOwnProperty('archivedJwksUri')) {
          obj['archivedJwksUri'] = _ApiClient["default"].convertToType(data['archivedJwksUri'], 'String');
        }
        if (data.hasOwnProperty('registrationEndpoint')) {
          obj['registrationEndpoint'] = _ApiClient["default"].convertToType(data['registrationEndpoint'], 'String');
        }
        if (data.hasOwnProperty('openIdDiscoveryEndpoint')) {
          obj['openIdDiscoveryEndpoint'] = _ApiClient["default"].convertToType(data['openIdDiscoveryEndpoint'], 'String');
        }
        if (data.hasOwnProperty('openIdConfigurationEndpoint')) {
          obj['openIdConfigurationEndpoint'] = _ApiClient["default"].convertToType(data['openIdConfigurationEndpoint'], 'String');
        }
        if (data.hasOwnProperty('idGenerationEndpoint')) {
          obj['idGenerationEndpoint'] = _ApiClient["default"].convertToType(data['idGenerationEndpoint'], 'String');
        }
        if (data.hasOwnProperty('introspectionEndpoint')) {
          obj['introspectionEndpoint'] = _ApiClient["default"].convertToType(data['introspectionEndpoint'], 'String');
        }
        if (data.hasOwnProperty('parEndpoint')) {
          obj['parEndpoint'] = _ApiClient["default"].convertToType(data['parEndpoint'], 'String');
        }
        if (data.hasOwnProperty('requirePar')) {
          obj['requirePar'] = _ApiClient["default"].convertToType(data['requirePar'], 'Boolean');
        }
        if (data.hasOwnProperty('deviceAuthzEndpoint')) {
          obj['deviceAuthzEndpoint'] = _ApiClient["default"].convertToType(data['deviceAuthzEndpoint'], 'String');
        }
        if (data.hasOwnProperty('mtlsAuthorizationEndpoint')) {
          obj['mtlsAuthorizationEndpoint'] = _ApiClient["default"].convertToType(data['mtlsAuthorizationEndpoint'], 'String');
        }
        if (data.hasOwnProperty('mtlsAuthorizationChallengeEndpoint')) {
          obj['mtlsAuthorizationChallengeEndpoint'] = _ApiClient["default"].convertToType(data['mtlsAuthorizationChallengeEndpoint'], 'String');
        }
        if (data.hasOwnProperty('mtlsTokenEndpoint')) {
          obj['mtlsTokenEndpoint'] = _ApiClient["default"].convertToType(data['mtlsTokenEndpoint'], 'String');
        }
        if (data.hasOwnProperty('mtlsTokenRevocationEndpoint')) {
          obj['mtlsTokenRevocationEndpoint'] = _ApiClient["default"].convertToType(data['mtlsTokenRevocationEndpoint'], 'String');
        }
        if (data.hasOwnProperty('mtlsUserInfoEndpoint')) {
          obj['mtlsUserInfoEndpoint'] = _ApiClient["default"].convertToType(data['mtlsUserInfoEndpoint'], 'String');
        }
        if (data.hasOwnProperty('mtlsClientInfoEndpoint')) {
          obj['mtlsClientInfoEndpoint'] = _ApiClient["default"].convertToType(data['mtlsClientInfoEndpoint'], 'String');
        }
        if (data.hasOwnProperty('mtlsCheckSessionIFrame')) {
          obj['mtlsCheckSessionIFrame'] = _ApiClient["default"].convertToType(data['mtlsCheckSessionIFrame'], 'String');
        }
        if (data.hasOwnProperty('mtlsEndSessionEndpoint')) {
          obj['mtlsEndSessionEndpoint'] = _ApiClient["default"].convertToType(data['mtlsEndSessionEndpoint'], 'String');
        }
        if (data.hasOwnProperty('mtlsJwksUri')) {
          obj['mtlsJwksUri'] = _ApiClient["default"].convertToType(data['mtlsJwksUri'], 'String');
        }
        if (data.hasOwnProperty('mtlsRegistrationEndpoint')) {
          obj['mtlsRegistrationEndpoint'] = _ApiClient["default"].convertToType(data['mtlsRegistrationEndpoint'], 'String');
        }
        if (data.hasOwnProperty('mtlsIdGenerationEndpoint')) {
          obj['mtlsIdGenerationEndpoint'] = _ApiClient["default"].convertToType(data['mtlsIdGenerationEndpoint'], 'String');
        }
        if (data.hasOwnProperty('mtlsIntrospectionEndpoint')) {
          obj['mtlsIntrospectionEndpoint'] = _ApiClient["default"].convertToType(data['mtlsIntrospectionEndpoint'], 'String');
        }
        if (data.hasOwnProperty('mtlsParEndpoint')) {
          obj['mtlsParEndpoint'] = _ApiClient["default"].convertToType(data['mtlsParEndpoint'], 'String');
        }
        if (data.hasOwnProperty('mtlsDeviceAuthzEndpoint')) {
          obj['mtlsDeviceAuthzEndpoint'] = _ApiClient["default"].convertToType(data['mtlsDeviceAuthzEndpoint'], 'String');
        }
        if (data.hasOwnProperty('accessEvaluationAllowBasicClientAuthorization')) {
          obj['accessEvaluationAllowBasicClientAuthorization'] = _ApiClient["default"].convertToType(data['accessEvaluationAllowBasicClientAuthorization'], 'Boolean');
        }
        if (data.hasOwnProperty('accessEvaluationScriptName')) {
          obj['accessEvaluationScriptName'] = _ApiClient["default"].convertToType(data['accessEvaluationScriptName'], 'String');
        }
        if (data.hasOwnProperty('accessEvaluationDiscoveryCacheLifetimeInMinutes')) {
          obj['accessEvaluationDiscoveryCacheLifetimeInMinutes'] = _ApiClient["default"].convertToType(data['accessEvaluationDiscoveryCacheLifetimeInMinutes'], 'Number');
        }
        if (data.hasOwnProperty('requireRequestObjectEncryption')) {
          obj['requireRequestObjectEncryption'] = _ApiClient["default"].convertToType(data['requireRequestObjectEncryption'], 'Boolean');
        }
        if (data.hasOwnProperty('requirePkce')) {
          obj['requirePkce'] = _ApiClient["default"].convertToType(data['requirePkce'], 'Boolean');
        }
        if (data.hasOwnProperty('allowAllValueForRevokeEndpoint')) {
          obj['allowAllValueForRevokeEndpoint'] = _ApiClient["default"].convertToType(data['allowAllValueForRevokeEndpoint'], 'Boolean');
        }
        if (data.hasOwnProperty('allowRevokeForOtherClients')) {
          obj['allowRevokeForOtherClients'] = _ApiClient["default"].convertToType(data['allowRevokeForOtherClients'], 'Boolean');
        }
        if (data.hasOwnProperty('sectorIdentifierCacheLifetimeInMinutes')) {
          obj['sectorIdentifierCacheLifetimeInMinutes'] = _ApiClient["default"].convertToType(data['sectorIdentifierCacheLifetimeInMinutes'], 'Number');
        }
        if (data.hasOwnProperty('archivedJwkLifetimeInSeconds')) {
          obj['archivedJwkLifetimeInSeconds'] = _ApiClient["default"].convertToType(data['archivedJwkLifetimeInSeconds'], 'Number');
        }
        if (data.hasOwnProperty('umaConfigurationEndpoint')) {
          obj['umaConfigurationEndpoint'] = _ApiClient["default"].convertToType(data['umaConfigurationEndpoint'], 'String');
        }
        if (data.hasOwnProperty('umaRptAsJwt')) {
          obj['umaRptAsJwt'] = _ApiClient["default"].convertToType(data['umaRptAsJwt'], 'Boolean');
        }
        if (data.hasOwnProperty('umaRptLifetime')) {
          obj['umaRptLifetime'] = _ApiClient["default"].convertToType(data['umaRptLifetime'], 'Number');
        }
        if (data.hasOwnProperty('umaTicketLifetime')) {
          obj['umaTicketLifetime'] = _ApiClient["default"].convertToType(data['umaTicketLifetime'], 'Number');
        }
        if (data.hasOwnProperty('umaPctLifetime')) {
          obj['umaPctLifetime'] = _ApiClient["default"].convertToType(data['umaPctLifetime'], 'Number');
        }
        if (data.hasOwnProperty('umaResourceLifetime')) {
          obj['umaResourceLifetime'] = _ApiClient["default"].convertToType(data['umaResourceLifetime'], 'Number');
        }
        if (data.hasOwnProperty('umaAddScopesAutomatically')) {
          obj['umaAddScopesAutomatically'] = _ApiClient["default"].convertToType(data['umaAddScopesAutomatically'], 'Boolean');
        }
        if (data.hasOwnProperty('umaValidateClaimToken')) {
          obj['umaValidateClaimToken'] = _ApiClient["default"].convertToType(data['umaValidateClaimToken'], 'Boolean');
        }
        if (data.hasOwnProperty('umaGrantAccessIfNoPolicies')) {
          obj['umaGrantAccessIfNoPolicies'] = _ApiClient["default"].convertToType(data['umaGrantAccessIfNoPolicies'], 'Boolean');
        }
        if (data.hasOwnProperty('umaRestrictResourceToAssociatedClient')) {
          obj['umaRestrictResourceToAssociatedClient'] = _ApiClient["default"].convertToType(data['umaRestrictResourceToAssociatedClient'], 'Boolean');
        }
        if (data.hasOwnProperty('statTimerIntervalInSeconds')) {
          obj['statTimerIntervalInSeconds'] = _ApiClient["default"].convertToType(data['statTimerIntervalInSeconds'], 'Number');
        }
        if (data.hasOwnProperty('statAuthorizationScope')) {
          obj['statAuthorizationScope'] = _ApiClient["default"].convertToType(data['statAuthorizationScope'], 'String');
        }
        if (data.hasOwnProperty('allowSpontaneousScopes')) {
          obj['allowSpontaneousScopes'] = _ApiClient["default"].convertToType(data['allowSpontaneousScopes'], 'Boolean');
        }
        if (data.hasOwnProperty('spontaneousScopeLifetime')) {
          obj['spontaneousScopeLifetime'] = _ApiClient["default"].convertToType(data['spontaneousScopeLifetime'], 'Number');
        }
        if (data.hasOwnProperty('statusListBitSize')) {
          obj['statusListBitSize'] = _ApiClient["default"].convertToType(data['statusListBitSize'], 'Number');
        }
        if (data.hasOwnProperty('statusListResponseJwtSignatureAlgorithm')) {
          obj['statusListResponseJwtSignatureAlgorithm'] = _ApiClient["default"].convertToType(data['statusListResponseJwtSignatureAlgorithm'], 'String');
        }
        if (data.hasOwnProperty('statusListResponseJwtLifetime')) {
          obj['statusListResponseJwtLifetime'] = _ApiClient["default"].convertToType(data['statusListResponseJwtLifetime'], 'Number');
        }
        if (data.hasOwnProperty('statusListIndexAllocationBlockSize')) {
          obj['statusListIndexAllocationBlockSize'] = _ApiClient["default"].convertToType(data['statusListIndexAllocationBlockSize'], 'Number');
        }
        if (data.hasOwnProperty('openidSubAttribute')) {
          obj['openidSubAttribute'] = _ApiClient["default"].convertToType(data['openidSubAttribute'], 'String');
        }
        if (data.hasOwnProperty('publicSubjectIdentifierPerClientEnabled')) {
          obj['publicSubjectIdentifierPerClientEnabled'] = _ApiClient["default"].convertToType(data['publicSubjectIdentifierPerClientEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('subjectIdentifiersPerClientSupported')) {
          obj['subjectIdentifiersPerClientSupported'] = _ApiClient["default"].convertToType(data['subjectIdentifiersPerClientSupported'], ['String']);
        }
        if (data.hasOwnProperty('applyXFrameOptionsHeaderIfUriContainsAny')) {
          obj['applyXFrameOptionsHeaderIfUriContainsAny'] = _ApiClient["default"].convertToType(data['applyXFrameOptionsHeaderIfUriContainsAny'], ['String']);
        }
        if (data.hasOwnProperty('xframeOptionsHeaderValue')) {
          obj['xframeOptionsHeaderValue'] = _ApiClient["default"].convertToType(data['xframeOptionsHeaderValue'], 'String');
        }
        if (data.hasOwnProperty('responseTypesSupported')) {
          obj['responseTypesSupported'] = _ApiClient["default"].convertToType(data['responseTypesSupported'], [['String']]);
        }
        if (data.hasOwnProperty('responseModesSupported')) {
          obj['responseModesSupported'] = _ApiClient["default"].convertToType(data['responseModesSupported'], ['String']);
        }
        if (data.hasOwnProperty('grantTypesSupported')) {
          obj['grantTypesSupported'] = _ApiClient["default"].convertToType(data['grantTypesSupported'], ['String']);
        }
        if (data.hasOwnProperty('subjectTypesSupported')) {
          obj['subjectTypesSupported'] = _ApiClient["default"].convertToType(data['subjectTypesSupported'], ['String']);
        }
        if (data.hasOwnProperty('defaultSubjectType')) {
          obj['defaultSubjectType'] = _ApiClient["default"].convertToType(data['defaultSubjectType'], 'String');
        }
        if (data.hasOwnProperty('authorizationSigningAlgValuesSupported')) {
          obj['authorizationSigningAlgValuesSupported'] = _ApiClient["default"].convertToType(data['authorizationSigningAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('authorizationEncryptionAlgValuesSupported')) {
          obj['authorizationEncryptionAlgValuesSupported'] = _ApiClient["default"].convertToType(data['authorizationEncryptionAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('authorizationEncryptionEncValuesSupported')) {
          obj['authorizationEncryptionEncValuesSupported'] = _ApiClient["default"].convertToType(data['authorizationEncryptionEncValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('userInfoSigningAlgValuesSupported')) {
          obj['userInfoSigningAlgValuesSupported'] = _ApiClient["default"].convertToType(data['userInfoSigningAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('userInfoEncryptionAlgValuesSupported')) {
          obj['userInfoEncryptionAlgValuesSupported'] = _ApiClient["default"].convertToType(data['userInfoEncryptionAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('userInfoEncryptionEncValuesSupported')) {
          obj['userInfoEncryptionEncValuesSupported'] = _ApiClient["default"].convertToType(data['userInfoEncryptionEncValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('introspectionSigningAlgValuesSupported')) {
          obj['introspectionSigningAlgValuesSupported'] = _ApiClient["default"].convertToType(data['introspectionSigningAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('introspectionEncryptionAlgValuesSupported')) {
          obj['introspectionEncryptionAlgValuesSupported'] = _ApiClient["default"].convertToType(data['introspectionEncryptionAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('introspectionEncryptionEncValuesSupported')) {
          obj['introspectionEncryptionEncValuesSupported'] = _ApiClient["default"].convertToType(data['introspectionEncryptionEncValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('txTokenSigningAlgValuesSupported')) {
          obj['txTokenSigningAlgValuesSupported'] = _ApiClient["default"].convertToType(data['txTokenSigningAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('txTokenEncryptionAlgValuesSupported')) {
          obj['txTokenEncryptionAlgValuesSupported'] = _ApiClient["default"].convertToType(data['txTokenEncryptionAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('txTokenEncryptionEncValuesSupported')) {
          obj['txTokenEncryptionEncValuesSupported'] = _ApiClient["default"].convertToType(data['txTokenEncryptionEncValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('idTokenSigningAlgValuesSupported')) {
          obj['idTokenSigningAlgValuesSupported'] = _ApiClient["default"].convertToType(data['idTokenSigningAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('idTokenEncryptionAlgValuesSupported')) {
          obj['idTokenEncryptionAlgValuesSupported'] = _ApiClient["default"].convertToType(data['idTokenEncryptionAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('idTokenEncryptionEncValuesSupported')) {
          obj['idTokenEncryptionEncValuesSupported'] = _ApiClient["default"].convertToType(data['idTokenEncryptionEncValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('accessTokenSigningAlgValuesSupported')) {
          obj['accessTokenSigningAlgValuesSupported'] = _ApiClient["default"].convertToType(data['accessTokenSigningAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('forceSignedRequestObject')) {
          obj['forceSignedRequestObject'] = _ApiClient["default"].convertToType(data['forceSignedRequestObject'], 'Boolean');
        }
        if (data.hasOwnProperty('requestObjectSigningAlgValuesSupported')) {
          obj['requestObjectSigningAlgValuesSupported'] = _ApiClient["default"].convertToType(data['requestObjectSigningAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('requestObjectEncryptionAlgValuesSupported')) {
          obj['requestObjectEncryptionAlgValuesSupported'] = _ApiClient["default"].convertToType(data['requestObjectEncryptionAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('requestObjectEncryptionEncValuesSupported')) {
          obj['requestObjectEncryptionEncValuesSupported'] = _ApiClient["default"].convertToType(data['requestObjectEncryptionEncValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('tokenEndpointAuthMethodsSupported')) {
          obj['tokenEndpointAuthMethodsSupported'] = _ApiClient["default"].convertToType(data['tokenEndpointAuthMethodsSupported'], ['String']);
        }
        if (data.hasOwnProperty('tokenEndpointAuthSigningAlgValuesSupported')) {
          obj['tokenEndpointAuthSigningAlgValuesSupported'] = _ApiClient["default"].convertToType(data['tokenEndpointAuthSigningAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('dynamicRegistrationCustomAttributes')) {
          obj['dynamicRegistrationCustomAttributes'] = _ApiClient["default"].convertToType(data['dynamicRegistrationCustomAttributes'], ['String']);
        }
        if (data.hasOwnProperty('dynamicRegistrationDefaultCustomAttributes')) {
          obj['dynamicRegistrationDefaultCustomAttributes'] = _ApiClient["default"].convertToType(data['dynamicRegistrationDefaultCustomAttributes'], Object);
        }
        if (data.hasOwnProperty('displayValuesSupported')) {
          obj['displayValuesSupported'] = _ApiClient["default"].convertToType(data['displayValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('claimTypesSupported')) {
          obj['claimTypesSupported'] = _ApiClient["default"].convertToType(data['claimTypesSupported'], ['String']);
        }
        if (data.hasOwnProperty('jwksAlgorithmsSupported')) {
          obj['jwksAlgorithmsSupported'] = _ApiClient["default"].convertToType(data['jwksAlgorithmsSupported'], ['String']);
        }
        if (data.hasOwnProperty('serviceDocumentation')) {
          obj['serviceDocumentation'] = _ApiClient["default"].convertToType(data['serviceDocumentation'], 'String');
        }
        if (data.hasOwnProperty('claimsLocalesSupported')) {
          obj['claimsLocalesSupported'] = _ApiClient["default"].convertToType(data['claimsLocalesSupported'], ['String']);
        }
        if (data.hasOwnProperty('idTokenTokenBindingCnfValuesSupported')) {
          obj['idTokenTokenBindingCnfValuesSupported'] = _ApiClient["default"].convertToType(data['idTokenTokenBindingCnfValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('uiLocalesSupported')) {
          obj['uiLocalesSupported'] = _ApiClient["default"].convertToType(data['uiLocalesSupported'], ['String']);
        }
        if (data.hasOwnProperty('claimsParameterSupported')) {
          obj['claimsParameterSupported'] = _ApiClient["default"].convertToType(data['claimsParameterSupported'], 'Boolean');
        }
        if (data.hasOwnProperty('requestParameterSupported')) {
          obj['requestParameterSupported'] = _ApiClient["default"].convertToType(data['requestParameterSupported'], 'Boolean');
        }
        if (data.hasOwnProperty('requestUriParameterSupported')) {
          obj['requestUriParameterSupported'] = _ApiClient["default"].convertToType(data['requestUriParameterSupported'], 'Boolean');
        }
        if (data.hasOwnProperty('requestUriHashVerificationEnabled')) {
          obj['requestUriHashVerificationEnabled'] = _ApiClient["default"].convertToType(data['requestUriHashVerificationEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('requireRequestUriRegistration')) {
          obj['requireRequestUriRegistration'] = _ApiClient["default"].convertToType(data['requireRequestUriRegistration'], 'Boolean');
        }
        if (data.hasOwnProperty('requestUriBlockList')) {
          obj['requestUriBlockList'] = _ApiClient["default"].convertToType(data['requestUriBlockList'], ['String']);
        }
        if (data.hasOwnProperty('opPolicyUri')) {
          obj['opPolicyUri'] = _ApiClient["default"].convertToType(data['opPolicyUri'], 'String');
        }
        if (data.hasOwnProperty('opTosUri')) {
          obj['opTosUri'] = _ApiClient["default"].convertToType(data['opTosUri'], 'String');
        }
        if (data.hasOwnProperty('cleanUpInactiveClientAfterHoursOfInactivity')) {
          obj['cleanUpInactiveClientAfterHoursOfInactivity'] = _ApiClient["default"].convertToType(data['cleanUpInactiveClientAfterHoursOfInactivity'], 'Number');
        }
        if (data.hasOwnProperty('clientPeriodicUpdateTimerInterval')) {
          obj['clientPeriodicUpdateTimerInterval'] = _ApiClient["default"].convertToType(data['clientPeriodicUpdateTimerInterval'], 'Number');
        }
        if (data.hasOwnProperty('authorizationCodeLifetime')) {
          obj['authorizationCodeLifetime'] = _ApiClient["default"].convertToType(data['authorizationCodeLifetime'], 'Number');
        }
        if (data.hasOwnProperty('refreshTokenLifetime')) {
          obj['refreshTokenLifetime'] = _ApiClient["default"].convertToType(data['refreshTokenLifetime'], 'Number');
        }
        if (data.hasOwnProperty('txTokenLifetime')) {
          obj['txTokenLifetime'] = _ApiClient["default"].convertToType(data['txTokenLifetime'], 'Number');
        }
        if (data.hasOwnProperty('idTokenLifetime')) {
          obj['idTokenLifetime'] = _ApiClient["default"].convertToType(data['idTokenLifetime'], 'Number');
        }
        if (data.hasOwnProperty('idTokenFilterClaimsBasedOnAccessToken')) {
          obj['idTokenFilterClaimsBasedOnAccessToken'] = _ApiClient["default"].convertToType(data['idTokenFilterClaimsBasedOnAccessToken'], 'Boolean');
        }
        if (data.hasOwnProperty('saveTokensInCache')) {
          obj['saveTokensInCache'] = _ApiClient["default"].convertToType(data['saveTokensInCache'], 'Boolean');
        }
        if (data.hasOwnProperty('saveTokensInCacheAndDontSaveInPersistence')) {
          obj['saveTokensInCacheAndDontSaveInPersistence'] = _ApiClient["default"].convertToType(data['saveTokensInCacheAndDontSaveInPersistence'], 'Boolean');
        }
        if (data.hasOwnProperty('accessTokenLifetime')) {
          obj['accessTokenLifetime'] = _ApiClient["default"].convertToType(data['accessTokenLifetime'], 'Number');
        }
        if (data.hasOwnProperty('userInfoLifetime')) {
          obj['userInfoLifetime'] = _ApiClient["default"].convertToType(data['userInfoLifetime'], 'Number');
        }
        if (data.hasOwnProperty('cleanServiceInterval')) {
          obj['cleanServiceInterval'] = _ApiClient["default"].convertToType(data['cleanServiceInterval'], 'Number');
        }
        if (data.hasOwnProperty('cleanServiceBatchChunkSize')) {
          obj['cleanServiceBatchChunkSize'] = _ApiClient["default"].convertToType(data['cleanServiceBatchChunkSize'], 'Number');
        }
        if (data.hasOwnProperty('keyRegenerationEnabled')) {
          obj['keyRegenerationEnabled'] = _ApiClient["default"].convertToType(data['keyRegenerationEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('keyRegenerationInterval')) {
          obj['keyRegenerationInterval'] = _ApiClient["default"].convertToType(data['keyRegenerationInterval'], 'Number');
        }
        if (data.hasOwnProperty('defaultSignatureAlgorithm')) {
          obj['defaultSignatureAlgorithm'] = _ApiClient["default"].convertToType(data['defaultSignatureAlgorithm'], 'String');
        }
        if (data.hasOwnProperty('jansOpenIdConnectVersion')) {
          obj['jansOpenIdConnectVersion'] = _ApiClient["default"].convertToType(data['jansOpenIdConnectVersion'], 'String');
        }
        if (data.hasOwnProperty('jansId')) {
          obj['jansId'] = _ApiClient["default"].convertToType(data['jansId'], 'String');
        }
        if (data.hasOwnProperty('dynamicRegistrationExpirationTime')) {
          obj['dynamicRegistrationExpirationTime'] = _ApiClient["default"].convertToType(data['dynamicRegistrationExpirationTime'], 'Number');
        }
        if (data.hasOwnProperty('dynamicRegistrationPersistClientAuthorizations')) {
          obj['dynamicRegistrationPersistClientAuthorizations'] = _ApiClient["default"].convertToType(data['dynamicRegistrationPersistClientAuthorizations'], 'Boolean');
        }
        if (data.hasOwnProperty('trustedClientEnabled')) {
          obj['trustedClientEnabled'] = _ApiClient["default"].convertToType(data['trustedClientEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('skipAuthorizationForOpenIdScopeAndPairwiseId')) {
          obj['skipAuthorizationForOpenIdScopeAndPairwiseId'] = _ApiClient["default"].convertToType(data['skipAuthorizationForOpenIdScopeAndPairwiseId'], 'Boolean');
        }
        if (data.hasOwnProperty('dynamicRegistrationScopesParamEnabled')) {
          obj['dynamicRegistrationScopesParamEnabled'] = _ApiClient["default"].convertToType(data['dynamicRegistrationScopesParamEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('dynamicRegistrationPasswordGrantTypeEnabled')) {
          obj['dynamicRegistrationPasswordGrantTypeEnabled'] = _ApiClient["default"].convertToType(data['dynamicRegistrationPasswordGrantTypeEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('dynamicRegistrationAllowedPasswordGrantScopes')) {
          obj['dynamicRegistrationAllowedPasswordGrantScopes'] = _ApiClient["default"].convertToType(data['dynamicRegistrationAllowedPasswordGrantScopes'], ['String']);
        }
        if (data.hasOwnProperty('dynamicRegistrationCustomObjectClass')) {
          obj['dynamicRegistrationCustomObjectClass'] = _ApiClient["default"].convertToType(data['dynamicRegistrationCustomObjectClass'], 'String');
        }
        if (data.hasOwnProperty('personCustomObjectClassList')) {
          obj['personCustomObjectClassList'] = _ApiClient["default"].convertToType(data['personCustomObjectClassList'], ['String']);
        }
        if (data.hasOwnProperty('persistIdToken')) {
          obj['persistIdToken'] = _ApiClient["default"].convertToType(data['persistIdToken'], 'Boolean');
        }
        if (data.hasOwnProperty('persistRefreshToken')) {
          obj['persistRefreshToken'] = _ApiClient["default"].convertToType(data['persistRefreshToken'], 'Boolean');
        }
        if (data.hasOwnProperty('allowPostLogoutRedirectWithoutValidation')) {
          obj['allowPostLogoutRedirectWithoutValidation'] = _ApiClient["default"].convertToType(data['allowPostLogoutRedirectWithoutValidation'], 'Boolean');
        }
        if (data.hasOwnProperty('invalidateSessionCookiesAfterAuthorizationFlow')) {
          obj['invalidateSessionCookiesAfterAuthorizationFlow'] = _ApiClient["default"].convertToType(data['invalidateSessionCookiesAfterAuthorizationFlow'], 'Boolean');
        }
        if (data.hasOwnProperty('returnClientSecretOnRead')) {
          obj['returnClientSecretOnRead'] = _ApiClient["default"].convertToType(data['returnClientSecretOnRead'], 'Boolean');
        }
        if (data.hasOwnProperty('rotateClientRegistrationAccessTokenOnUsage')) {
          obj['rotateClientRegistrationAccessTokenOnUsage'] = _ApiClient["default"].convertToType(data['rotateClientRegistrationAccessTokenOnUsage'], 'Boolean');
        }
        if (data.hasOwnProperty('rejectJwtWithNoneAlg')) {
          obj['rejectJwtWithNoneAlg'] = _ApiClient["default"].convertToType(data['rejectJwtWithNoneAlg'], 'Boolean');
        }
        if (data.hasOwnProperty('expirationNotificatorEnabled')) {
          obj['expirationNotificatorEnabled'] = _ApiClient["default"].convertToType(data['expirationNotificatorEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('useNestedJwtDuringEncryption')) {
          obj['useNestedJwtDuringEncryption'] = _ApiClient["default"].convertToType(data['useNestedJwtDuringEncryption'], 'Boolean');
        }
        if (data.hasOwnProperty('expirationNotificatorMapSizeLimit')) {
          obj['expirationNotificatorMapSizeLimit'] = _ApiClient["default"].convertToType(data['expirationNotificatorMapSizeLimit'], 'Number');
        }
        if (data.hasOwnProperty('expirationNotificatorIntervalInSeconds')) {
          obj['expirationNotificatorIntervalInSeconds'] = _ApiClient["default"].convertToType(data['expirationNotificatorIntervalInSeconds'], 'Number');
        }
        if (data.hasOwnProperty('redirectUrisRegexEnabled')) {
          obj['redirectUrisRegexEnabled'] = _ApiClient["default"].convertToType(data['redirectUrisRegexEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('useHighestLevelScriptIfAcrScriptNotFound')) {
          obj['useHighestLevelScriptIfAcrScriptNotFound'] = _ApiClient["default"].convertToType(data['useHighestLevelScriptIfAcrScriptNotFound'], 'Boolean');
        }
        if (data.hasOwnProperty('acrMappings')) {
          obj['acrMappings'] = _ApiClient["default"].convertToType(data['acrMappings'], {
            'String': 'String'
          });
        }
        if (data.hasOwnProperty('authenticationFiltersEnabled')) {
          obj['authenticationFiltersEnabled'] = _ApiClient["default"].convertToType(data['authenticationFiltersEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('clientAuthenticationFiltersEnabled')) {
          obj['clientAuthenticationFiltersEnabled'] = _ApiClient["default"].convertToType(data['clientAuthenticationFiltersEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('clientRegDefaultToCodeFlowWithRefresh')) {
          obj['clientRegDefaultToCodeFlowWithRefresh'] = _ApiClient["default"].convertToType(data['clientRegDefaultToCodeFlowWithRefresh'], 'Boolean');
        }
        if (data.hasOwnProperty('grantTypesAndResponseTypesAutofixEnabled')) {
          obj['grantTypesAndResponseTypesAutofixEnabled'] = _ApiClient["default"].convertToType(data['grantTypesAndResponseTypesAutofixEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('authenticationFilters')) {
          obj['authenticationFilters'] = _ApiClient["default"].convertToType(data['authenticationFilters'], [_AuthenticationFilter["default"]]);
        }
        if (data.hasOwnProperty('clientAuthenticationFilters')) {
          obj['clientAuthenticationFilters'] = _ApiClient["default"].convertToType(data['clientAuthenticationFilters'], [_ClientAuthenticationFilter["default"]]);
        }
        if (data.hasOwnProperty('corsConfigurationFilters')) {
          obj['corsConfigurationFilters'] = _ApiClient["default"].convertToType(data['corsConfigurationFilters'], [_CorsConfigurationFilter["default"]]);
        }
        if (data.hasOwnProperty('sessionIdUnusedLifetime')) {
          obj['sessionIdUnusedLifetime'] = _ApiClient["default"].convertToType(data['sessionIdUnusedLifetime'], 'Number');
        }
        if (data.hasOwnProperty('sessionIdUnauthenticatedUnusedLifetime')) {
          obj['sessionIdUnauthenticatedUnusedLifetime'] = _ApiClient["default"].convertToType(data['sessionIdUnauthenticatedUnusedLifetime'], 'Number');
        }
        if (data.hasOwnProperty('sessionIdPersistOnPromptNone')) {
          obj['sessionIdPersistOnPromptNone'] = _ApiClient["default"].convertToType(data['sessionIdPersistOnPromptNone'], 'Boolean');
        }
        if (data.hasOwnProperty('sessionIdRequestParameterEnabled')) {
          obj['sessionIdRequestParameterEnabled'] = _ApiClient["default"].convertToType(data['sessionIdRequestParameterEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('changeSessionIdOnAuthentication')) {
          obj['changeSessionIdOnAuthentication'] = _ApiClient["default"].convertToType(data['changeSessionIdOnAuthentication'], 'Boolean');
        }
        if (data.hasOwnProperty('sessionIdPersistInCache')) {
          obj['sessionIdPersistInCache'] = _ApiClient["default"].convertToType(data['sessionIdPersistInCache'], 'Boolean');
        }
        if (data.hasOwnProperty('includeSidInResponse')) {
          obj['includeSidInResponse'] = _ApiClient["default"].convertToType(data['includeSidInResponse'], 'Boolean');
        }
        if (data.hasOwnProperty('disablePromptLogin')) {
          obj['disablePromptLogin'] = _ApiClient["default"].convertToType(data['disablePromptLogin'], 'Boolean');
        }
        if (data.hasOwnProperty('disablePromptConsent')) {
          obj['disablePromptConsent'] = _ApiClient["default"].convertToType(data['disablePromptConsent'], 'Boolean');
        }
        if (data.hasOwnProperty('sessionIdCookieLifetime')) {
          obj['sessionIdCookieLifetime'] = _ApiClient["default"].convertToType(data['sessionIdCookieLifetime'], 'Number');
        }
        if (data.hasOwnProperty('sessionIdLifetime')) {
          obj['sessionIdLifetime'] = _ApiClient["default"].convertToType(data['sessionIdLifetime'], 'Number');
        }
        if (data.hasOwnProperty('activeSessionAuthorizationScope')) {
          obj['activeSessionAuthorizationScope'] = _ApiClient["default"].convertToType(data['activeSessionAuthorizationScope'], 'String');
        }
        if (data.hasOwnProperty('configurationUpdateInterval')) {
          obj['configurationUpdateInterval'] = _ApiClient["default"].convertToType(data['configurationUpdateInterval'], 'Number');
        }
        if (data.hasOwnProperty('logNotFoundEntityAsError')) {
          obj['logNotFoundEntityAsError'] = _ApiClient["default"].convertToType(data['logNotFoundEntityAsError'], 'Boolean');
        }
        if (data.hasOwnProperty('enableClientGrantTypeUpdate')) {
          obj['enableClientGrantTypeUpdate'] = _ApiClient["default"].convertToType(data['enableClientGrantTypeUpdate'], 'Boolean');
        }
        if (data.hasOwnProperty('grantTypesSupportedByDynamicRegistration')) {
          obj['grantTypesSupportedByDynamicRegistration'] = _ApiClient["default"].convertToType(data['grantTypesSupportedByDynamicRegistration'], ['String']);
        }
        if (data.hasOwnProperty('cssLocation')) {
          obj['cssLocation'] = _ApiClient["default"].convertToType(data['cssLocation'], 'String');
        }
        if (data.hasOwnProperty('jsLocation')) {
          obj['jsLocation'] = _ApiClient["default"].convertToType(data['jsLocation'], 'String');
        }
        if (data.hasOwnProperty('imgLocation')) {
          obj['imgLocation'] = _ApiClient["default"].convertToType(data['imgLocation'], 'String');
        }
        if (data.hasOwnProperty('metricReporterInterval')) {
          obj['metricReporterInterval'] = _ApiClient["default"].convertToType(data['metricReporterInterval'], 'Number');
        }
        if (data.hasOwnProperty('metricReporterKeepDataDays')) {
          obj['metricReporterKeepDataDays'] = _ApiClient["default"].convertToType(data['metricReporterKeepDataDays'], 'Number');
        }
        if (data.hasOwnProperty('pairwiseIdType')) {
          obj['pairwiseIdType'] = _ApiClient["default"].convertToType(data['pairwiseIdType'], 'String');
        }
        if (data.hasOwnProperty('pairwiseCalculationKey')) {
          obj['pairwiseCalculationKey'] = _ApiClient["default"].convertToType(data['pairwiseCalculationKey'], 'String');
        }
        if (data.hasOwnProperty('pairwiseCalculationSalt')) {
          obj['pairwiseCalculationSalt'] = _ApiClient["default"].convertToType(data['pairwiseCalculationSalt'], 'String');
        }
        if (data.hasOwnProperty('shareSubjectIdBetweenClientsWithSameSectorId')) {
          obj['shareSubjectIdBetweenClientsWithSameSectorId'] = _ApiClient["default"].convertToType(data['shareSubjectIdBetweenClientsWithSameSectorId'], 'Boolean');
        }
        if (data.hasOwnProperty('useOpenidSubAttributeValueForPairwiseLocalAccountId')) {
          obj['useOpenidSubAttributeValueForPairwiseLocalAccountId'] = _ApiClient["default"].convertToType(data['useOpenidSubAttributeValueForPairwiseLocalAccountId'], 'Boolean');
        }
        if (data.hasOwnProperty('webKeysStorage')) {
          obj['webKeysStorage'] = _ApiClient["default"].convertToType(data['webKeysStorage'], 'String');
        }
        if (data.hasOwnProperty('dnName')) {
          obj['dnName'] = _ApiClient["default"].convertToType(data['dnName'], 'String');
        }
        if (data.hasOwnProperty('keyStoreFile')) {
          obj['keyStoreFile'] = _ApiClient["default"].convertToType(data['keyStoreFile'], 'String');
        }
        if (data.hasOwnProperty('keyStoreSecret')) {
          obj['keyStoreSecret'] = _ApiClient["default"].convertToType(data['keyStoreSecret'], 'String');
        }
        if (data.hasOwnProperty('keySelectionStrategy')) {
          obj['keySelectionStrategy'] = _ApiClient["default"].convertToType(data['keySelectionStrategy'], 'String');
        }
        if (data.hasOwnProperty('keyAlgsAllowedForGeneration')) {
          obj['keyAlgsAllowedForGeneration'] = _ApiClient["default"].convertToType(data['keyAlgsAllowedForGeneration'], ['String']);
        }
        if (data.hasOwnProperty('keySignWithSameKeyButDiffAlg')) {
          obj['keySignWithSameKeyButDiffAlg'] = _ApiClient["default"].convertToType(data['keySignWithSameKeyButDiffAlg'], 'Boolean');
        }
        if (data.hasOwnProperty('staticKid')) {
          obj['staticKid'] = _ApiClient["default"].convertToType(data['staticKid'], 'String');
        }
        if (data.hasOwnProperty('staticDecryptionKid')) {
          obj['staticDecryptionKid'] = _ApiClient["default"].convertToType(data['staticDecryptionKid'], 'String');
        }
        if (data.hasOwnProperty('introspectionAccessTokenMustHaveUmaProtectionScope')) {
          obj['introspectionAccessTokenMustHaveUmaProtectionScope'] = _ApiClient["default"].convertToType(data['introspectionAccessTokenMustHaveUmaProtectionScope'], 'Boolean');
        }
        if (data.hasOwnProperty('introspectionAccessTokenMustHaveIntrospectionScope')) {
          obj['introspectionAccessTokenMustHaveIntrospectionScope'] = _ApiClient["default"].convertToType(data['introspectionAccessTokenMustHaveIntrospectionScope'], 'Boolean');
        }
        if (data.hasOwnProperty('introspectionSkipAuthorization')) {
          obj['introspectionSkipAuthorization'] = _ApiClient["default"].convertToType(data['introspectionSkipAuthorization'], 'Boolean');
        }
        if (data.hasOwnProperty('introspectionRestrictBasicAuthnToOwnTokens')) {
          obj['introspectionRestrictBasicAuthnToOwnTokens'] = _ApiClient["default"].convertToType(data['introspectionRestrictBasicAuthnToOwnTokens'], 'Boolean');
        }
        if (data.hasOwnProperty('endSessionWithAccessToken')) {
          obj['endSessionWithAccessToken'] = _ApiClient["default"].convertToType(data['endSessionWithAccessToken'], 'Boolean');
        }
        if (data.hasOwnProperty('disablePromptCreate')) {
          obj['disablePromptCreate'] = _ApiClient["default"].convertToType(data['disablePromptCreate'], 'Boolean');
        }
        if (data.hasOwnProperty('cookieDomain')) {
          obj['cookieDomain'] = _ApiClient["default"].convertToType(data['cookieDomain'], 'String');
        }
        if (data.hasOwnProperty('enabledOAuthAuditLogging')) {
          obj['enabledOAuthAuditLogging'] = _ApiClient["default"].convertToType(data['enabledOAuthAuditLogging'], 'Boolean');
        }
        if (data.hasOwnProperty('jmsBrokerURISet')) {
          obj['jmsBrokerURISet'] = _ApiClient["default"].convertToType(data['jmsBrokerURISet'], ['String']);
        }
        if (data.hasOwnProperty('jmsUserName')) {
          obj['jmsUserName'] = _ApiClient["default"].convertToType(data['jmsUserName'], 'String');
        }
        if (data.hasOwnProperty('jmsPassword')) {
          obj['jmsPassword'] = _ApiClient["default"].convertToType(data['jmsPassword'], 'String');
        }
        if (data.hasOwnProperty('externalUriWhiteList')) {
          obj['externalUriWhiteList'] = _ApiClient["default"].convertToType(data['externalUriWhiteList'], ['String']);
        }
        if (data.hasOwnProperty('clientWhiteList')) {
          obj['clientWhiteList'] = _ApiClient["default"].convertToType(data['clientWhiteList'], ['String']);
        }
        if (data.hasOwnProperty('clientBlackList')) {
          obj['clientBlackList'] = _ApiClient["default"].convertToType(data['clientBlackList'], ['String']);
        }
        if (data.hasOwnProperty('legacyIdTokenClaims')) {
          obj['legacyIdTokenClaims'] = _ApiClient["default"].convertToType(data['legacyIdTokenClaims'], 'Boolean');
        }
        if (data.hasOwnProperty('customHeadersWithAuthorizationResponse')) {
          obj['customHeadersWithAuthorizationResponse'] = _ApiClient["default"].convertToType(data['customHeadersWithAuthorizationResponse'], 'Boolean');
        }
        if (data.hasOwnProperty('frontChannelLogoutSessionSupported')) {
          obj['frontChannelLogoutSessionSupported'] = _ApiClient["default"].convertToType(data['frontChannelLogoutSessionSupported'], 'Boolean');
        }
        if (data.hasOwnProperty('loggingLevel')) {
          obj['loggingLevel'] = _ApiClient["default"].convertToType(data['loggingLevel'], 'String');
        }
        if (data.hasOwnProperty('loggingLayout')) {
          obj['loggingLayout'] = _ApiClient["default"].convertToType(data['loggingLayout'], 'String');
        }
        if (data.hasOwnProperty('updateUserLastLogonTime')) {
          obj['updateUserLastLogonTime'] = _ApiClient["default"].convertToType(data['updateUserLastLogonTime'], 'Boolean');
        }
        if (data.hasOwnProperty('updateClientAccessTime')) {
          obj['updateClientAccessTime'] = _ApiClient["default"].convertToType(data['updateClientAccessTime'], 'Boolean');
        }
        if (data.hasOwnProperty('logClientIdOnClientAuthentication')) {
          obj['logClientIdOnClientAuthentication'] = _ApiClient["default"].convertToType(data['logClientIdOnClientAuthentication'], 'Boolean');
        }
        if (data.hasOwnProperty('logClientNameOnClientAuthentication')) {
          obj['logClientNameOnClientAuthentication'] = _ApiClient["default"].convertToType(data['logClientNameOnClientAuthentication'], 'Boolean');
        }
        if (data.hasOwnProperty('disableJdkLogger')) {
          obj['disableJdkLogger'] = _ApiClient["default"].convertToType(data['disableJdkLogger'], 'Boolean');
        }
        if (data.hasOwnProperty('authorizationRequestCustomAllowedParameters')) {
          obj['authorizationRequestCustomAllowedParameters'] = _ApiClient["default"].convertToType(data['authorizationRequestCustomAllowedParameters'], [_AuthorizationRequestCustomParameter["default"]]);
        }
        if (data.hasOwnProperty('openidScopeBackwardCompatibility')) {
          obj['openidScopeBackwardCompatibility'] = _ApiClient["default"].convertToType(data['openidScopeBackwardCompatibility'], 'Boolean');
        }
        if (data.hasOwnProperty('disableU2fEndpoint')) {
          obj['disableU2fEndpoint'] = _ApiClient["default"].convertToType(data['disableU2fEndpoint'], 'Boolean');
        }
        if (data.hasOwnProperty('authorizationChallengeSessionLifetimeInSeconds')) {
          obj['authorizationChallengeSessionLifetimeInSeconds'] = _ApiClient["default"].convertToType(data['authorizationChallengeSessionLifetimeInSeconds'], 'Number');
        }
        if (data.hasOwnProperty('rotateDeviceSecret')) {
          obj['rotateDeviceSecret'] = _ApiClient["default"].convertToType(data['rotateDeviceSecret'], 'Boolean');
        }
        if (data.hasOwnProperty('returnDeviceSecretFromAuthzEndpoint')) {
          obj['returnDeviceSecretFromAuthzEndpoint'] = _ApiClient["default"].convertToType(data['returnDeviceSecretFromAuthzEndpoint'], 'Boolean');
        }
        if (data.hasOwnProperty('dcrForbidExpirationTimeInRequest')) {
          obj['dcrForbidExpirationTimeInRequest'] = _ApiClient["default"].convertToType(data['dcrForbidExpirationTimeInRequest'], 'Boolean');
        }
        if (data.hasOwnProperty('dcrSignatureValidationEnabled')) {
          obj['dcrSignatureValidationEnabled'] = _ApiClient["default"].convertToType(data['dcrSignatureValidationEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('dcrSignatureValidationSharedSecret')) {
          obj['dcrSignatureValidationSharedSecret'] = _ApiClient["default"].convertToType(data['dcrSignatureValidationSharedSecret'], 'String');
        }
        if (data.hasOwnProperty('dcrSignatureValidationSoftwareStatementJwksURIClaim')) {
          obj['dcrSignatureValidationSoftwareStatementJwksURIClaim'] = _ApiClient["default"].convertToType(data['dcrSignatureValidationSoftwareStatementJwksURIClaim'], 'String');
        }
        if (data.hasOwnProperty('dcrSignatureValidationSoftwareStatementJwksClaim')) {
          obj['dcrSignatureValidationSoftwareStatementJwksClaim'] = _ApiClient["default"].convertToType(data['dcrSignatureValidationSoftwareStatementJwksClaim'], 'String');
        }
        if (data.hasOwnProperty('dcrSignatureValidationJwks')) {
          obj['dcrSignatureValidationJwks'] = _ApiClient["default"].convertToType(data['dcrSignatureValidationJwks'], 'String');
        }
        if (data.hasOwnProperty('dcrSignatureValidationJwksUri')) {
          obj['dcrSignatureValidationJwksUri'] = _ApiClient["default"].convertToType(data['dcrSignatureValidationJwksUri'], 'String');
        }
        if (data.hasOwnProperty('dcrAuthorizationWithClientCredentials')) {
          obj['dcrAuthorizationWithClientCredentials'] = _ApiClient["default"].convertToType(data['dcrAuthorizationWithClientCredentials'], 'Boolean');
        }
        if (data.hasOwnProperty('dcrAuthorizationWithMTLS')) {
          obj['dcrAuthorizationWithMTLS'] = _ApiClient["default"].convertToType(data['dcrAuthorizationWithMTLS'], 'Boolean');
        }
        if (data.hasOwnProperty('dcrAttestationEvidenceRequired')) {
          obj['dcrAttestationEvidenceRequired'] = _ApiClient["default"].convertToType(data['dcrAttestationEvidenceRequired'], 'Boolean');
        }
        if (data.hasOwnProperty('trustedSsaIssuers')) {
          obj['trustedSsaIssuers'] = _ApiClient["default"].convertToType(data['trustedSsaIssuers'], {
            'String': _TrustedIssuerConfig["default"]
          });
        }
        if (data.hasOwnProperty('useLocalCache')) {
          obj['useLocalCache'] = _ApiClient["default"].convertToType(data['useLocalCache'], 'Boolean');
        }
        if (data.hasOwnProperty('fapiCompatibility')) {
          obj['fapiCompatibility'] = _ApiClient["default"].convertToType(data['fapiCompatibility'], 'Boolean');
        }
        if (data.hasOwnProperty('forceIdTokenHintPresence')) {
          obj['forceIdTokenHintPresence'] = _ApiClient["default"].convertToType(data['forceIdTokenHintPresence'], 'Boolean');
        }
        if (data.hasOwnProperty('rejectEndSessionIfIdTokenExpired')) {
          obj['rejectEndSessionIfIdTokenExpired'] = _ApiClient["default"].convertToType(data['rejectEndSessionIfIdTokenExpired'], 'Boolean');
        }
        if (data.hasOwnProperty('allowEndSessionWithUnmatchedSid')) {
          obj['allowEndSessionWithUnmatchedSid'] = _ApiClient["default"].convertToType(data['allowEndSessionWithUnmatchedSid'], 'Boolean');
        }
        if (data.hasOwnProperty('forceOfflineAccessScopeToEnableRefreshToken')) {
          obj['forceOfflineAccessScopeToEnableRefreshToken'] = _ApiClient["default"].convertToType(data['forceOfflineAccessScopeToEnableRefreshToken'], 'Boolean');
        }
        if (data.hasOwnProperty('errorReasonEnabled')) {
          obj['errorReasonEnabled'] = _ApiClient["default"].convertToType(data['errorReasonEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('removeRefreshTokensForClientOnLogout')) {
          obj['removeRefreshTokensForClientOnLogout'] = _ApiClient["default"].convertToType(data['removeRefreshTokensForClientOnLogout'], 'Boolean');
        }
        if (data.hasOwnProperty('skipRefreshTokenDuringRefreshing')) {
          obj['skipRefreshTokenDuringRefreshing'] = _ApiClient["default"].convertToType(data['skipRefreshTokenDuringRefreshing'], 'Boolean');
        }
        if (data.hasOwnProperty('refreshTokenExtendLifetimeOnRotation')) {
          obj['refreshTokenExtendLifetimeOnRotation'] = _ApiClient["default"].convertToType(data['refreshTokenExtendLifetimeOnRotation'], 'Boolean');
        }
        if (data.hasOwnProperty('allowBlankValuesInDiscoveryResponse')) {
          obj['allowBlankValuesInDiscoveryResponse'] = _ApiClient["default"].convertToType(data['allowBlankValuesInDiscoveryResponse'], 'Boolean');
        }
        if (data.hasOwnProperty('checkUserPresenceOnRefreshToken')) {
          obj['checkUserPresenceOnRefreshToken'] = _ApiClient["default"].convertToType(data['checkUserPresenceOnRefreshToken'], 'Boolean');
        }
        if (data.hasOwnProperty('consentGatheringScriptBackwardCompatibility')) {
          obj['consentGatheringScriptBackwardCompatibility'] = _ApiClient["default"].convertToType(data['consentGatheringScriptBackwardCompatibility'], 'Boolean');
        }
        if (data.hasOwnProperty('introspectionScriptBackwardCompatibility')) {
          obj['introspectionScriptBackwardCompatibility'] = _ApiClient["default"].convertToType(data['introspectionScriptBackwardCompatibility'], 'Boolean');
        }
        if (data.hasOwnProperty('introspectionResponseScopesBackwardCompatibility')) {
          obj['introspectionResponseScopesBackwardCompatibility'] = _ApiClient["default"].convertToType(data['introspectionResponseScopesBackwardCompatibility'], 'Boolean');
        }
        if (data.hasOwnProperty('softwareStatementValidationType')) {
          obj['softwareStatementValidationType'] = _ApiClient["default"].convertToType(data['softwareStatementValidationType'], 'String');
        }
        if (data.hasOwnProperty('softwareStatementValidationClaimName')) {
          obj['softwareStatementValidationClaimName'] = _ApiClient["default"].convertToType(data['softwareStatementValidationClaimName'], 'String');
        }
        if (data.hasOwnProperty('authenticationProtectionConfiguration')) {
          obj['authenticationProtectionConfiguration'] = _AuthenticationProtectionConfiguration["default"].constructFromObject(data['authenticationProtectionConfiguration']);
        }
        if (data.hasOwnProperty('errorHandlingMethod')) {
          obj['errorHandlingMethod'] = _ApiClient["default"].convertToType(data['errorHandlingMethod'], 'String');
        }
        if (data.hasOwnProperty('disableAuthnForMaxAgeZero')) {
          obj['disableAuthnForMaxAgeZero'] = _ApiClient["default"].convertToType(data['disableAuthnForMaxAgeZero'], 'Boolean');
        }
        if (data.hasOwnProperty('keepAuthenticatorAttributesOnAcrChange')) {
          obj['keepAuthenticatorAttributesOnAcrChange'] = _ApiClient["default"].convertToType(data['keepAuthenticatorAttributesOnAcrChange'], 'Boolean');
        }
        if (data.hasOwnProperty('deviceAuthzRequestExpiresIn')) {
          obj['deviceAuthzRequestExpiresIn'] = _ApiClient["default"].convertToType(data['deviceAuthzRequestExpiresIn'], 'Number');
        }
        if (data.hasOwnProperty('deviceAuthzTokenPollInterval')) {
          obj['deviceAuthzTokenPollInterval'] = _ApiClient["default"].convertToType(data['deviceAuthzTokenPollInterval'], 'Number');
        }
        if (data.hasOwnProperty('deviceAuthzResponseTypeToProcessAuthz')) {
          obj['deviceAuthzResponseTypeToProcessAuthz'] = _ApiClient["default"].convertToType(data['deviceAuthzResponseTypeToProcessAuthz'], 'String');
        }
        if (data.hasOwnProperty('deviceAuthzAcr')) {
          obj['deviceAuthzAcr'] = _ApiClient["default"].convertToType(data['deviceAuthzAcr'], 'String');
        }
        if (data.hasOwnProperty('backchannelClientId')) {
          obj['backchannelClientId'] = _ApiClient["default"].convertToType(data['backchannelClientId'], 'String');
        }
        if (data.hasOwnProperty('backchannelRedirectUri')) {
          obj['backchannelRedirectUri'] = _ApiClient["default"].convertToType(data['backchannelRedirectUri'], 'String');
        }
        if (data.hasOwnProperty('backchannelAuthenticationEndpoint')) {
          obj['backchannelAuthenticationEndpoint'] = _ApiClient["default"].convertToType(data['backchannelAuthenticationEndpoint'], 'String');
        }
        if (data.hasOwnProperty('backchannelDeviceRegistrationEndpoint')) {
          obj['backchannelDeviceRegistrationEndpoint'] = _ApiClient["default"].convertToType(data['backchannelDeviceRegistrationEndpoint'], 'String');
        }
        if (data.hasOwnProperty('backchannelTokenDeliveryModesSupported')) {
          obj['backchannelTokenDeliveryModesSupported'] = _ApiClient["default"].convertToType(data['backchannelTokenDeliveryModesSupported'], ['String']);
        }
        if (data.hasOwnProperty('backchannelAuthenticationRequestSigningAlgValuesSupported')) {
          obj['backchannelAuthenticationRequestSigningAlgValuesSupported'] = _ApiClient["default"].convertToType(data['backchannelAuthenticationRequestSigningAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('backchannelUserCodeParameterSupported')) {
          obj['backchannelUserCodeParameterSupported'] = _ApiClient["default"].convertToType(data['backchannelUserCodeParameterSupported'], 'Boolean');
        }
        if (data.hasOwnProperty('backchannelBindingMessagePattern')) {
          obj['backchannelBindingMessagePattern'] = _ApiClient["default"].convertToType(data['backchannelBindingMessagePattern'], 'String');
        }
        if (data.hasOwnProperty('backchannelAuthenticationResponseExpiresIn')) {
          obj['backchannelAuthenticationResponseExpiresIn'] = _ApiClient["default"].convertToType(data['backchannelAuthenticationResponseExpiresIn'], 'Number');
        }
        if (data.hasOwnProperty('backchannelAuthenticationResponseInterval')) {
          obj['backchannelAuthenticationResponseInterval'] = _ApiClient["default"].convertToType(data['backchannelAuthenticationResponseInterval'], 'Number');
        }
        if (data.hasOwnProperty('backchannelLoginHintClaims')) {
          obj['backchannelLoginHintClaims'] = _ApiClient["default"].convertToType(data['backchannelLoginHintClaims'], ['String']);
        }
        if (data.hasOwnProperty('cibaEndUserNotificationConfig')) {
          obj['cibaEndUserNotificationConfig'] = _CIBAEndUserNotificationConfig["default"].constructFromObject(data['cibaEndUserNotificationConfig']);
        }
        if (data.hasOwnProperty('backchannelRequestsProcessorJobIntervalSec')) {
          obj['backchannelRequestsProcessorJobIntervalSec'] = _ApiClient["default"].convertToType(data['backchannelRequestsProcessorJobIntervalSec'], 'Number');
        }
        if (data.hasOwnProperty('backchannelRequestsProcessorJobChunkSize')) {
          obj['backchannelRequestsProcessorJobChunkSize'] = _ApiClient["default"].convertToType(data['backchannelRequestsProcessorJobChunkSize'], 'Number');
        }
        if (data.hasOwnProperty('cibaGrantLifeExtraTimeSec')) {
          obj['cibaGrantLifeExtraTimeSec'] = _ApiClient["default"].convertToType(data['cibaGrantLifeExtraTimeSec'], 'Number');
        }
        if (data.hasOwnProperty('cibaMaxExpirationTimeAllowedSec')) {
          obj['cibaMaxExpirationTimeAllowedSec'] = _ApiClient["default"].convertToType(data['cibaMaxExpirationTimeAllowedSec'], 'Number');
        }
        if (data.hasOwnProperty('dpopSigningAlgValuesSupported')) {
          obj['dpopSigningAlgValuesSupported'] = _ApiClient["default"].convertToType(data['dpopSigningAlgValuesSupported'], ['String']);
        }
        if (data.hasOwnProperty('dpopTimeframe')) {
          obj['dpopTimeframe'] = _ApiClient["default"].convertToType(data['dpopTimeframe'], 'Number');
        }
        if (data.hasOwnProperty('dpopJtiCacheTime')) {
          obj['dpopJtiCacheTime'] = _ApiClient["default"].convertToType(data['dpopJtiCacheTime'], 'Number');
        }
        if (data.hasOwnProperty('dpopUseNonce')) {
          obj['dpopUseNonce'] = _ApiClient["default"].convertToType(data['dpopUseNonce'], 'Boolean');
        }
        if (data.hasOwnProperty('dpopNonceCacheTime')) {
          obj['dpopNonceCacheTime'] = _ApiClient["default"].convertToType(data['dpopNonceCacheTime'], 'Number');
        }
        if (data.hasOwnProperty('dpopJktForceForAuthorizationCode')) {
          obj['dpopJktForceForAuthorizationCode'] = _ApiClient["default"].convertToType(data['dpopJktForceForAuthorizationCode'], 'Boolean');
        }
        if (data.hasOwnProperty('allowIdTokenWithoutImplicitGrantType')) {
          obj['allowIdTokenWithoutImplicitGrantType'] = _ApiClient["default"].convertToType(data['allowIdTokenWithoutImplicitGrantType'], 'Boolean');
        }
        if (data.hasOwnProperty('forceRopcInAuthorizationEndpoint')) {
          obj['forceRopcInAuthorizationEndpoint'] = _ApiClient["default"].convertToType(data['forceRopcInAuthorizationEndpoint'], 'Boolean');
        }
        if (data.hasOwnProperty('discoveryCacheLifetimeInMinutes')) {
          obj['discoveryCacheLifetimeInMinutes'] = _ApiClient["default"].convertToType(data['discoveryCacheLifetimeInMinutes'], 'Number');
        }
        if (data.hasOwnProperty('discoveryAllowedKeys')) {
          obj['discoveryAllowedKeys'] = _ApiClient["default"].convertToType(data['discoveryAllowedKeys'], ['String']);
        }
        if (data.hasOwnProperty('discoveryDenyKeys')) {
          obj['discoveryDenyKeys'] = _ApiClient["default"].convertToType(data['discoveryDenyKeys'], ['String']);
        }
        if (data.hasOwnProperty('featureFlags')) {
          obj['featureFlags'] = _ApiClient["default"].convertToType(data['featureFlags'], ['String']);
        }
        if (data.hasOwnProperty('httpLoggingEnabled')) {
          obj['httpLoggingEnabled'] = _ApiClient["default"].convertToType(data['httpLoggingEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('httpLoggingExcludePaths')) {
          obj['httpLoggingExcludePaths'] = _ApiClient["default"].convertToType(data['httpLoggingExcludePaths'], ['String']);
        }
        if (data.hasOwnProperty('externalLoggerConfiguration')) {
          obj['externalLoggerConfiguration'] = _ApiClient["default"].convertToType(data['externalLoggerConfiguration'], 'String');
        }
        if (data.hasOwnProperty('agamaConfiguration')) {
          obj['agamaConfiguration'] = _EngineConfig["default"].constructFromObject(data['agamaConfiguration']);
        }
        if (data.hasOwnProperty('dcrSsaValidationConfigs')) {
          obj['dcrSsaValidationConfigs'] = _ApiClient["default"].convertToType(data['dcrSsaValidationConfigs'], [_SsaValidationConfig["default"]]);
        }
        if (data.hasOwnProperty('ssaConfiguration')) {
          obj['ssaConfiguration'] = _SsaConfiguration["default"].constructFromObject(data['ssaConfiguration']);
        }
        if (data.hasOwnProperty('blockWebviewAuthorizationEnabled')) {
          obj['blockWebviewAuthorizationEnabled'] = _ApiClient["default"].convertToType(data['blockWebviewAuthorizationEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('authorizationChallengeDefaultAcr')) {
          obj['authorizationChallengeDefaultAcr'] = _ApiClient["default"].convertToType(data['authorizationChallengeDefaultAcr'], 'String');
        }
        if (data.hasOwnProperty('authorizationChallengeShouldGenerateSession')) {
          obj['authorizationChallengeShouldGenerateSession'] = _ApiClient["default"].convertToType(data['authorizationChallengeShouldGenerateSession'], 'Boolean');
        }
        if (data.hasOwnProperty('dateFormatterPatterns')) {
          obj['dateFormatterPatterns'] = _ApiClient["default"].convertToType(data['dateFormatterPatterns'], {
            'String': 'String'
          });
        }
        if (data.hasOwnProperty('httpLoggingResponseBodyContent')) {
          obj['httpLoggingResponseBodyContent'] = _ApiClient["default"].convertToType(data['httpLoggingResponseBodyContent'], 'Boolean');
        }
        if (data.hasOwnProperty('skipAuthenticationFilterOptionsMethod')) {
          obj['skipAuthenticationFilterOptionsMethod'] = _ApiClient["default"].convertToType(data['skipAuthenticationFilterOptionsMethod'], 'Boolean');
        }
        if (data.hasOwnProperty('lockMessageConfig')) {
          obj['lockMessageConfig'] = _LockMessageConfig["default"].constructFromObject(data['lockMessageConfig']);
        }
        if (data.hasOwnProperty('allResponseTypesSupported')) {
          obj['allResponseTypesSupported'] = _ApiClient["default"].convertToType(data['allResponseTypesSupported'], ['String']);
        }
        if (data.hasOwnProperty('fapi')) {
          obj['fapi'] = _ApiClient["default"].convertToType(data['fapi'], 'Boolean');
        }
      }
      return obj;
    }
  }]);
}();
/**
 * @member {String} issuer
 */
AppConfiguration.prototype['issuer'] = undefined;

/**
 * @member {String} baseEndpoint
 */
AppConfiguration.prototype['baseEndpoint'] = undefined;

/**
 * @member {String} authorizationEndpoint
 */
AppConfiguration.prototype['authorizationEndpoint'] = undefined;

/**
 * @member {String} authorizationChallengeEndpoint
 */
AppConfiguration.prototype['authorizationChallengeEndpoint'] = undefined;

/**
 * @member {String} tokenEndpoint
 */
AppConfiguration.prototype['tokenEndpoint'] = undefined;

/**
 * @member {String} tokenRevocationEndpoint
 */
AppConfiguration.prototype['tokenRevocationEndpoint'] = undefined;

/**
 * @member {String} userInfoEndpoint
 */
AppConfiguration.prototype['userInfoEndpoint'] = undefined;

/**
 * @member {String} clientInfoEndpoint
 */
AppConfiguration.prototype['clientInfoEndpoint'] = undefined;

/**
 * @member {String} checkSessionIFrame
 */
AppConfiguration.prototype['checkSessionIFrame'] = undefined;

/**
 * @member {String} endSessionEndpoint
 */
AppConfiguration.prototype['endSessionEndpoint'] = undefined;

/**
 * @member {String} jwksUri
 */
AppConfiguration.prototype['jwksUri'] = undefined;

/**
 * @member {String} archivedJwksUri
 */
AppConfiguration.prototype['archivedJwksUri'] = undefined;

/**
 * @member {String} registrationEndpoint
 */
AppConfiguration.prototype['registrationEndpoint'] = undefined;

/**
 * @member {String} openIdDiscoveryEndpoint
 */
AppConfiguration.prototype['openIdDiscoveryEndpoint'] = undefined;

/**
 * @member {String} openIdConfigurationEndpoint
 */
AppConfiguration.prototype['openIdConfigurationEndpoint'] = undefined;

/**
 * @member {String} idGenerationEndpoint
 */
AppConfiguration.prototype['idGenerationEndpoint'] = undefined;

/**
 * @member {String} introspectionEndpoint
 */
AppConfiguration.prototype['introspectionEndpoint'] = undefined;

/**
 * @member {String} parEndpoint
 */
AppConfiguration.prototype['parEndpoint'] = undefined;

/**
 * @member {Boolean} requirePar
 */
AppConfiguration.prototype['requirePar'] = undefined;

/**
 * @member {String} deviceAuthzEndpoint
 */
AppConfiguration.prototype['deviceAuthzEndpoint'] = undefined;

/**
 * @member {String} mtlsAuthorizationEndpoint
 */
AppConfiguration.prototype['mtlsAuthorizationEndpoint'] = undefined;

/**
 * @member {String} mtlsAuthorizationChallengeEndpoint
 */
AppConfiguration.prototype['mtlsAuthorizationChallengeEndpoint'] = undefined;

/**
 * @member {String} mtlsTokenEndpoint
 */
AppConfiguration.prototype['mtlsTokenEndpoint'] = undefined;

/**
 * @member {String} mtlsTokenRevocationEndpoint
 */
AppConfiguration.prototype['mtlsTokenRevocationEndpoint'] = undefined;

/**
 * @member {String} mtlsUserInfoEndpoint
 */
AppConfiguration.prototype['mtlsUserInfoEndpoint'] = undefined;

/**
 * @member {String} mtlsClientInfoEndpoint
 */
AppConfiguration.prototype['mtlsClientInfoEndpoint'] = undefined;

/**
 * @member {String} mtlsCheckSessionIFrame
 */
AppConfiguration.prototype['mtlsCheckSessionIFrame'] = undefined;

/**
 * @member {String} mtlsEndSessionEndpoint
 */
AppConfiguration.prototype['mtlsEndSessionEndpoint'] = undefined;

/**
 * @member {String} mtlsJwksUri
 */
AppConfiguration.prototype['mtlsJwksUri'] = undefined;

/**
 * @member {String} mtlsRegistrationEndpoint
 */
AppConfiguration.prototype['mtlsRegistrationEndpoint'] = undefined;

/**
 * @member {String} mtlsIdGenerationEndpoint
 */
AppConfiguration.prototype['mtlsIdGenerationEndpoint'] = undefined;

/**
 * @member {String} mtlsIntrospectionEndpoint
 */
AppConfiguration.prototype['mtlsIntrospectionEndpoint'] = undefined;

/**
 * @member {String} mtlsParEndpoint
 */
AppConfiguration.prototype['mtlsParEndpoint'] = undefined;

/**
 * @member {String} mtlsDeviceAuthzEndpoint
 */
AppConfiguration.prototype['mtlsDeviceAuthzEndpoint'] = undefined;

/**
 * @member {Boolean} accessEvaluationAllowBasicClientAuthorization
 */
AppConfiguration.prototype['accessEvaluationAllowBasicClientAuthorization'] = undefined;

/**
 * @member {String} accessEvaluationScriptName
 */
AppConfiguration.prototype['accessEvaluationScriptName'] = undefined;

/**
 * @member {Number} accessEvaluationDiscoveryCacheLifetimeInMinutes
 */
AppConfiguration.prototype['accessEvaluationDiscoveryCacheLifetimeInMinutes'] = undefined;

/**
 * @member {Boolean} requireRequestObjectEncryption
 */
AppConfiguration.prototype['requireRequestObjectEncryption'] = undefined;

/**
 * @member {Boolean} requirePkce
 */
AppConfiguration.prototype['requirePkce'] = undefined;

/**
 * @member {Boolean} allowAllValueForRevokeEndpoint
 */
AppConfiguration.prototype['allowAllValueForRevokeEndpoint'] = undefined;

/**
 * @member {Boolean} allowRevokeForOtherClients
 */
AppConfiguration.prototype['allowRevokeForOtherClients'] = undefined;

/**
 * @member {Number} sectorIdentifierCacheLifetimeInMinutes
 */
AppConfiguration.prototype['sectorIdentifierCacheLifetimeInMinutes'] = undefined;

/**
 * @member {Number} archivedJwkLifetimeInSeconds
 */
AppConfiguration.prototype['archivedJwkLifetimeInSeconds'] = undefined;

/**
 * @member {String} umaConfigurationEndpoint
 */
AppConfiguration.prototype['umaConfigurationEndpoint'] = undefined;

/**
 * @member {Boolean} umaRptAsJwt
 */
AppConfiguration.prototype['umaRptAsJwt'] = undefined;

/**
 * @member {Number} umaRptLifetime
 */
AppConfiguration.prototype['umaRptLifetime'] = undefined;

/**
 * @member {Number} umaTicketLifetime
 */
AppConfiguration.prototype['umaTicketLifetime'] = undefined;

/**
 * @member {Number} umaPctLifetime
 */
AppConfiguration.prototype['umaPctLifetime'] = undefined;

/**
 * @member {Number} umaResourceLifetime
 */
AppConfiguration.prototype['umaResourceLifetime'] = undefined;

/**
 * @member {Boolean} umaAddScopesAutomatically
 */
AppConfiguration.prototype['umaAddScopesAutomatically'] = undefined;

/**
 * @member {Boolean} umaValidateClaimToken
 */
AppConfiguration.prototype['umaValidateClaimToken'] = undefined;

/**
 * @member {Boolean} umaGrantAccessIfNoPolicies
 */
AppConfiguration.prototype['umaGrantAccessIfNoPolicies'] = undefined;

/**
 * @member {Boolean} umaRestrictResourceToAssociatedClient
 */
AppConfiguration.prototype['umaRestrictResourceToAssociatedClient'] = undefined;

/**
 * @member {Number} statTimerIntervalInSeconds
 */
AppConfiguration.prototype['statTimerIntervalInSeconds'] = undefined;

/**
 * @member {String} statAuthorizationScope
 */
AppConfiguration.prototype['statAuthorizationScope'] = undefined;

/**
 * @member {Boolean} allowSpontaneousScopes
 */
AppConfiguration.prototype['allowSpontaneousScopes'] = undefined;

/**
 * @member {Number} spontaneousScopeLifetime
 */
AppConfiguration.prototype['spontaneousScopeLifetime'] = undefined;

/**
 * @member {Number} statusListBitSize
 */
AppConfiguration.prototype['statusListBitSize'] = undefined;

/**
 * @member {String} statusListResponseJwtSignatureAlgorithm
 */
AppConfiguration.prototype['statusListResponseJwtSignatureAlgorithm'] = undefined;

/**
 * @member {Number} statusListResponseJwtLifetime
 */
AppConfiguration.prototype['statusListResponseJwtLifetime'] = undefined;

/**
 * @member {Number} statusListIndexAllocationBlockSize
 */
AppConfiguration.prototype['statusListIndexAllocationBlockSize'] = undefined;

/**
 * @member {String} openidSubAttribute
 */
AppConfiguration.prototype['openidSubAttribute'] = undefined;

/**
 * @member {Boolean} publicSubjectIdentifierPerClientEnabled
 */
AppConfiguration.prototype['publicSubjectIdentifierPerClientEnabled'] = undefined;

/**
 * @member {Array.<String>} subjectIdentifiersPerClientSupported
 */
AppConfiguration.prototype['subjectIdentifiersPerClientSupported'] = undefined;

/**
 * @member {Array.<String>} applyXFrameOptionsHeaderIfUriContainsAny
 */
AppConfiguration.prototype['applyXFrameOptionsHeaderIfUriContainsAny'] = undefined;

/**
 * @member {module:model/AppConfiguration.XframeOptionsHeaderValueEnum} xframeOptionsHeaderValue
 */
AppConfiguration.prototype['xframeOptionsHeaderValue'] = undefined;

/**
 * @member {Array.<Array.<module:model/AppConfiguration.ResponseTypesSupportedEnum>>} responseTypesSupported
 */
AppConfiguration.prototype['responseTypesSupported'] = undefined;

/**
 * @member {Array.<module:model/AppConfiguration.ResponseModesSupportedEnum>} responseModesSupported
 */
AppConfiguration.prototype['responseModesSupported'] = undefined;

/**
 * @member {Array.<module:model/AppConfiguration.GrantTypesSupportedEnum>} grantTypesSupported
 */
AppConfiguration.prototype['grantTypesSupported'] = undefined;

/**
 * @member {Array.<String>} subjectTypesSupported
 */
AppConfiguration.prototype['subjectTypesSupported'] = undefined;

/**
 * @member {String} defaultSubjectType
 */
AppConfiguration.prototype['defaultSubjectType'] = undefined;

/**
 * @member {Array.<String>} authorizationSigningAlgValuesSupported
 */
AppConfiguration.prototype['authorizationSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} authorizationEncryptionAlgValuesSupported
 */
AppConfiguration.prototype['authorizationEncryptionAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} authorizationEncryptionEncValuesSupported
 */
AppConfiguration.prototype['authorizationEncryptionEncValuesSupported'] = undefined;

/**
 * @member {Array.<String>} userInfoSigningAlgValuesSupported
 */
AppConfiguration.prototype['userInfoSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} userInfoEncryptionAlgValuesSupported
 */
AppConfiguration.prototype['userInfoEncryptionAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} userInfoEncryptionEncValuesSupported
 */
AppConfiguration.prototype['userInfoEncryptionEncValuesSupported'] = undefined;

/**
 * @member {Array.<String>} introspectionSigningAlgValuesSupported
 */
AppConfiguration.prototype['introspectionSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} introspectionEncryptionAlgValuesSupported
 */
AppConfiguration.prototype['introspectionEncryptionAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} introspectionEncryptionEncValuesSupported
 */
AppConfiguration.prototype['introspectionEncryptionEncValuesSupported'] = undefined;

/**
 * @member {Array.<String>} txTokenSigningAlgValuesSupported
 */
AppConfiguration.prototype['txTokenSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} txTokenEncryptionAlgValuesSupported
 */
AppConfiguration.prototype['txTokenEncryptionAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} txTokenEncryptionEncValuesSupported
 */
AppConfiguration.prototype['txTokenEncryptionEncValuesSupported'] = undefined;

/**
 * @member {Array.<String>} idTokenSigningAlgValuesSupported
 */
AppConfiguration.prototype['idTokenSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} idTokenEncryptionAlgValuesSupported
 */
AppConfiguration.prototype['idTokenEncryptionAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} idTokenEncryptionEncValuesSupported
 */
AppConfiguration.prototype['idTokenEncryptionEncValuesSupported'] = undefined;

/**
 * @member {Array.<String>} accessTokenSigningAlgValuesSupported
 */
AppConfiguration.prototype['accessTokenSigningAlgValuesSupported'] = undefined;

/**
 * @member {Boolean} forceSignedRequestObject
 */
AppConfiguration.prototype['forceSignedRequestObject'] = undefined;

/**
 * @member {Array.<String>} requestObjectSigningAlgValuesSupported
 */
AppConfiguration.prototype['requestObjectSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} requestObjectEncryptionAlgValuesSupported
 */
AppConfiguration.prototype['requestObjectEncryptionAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} requestObjectEncryptionEncValuesSupported
 */
AppConfiguration.prototype['requestObjectEncryptionEncValuesSupported'] = undefined;

/**
 * @member {Array.<String>} tokenEndpointAuthMethodsSupported
 */
AppConfiguration.prototype['tokenEndpointAuthMethodsSupported'] = undefined;

/**
 * @member {Array.<String>} tokenEndpointAuthSigningAlgValuesSupported
 */
AppConfiguration.prototype['tokenEndpointAuthSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} dynamicRegistrationCustomAttributes
 */
AppConfiguration.prototype['dynamicRegistrationCustomAttributes'] = undefined;

/**
 * @member {Object} dynamicRegistrationDefaultCustomAttributes
 */
AppConfiguration.prototype['dynamicRegistrationDefaultCustomAttributes'] = undefined;

/**
 * @member {Array.<String>} displayValuesSupported
 */
AppConfiguration.prototype['displayValuesSupported'] = undefined;

/**
 * @member {Array.<String>} claimTypesSupported
 */
AppConfiguration.prototype['claimTypesSupported'] = undefined;

/**
 * @member {Array.<String>} jwksAlgorithmsSupported
 */
AppConfiguration.prototype['jwksAlgorithmsSupported'] = undefined;

/**
 * @member {String} serviceDocumentation
 */
AppConfiguration.prototype['serviceDocumentation'] = undefined;

/**
 * @member {Array.<String>} claimsLocalesSupported
 */
AppConfiguration.prototype['claimsLocalesSupported'] = undefined;

/**
 * @member {Array.<String>} idTokenTokenBindingCnfValuesSupported
 */
AppConfiguration.prototype['idTokenTokenBindingCnfValuesSupported'] = undefined;

/**
 * @member {Array.<String>} uiLocalesSupported
 */
AppConfiguration.prototype['uiLocalesSupported'] = undefined;

/**
 * @member {Boolean} claimsParameterSupported
 */
AppConfiguration.prototype['claimsParameterSupported'] = undefined;

/**
 * @member {Boolean} requestParameterSupported
 */
AppConfiguration.prototype['requestParameterSupported'] = undefined;

/**
 * @member {Boolean} requestUriParameterSupported
 */
AppConfiguration.prototype['requestUriParameterSupported'] = undefined;

/**
 * @member {Boolean} requestUriHashVerificationEnabled
 */
AppConfiguration.prototype['requestUriHashVerificationEnabled'] = undefined;

/**
 * @member {Boolean} requireRequestUriRegistration
 */
AppConfiguration.prototype['requireRequestUriRegistration'] = undefined;

/**
 * @member {Array.<String>} requestUriBlockList
 */
AppConfiguration.prototype['requestUriBlockList'] = undefined;

/**
 * @member {String} opPolicyUri
 */
AppConfiguration.prototype['opPolicyUri'] = undefined;

/**
 * @member {String} opTosUri
 */
AppConfiguration.prototype['opTosUri'] = undefined;

/**
 * @member {Number} cleanUpInactiveClientAfterHoursOfInactivity
 */
AppConfiguration.prototype['cleanUpInactiveClientAfterHoursOfInactivity'] = undefined;

/**
 * @member {Number} clientPeriodicUpdateTimerInterval
 */
AppConfiguration.prototype['clientPeriodicUpdateTimerInterval'] = undefined;

/**
 * @member {Number} authorizationCodeLifetime
 */
AppConfiguration.prototype['authorizationCodeLifetime'] = undefined;

/**
 * @member {Number} refreshTokenLifetime
 */
AppConfiguration.prototype['refreshTokenLifetime'] = undefined;

/**
 * @member {Number} txTokenLifetime
 */
AppConfiguration.prototype['txTokenLifetime'] = undefined;

/**
 * @member {Number} idTokenLifetime
 */
AppConfiguration.prototype['idTokenLifetime'] = undefined;

/**
 * @member {Boolean} idTokenFilterClaimsBasedOnAccessToken
 */
AppConfiguration.prototype['idTokenFilterClaimsBasedOnAccessToken'] = undefined;

/**
 * @member {Boolean} saveTokensInCache
 */
AppConfiguration.prototype['saveTokensInCache'] = undefined;

/**
 * @member {Boolean} saveTokensInCacheAndDontSaveInPersistence
 */
AppConfiguration.prototype['saveTokensInCacheAndDontSaveInPersistence'] = undefined;

/**
 * @member {Number} accessTokenLifetime
 */
AppConfiguration.prototype['accessTokenLifetime'] = undefined;

/**
 * @member {Number} userInfoLifetime
 */
AppConfiguration.prototype['userInfoLifetime'] = undefined;

/**
 * @member {Number} cleanServiceInterval
 */
AppConfiguration.prototype['cleanServiceInterval'] = undefined;

/**
 * @member {Number} cleanServiceBatchChunkSize
 */
AppConfiguration.prototype['cleanServiceBatchChunkSize'] = undefined;

/**
 * @member {Boolean} keyRegenerationEnabled
 */
AppConfiguration.prototype['keyRegenerationEnabled'] = undefined;

/**
 * @member {Number} keyRegenerationInterval
 */
AppConfiguration.prototype['keyRegenerationInterval'] = undefined;

/**
 * @member {String} defaultSignatureAlgorithm
 */
AppConfiguration.prototype['defaultSignatureAlgorithm'] = undefined;

/**
 * @member {String} jansOpenIdConnectVersion
 */
AppConfiguration.prototype['jansOpenIdConnectVersion'] = undefined;

/**
 * @member {String} jansId
 */
AppConfiguration.prototype['jansId'] = undefined;

/**
 * @member {Number} dynamicRegistrationExpirationTime
 */
AppConfiguration.prototype['dynamicRegistrationExpirationTime'] = undefined;

/**
 * @member {Boolean} dynamicRegistrationPersistClientAuthorizations
 */
AppConfiguration.prototype['dynamicRegistrationPersistClientAuthorizations'] = undefined;

/**
 * @member {Boolean} trustedClientEnabled
 */
AppConfiguration.prototype['trustedClientEnabled'] = undefined;

/**
 * @member {Boolean} skipAuthorizationForOpenIdScopeAndPairwiseId
 */
AppConfiguration.prototype['skipAuthorizationForOpenIdScopeAndPairwiseId'] = undefined;

/**
 * @member {Boolean} dynamicRegistrationScopesParamEnabled
 */
AppConfiguration.prototype['dynamicRegistrationScopesParamEnabled'] = undefined;

/**
 * @member {Boolean} dynamicRegistrationPasswordGrantTypeEnabled
 */
AppConfiguration.prototype['dynamicRegistrationPasswordGrantTypeEnabled'] = undefined;

/**
 * @member {Array.<String>} dynamicRegistrationAllowedPasswordGrantScopes
 */
AppConfiguration.prototype['dynamicRegistrationAllowedPasswordGrantScopes'] = undefined;

/**
 * @member {String} dynamicRegistrationCustomObjectClass
 */
AppConfiguration.prototype['dynamicRegistrationCustomObjectClass'] = undefined;

/**
 * @member {Array.<String>} personCustomObjectClassList
 */
AppConfiguration.prototype['personCustomObjectClassList'] = undefined;

/**
 * @member {Boolean} persistIdToken
 */
AppConfiguration.prototype['persistIdToken'] = undefined;

/**
 * @member {Boolean} persistRefreshToken
 */
AppConfiguration.prototype['persistRefreshToken'] = undefined;

/**
 * @member {Boolean} allowPostLogoutRedirectWithoutValidation
 */
AppConfiguration.prototype['allowPostLogoutRedirectWithoutValidation'] = undefined;

/**
 * @member {Boolean} invalidateSessionCookiesAfterAuthorizationFlow
 */
AppConfiguration.prototype['invalidateSessionCookiesAfterAuthorizationFlow'] = undefined;

/**
 * @member {Boolean} returnClientSecretOnRead
 */
AppConfiguration.prototype['returnClientSecretOnRead'] = undefined;

/**
 * @member {Boolean} rotateClientRegistrationAccessTokenOnUsage
 */
AppConfiguration.prototype['rotateClientRegistrationAccessTokenOnUsage'] = undefined;

/**
 * @member {Boolean} rejectJwtWithNoneAlg
 */
AppConfiguration.prototype['rejectJwtWithNoneAlg'] = undefined;

/**
 * @member {Boolean} expirationNotificatorEnabled
 */
AppConfiguration.prototype['expirationNotificatorEnabled'] = undefined;

/**
 * @member {Boolean} useNestedJwtDuringEncryption
 */
AppConfiguration.prototype['useNestedJwtDuringEncryption'] = undefined;

/**
 * @member {Number} expirationNotificatorMapSizeLimit
 */
AppConfiguration.prototype['expirationNotificatorMapSizeLimit'] = undefined;

/**
 * @member {Number} expirationNotificatorIntervalInSeconds
 */
AppConfiguration.prototype['expirationNotificatorIntervalInSeconds'] = undefined;

/**
 * @member {Boolean} redirectUrisRegexEnabled
 */
AppConfiguration.prototype['redirectUrisRegexEnabled'] = undefined;

/**
 * @member {Boolean} useHighestLevelScriptIfAcrScriptNotFound
 */
AppConfiguration.prototype['useHighestLevelScriptIfAcrScriptNotFound'] = undefined;

/**
 * @member {Object.<String, String>} acrMappings
 */
AppConfiguration.prototype['acrMappings'] = undefined;

/**
 * @member {Boolean} authenticationFiltersEnabled
 */
AppConfiguration.prototype['authenticationFiltersEnabled'] = undefined;

/**
 * @member {Boolean} clientAuthenticationFiltersEnabled
 */
AppConfiguration.prototype['clientAuthenticationFiltersEnabled'] = undefined;

/**
 * @member {Boolean} clientRegDefaultToCodeFlowWithRefresh
 */
AppConfiguration.prototype['clientRegDefaultToCodeFlowWithRefresh'] = undefined;

/**
 * @member {Boolean} grantTypesAndResponseTypesAutofixEnabled
 */
AppConfiguration.prototype['grantTypesAndResponseTypesAutofixEnabled'] = undefined;

/**
 * @member {Array.<module:model/AuthenticationFilter>} authenticationFilters
 */
AppConfiguration.prototype['authenticationFilters'] = undefined;

/**
 * @member {Array.<module:model/ClientAuthenticationFilter>} clientAuthenticationFilters
 */
AppConfiguration.prototype['clientAuthenticationFilters'] = undefined;

/**
 * @member {Array.<module:model/CorsConfigurationFilter>} corsConfigurationFilters
 */
AppConfiguration.prototype['corsConfigurationFilters'] = undefined;

/**
 * @member {Number} sessionIdUnusedLifetime
 */
AppConfiguration.prototype['sessionIdUnusedLifetime'] = undefined;

/**
 * @member {Number} sessionIdUnauthenticatedUnusedLifetime
 */
AppConfiguration.prototype['sessionIdUnauthenticatedUnusedLifetime'] = undefined;

/**
 * @member {Boolean} sessionIdPersistOnPromptNone
 */
AppConfiguration.prototype['sessionIdPersistOnPromptNone'] = undefined;

/**
 * @member {Boolean} sessionIdRequestParameterEnabled
 */
AppConfiguration.prototype['sessionIdRequestParameterEnabled'] = undefined;

/**
 * @member {Boolean} changeSessionIdOnAuthentication
 */
AppConfiguration.prototype['changeSessionIdOnAuthentication'] = undefined;

/**
 * @member {Boolean} sessionIdPersistInCache
 */
AppConfiguration.prototype['sessionIdPersistInCache'] = undefined;

/**
 * @member {Boolean} includeSidInResponse
 */
AppConfiguration.prototype['includeSidInResponse'] = undefined;

/**
 * @member {Boolean} disablePromptLogin
 */
AppConfiguration.prototype['disablePromptLogin'] = undefined;

/**
 * @member {Boolean} disablePromptConsent
 */
AppConfiguration.prototype['disablePromptConsent'] = undefined;

/**
 * @member {Number} sessionIdCookieLifetime
 */
AppConfiguration.prototype['sessionIdCookieLifetime'] = undefined;

/**
 * @member {Number} sessionIdLifetime
 */
AppConfiguration.prototype['sessionIdLifetime'] = undefined;

/**
 * @member {String} activeSessionAuthorizationScope
 */
AppConfiguration.prototype['activeSessionAuthorizationScope'] = undefined;

/**
 * @member {Number} configurationUpdateInterval
 */
AppConfiguration.prototype['configurationUpdateInterval'] = undefined;

/**
 * @member {Boolean} logNotFoundEntityAsError
 */
AppConfiguration.prototype['logNotFoundEntityAsError'] = undefined;

/**
 * @member {Boolean} enableClientGrantTypeUpdate
 */
AppConfiguration.prototype['enableClientGrantTypeUpdate'] = undefined;

/**
 * @member {Array.<module:model/AppConfiguration.GrantTypesSupportedByDynamicRegistrationEnum>} grantTypesSupportedByDynamicRegistration
 */
AppConfiguration.prototype['grantTypesSupportedByDynamicRegistration'] = undefined;

/**
 * @member {String} cssLocation
 */
AppConfiguration.prototype['cssLocation'] = undefined;

/**
 * @member {String} jsLocation
 */
AppConfiguration.prototype['jsLocation'] = undefined;

/**
 * @member {String} imgLocation
 */
AppConfiguration.prototype['imgLocation'] = undefined;

/**
 * @member {Number} metricReporterInterval
 */
AppConfiguration.prototype['metricReporterInterval'] = undefined;

/**
 * @member {Number} metricReporterKeepDataDays
 */
AppConfiguration.prototype['metricReporterKeepDataDays'] = undefined;

/**
 * @member {String} pairwiseIdType
 */
AppConfiguration.prototype['pairwiseIdType'] = undefined;

/**
 * @member {String} pairwiseCalculationKey
 */
AppConfiguration.prototype['pairwiseCalculationKey'] = undefined;

/**
 * @member {String} pairwiseCalculationSalt
 */
AppConfiguration.prototype['pairwiseCalculationSalt'] = undefined;

/**
 * @member {Boolean} shareSubjectIdBetweenClientsWithSameSectorId
 */
AppConfiguration.prototype['shareSubjectIdBetweenClientsWithSameSectorId'] = undefined;

/**
 * @member {Boolean} useOpenidSubAttributeValueForPairwiseLocalAccountId
 */
AppConfiguration.prototype['useOpenidSubAttributeValueForPairwiseLocalAccountId'] = undefined;

/**
 * @member {module:model/AppConfiguration.WebKeysStorageEnum} webKeysStorage
 */
AppConfiguration.prototype['webKeysStorage'] = undefined;

/**
 * @member {String} dnName
 */
AppConfiguration.prototype['dnName'] = undefined;

/**
 * @member {String} keyStoreFile
 */
AppConfiguration.prototype['keyStoreFile'] = undefined;

/**
 * @member {String} keyStoreSecret
 */
AppConfiguration.prototype['keyStoreSecret'] = undefined;

/**
 * @member {module:model/AppConfiguration.KeySelectionStrategyEnum} keySelectionStrategy
 */
AppConfiguration.prototype['keySelectionStrategy'] = undefined;

/**
 * @member {Array.<String>} keyAlgsAllowedForGeneration
 */
AppConfiguration.prototype['keyAlgsAllowedForGeneration'] = undefined;

/**
 * @member {Boolean} keySignWithSameKeyButDiffAlg
 */
AppConfiguration.prototype['keySignWithSameKeyButDiffAlg'] = undefined;

/**
 * @member {String} staticKid
 */
AppConfiguration.prototype['staticKid'] = undefined;

/**
 * @member {String} staticDecryptionKid
 */
AppConfiguration.prototype['staticDecryptionKid'] = undefined;

/**
 * @member {Boolean} introspectionAccessTokenMustHaveUmaProtectionScope
 */
AppConfiguration.prototype['introspectionAccessTokenMustHaveUmaProtectionScope'] = undefined;

/**
 * @member {Boolean} introspectionAccessTokenMustHaveIntrospectionScope
 */
AppConfiguration.prototype['introspectionAccessTokenMustHaveIntrospectionScope'] = undefined;

/**
 * @member {Boolean} introspectionSkipAuthorization
 */
AppConfiguration.prototype['introspectionSkipAuthorization'] = undefined;

/**
 * @member {Boolean} introspectionRestrictBasicAuthnToOwnTokens
 */
AppConfiguration.prototype['introspectionRestrictBasicAuthnToOwnTokens'] = undefined;

/**
 * @member {Boolean} endSessionWithAccessToken
 */
AppConfiguration.prototype['endSessionWithAccessToken'] = undefined;

/**
 * @member {Boolean} disablePromptCreate
 */
AppConfiguration.prototype['disablePromptCreate'] = undefined;

/**
 * @member {String} cookieDomain
 */
AppConfiguration.prototype['cookieDomain'] = undefined;

/**
 * @member {Boolean} enabledOAuthAuditLogging
 */
AppConfiguration.prototype['enabledOAuthAuditLogging'] = undefined;

/**
 * @member {Array.<String>} jmsBrokerURISet
 */
AppConfiguration.prototype['jmsBrokerURISet'] = undefined;

/**
 * @member {String} jmsUserName
 */
AppConfiguration.prototype['jmsUserName'] = undefined;

/**
 * @member {String} jmsPassword
 */
AppConfiguration.prototype['jmsPassword'] = undefined;

/**
 * @member {Array.<String>} externalUriWhiteList
 */
AppConfiguration.prototype['externalUriWhiteList'] = undefined;

/**
 * @member {Array.<String>} clientWhiteList
 */
AppConfiguration.prototype['clientWhiteList'] = undefined;

/**
 * @member {Array.<String>} clientBlackList
 */
AppConfiguration.prototype['clientBlackList'] = undefined;

/**
 * @member {Boolean} legacyIdTokenClaims
 */
AppConfiguration.prototype['legacyIdTokenClaims'] = undefined;

/**
 * @member {Boolean} customHeadersWithAuthorizationResponse
 */
AppConfiguration.prototype['customHeadersWithAuthorizationResponse'] = undefined;

/**
 * @member {Boolean} frontChannelLogoutSessionSupported
 */
AppConfiguration.prototype['frontChannelLogoutSessionSupported'] = undefined;

/**
 * @member {String} loggingLevel
 */
AppConfiguration.prototype['loggingLevel'] = undefined;

/**
 * @member {String} loggingLayout
 */
AppConfiguration.prototype['loggingLayout'] = undefined;

/**
 * @member {Boolean} updateUserLastLogonTime
 */
AppConfiguration.prototype['updateUserLastLogonTime'] = undefined;

/**
 * @member {Boolean} updateClientAccessTime
 */
AppConfiguration.prototype['updateClientAccessTime'] = undefined;

/**
 * @member {Boolean} logClientIdOnClientAuthentication
 */
AppConfiguration.prototype['logClientIdOnClientAuthentication'] = undefined;

/**
 * @member {Boolean} logClientNameOnClientAuthentication
 */
AppConfiguration.prototype['logClientNameOnClientAuthentication'] = undefined;

/**
 * @member {Boolean} disableJdkLogger
 */
AppConfiguration.prototype['disableJdkLogger'] = undefined;

/**
 * @member {Array.<module:model/AuthorizationRequestCustomParameter>} authorizationRequestCustomAllowedParameters
 */
AppConfiguration.prototype['authorizationRequestCustomAllowedParameters'] = undefined;

/**
 * @member {Boolean} openidScopeBackwardCompatibility
 */
AppConfiguration.prototype['openidScopeBackwardCompatibility'] = undefined;

/**
 * @member {Boolean} disableU2fEndpoint
 */
AppConfiguration.prototype['disableU2fEndpoint'] = undefined;

/**
 * @member {Number} authorizationChallengeSessionLifetimeInSeconds
 */
AppConfiguration.prototype['authorizationChallengeSessionLifetimeInSeconds'] = undefined;

/**
 * @member {Boolean} rotateDeviceSecret
 */
AppConfiguration.prototype['rotateDeviceSecret'] = undefined;

/**
 * @member {Boolean} returnDeviceSecretFromAuthzEndpoint
 */
AppConfiguration.prototype['returnDeviceSecretFromAuthzEndpoint'] = undefined;

/**
 * @member {Boolean} dcrForbidExpirationTimeInRequest
 */
AppConfiguration.prototype['dcrForbidExpirationTimeInRequest'] = undefined;

/**
 * @member {Boolean} dcrSignatureValidationEnabled
 */
AppConfiguration.prototype['dcrSignatureValidationEnabled'] = undefined;

/**
 * @member {String} dcrSignatureValidationSharedSecret
 */
AppConfiguration.prototype['dcrSignatureValidationSharedSecret'] = undefined;

/**
 * @member {String} dcrSignatureValidationSoftwareStatementJwksURIClaim
 */
AppConfiguration.prototype['dcrSignatureValidationSoftwareStatementJwksURIClaim'] = undefined;

/**
 * @member {String} dcrSignatureValidationSoftwareStatementJwksClaim
 */
AppConfiguration.prototype['dcrSignatureValidationSoftwareStatementJwksClaim'] = undefined;

/**
 * @member {String} dcrSignatureValidationJwks
 */
AppConfiguration.prototype['dcrSignatureValidationJwks'] = undefined;

/**
 * @member {String} dcrSignatureValidationJwksUri
 */
AppConfiguration.prototype['dcrSignatureValidationJwksUri'] = undefined;

/**
 * @member {Boolean} dcrAuthorizationWithClientCredentials
 */
AppConfiguration.prototype['dcrAuthorizationWithClientCredentials'] = undefined;

/**
 * @member {Boolean} dcrAuthorizationWithMTLS
 */
AppConfiguration.prototype['dcrAuthorizationWithMTLS'] = undefined;

/**
 * @member {Boolean} dcrAttestationEvidenceRequired
 */
AppConfiguration.prototype['dcrAttestationEvidenceRequired'] = undefined;

/**
 * @member {Object.<String, module:model/TrustedIssuerConfig>} trustedSsaIssuers
 */
AppConfiguration.prototype['trustedSsaIssuers'] = undefined;

/**
 * @member {Boolean} useLocalCache
 */
AppConfiguration.prototype['useLocalCache'] = undefined;

/**
 * @member {Boolean} fapiCompatibility
 */
AppConfiguration.prototype['fapiCompatibility'] = undefined;

/**
 * @member {Boolean} forceIdTokenHintPresence
 */
AppConfiguration.prototype['forceIdTokenHintPresence'] = undefined;

/**
 * @member {Boolean} rejectEndSessionIfIdTokenExpired
 */
AppConfiguration.prototype['rejectEndSessionIfIdTokenExpired'] = undefined;

/**
 * @member {Boolean} allowEndSessionWithUnmatchedSid
 */
AppConfiguration.prototype['allowEndSessionWithUnmatchedSid'] = undefined;

/**
 * @member {Boolean} forceOfflineAccessScopeToEnableRefreshToken
 */
AppConfiguration.prototype['forceOfflineAccessScopeToEnableRefreshToken'] = undefined;

/**
 * @member {Boolean} errorReasonEnabled
 */
AppConfiguration.prototype['errorReasonEnabled'] = undefined;

/**
 * @member {Boolean} removeRefreshTokensForClientOnLogout
 */
AppConfiguration.prototype['removeRefreshTokensForClientOnLogout'] = undefined;

/**
 * @member {Boolean} skipRefreshTokenDuringRefreshing
 */
AppConfiguration.prototype['skipRefreshTokenDuringRefreshing'] = undefined;

/**
 * @member {Boolean} refreshTokenExtendLifetimeOnRotation
 */
AppConfiguration.prototype['refreshTokenExtendLifetimeOnRotation'] = undefined;

/**
 * @member {Boolean} allowBlankValuesInDiscoveryResponse
 */
AppConfiguration.prototype['allowBlankValuesInDiscoveryResponse'] = undefined;

/**
 * @member {Boolean} checkUserPresenceOnRefreshToken
 */
AppConfiguration.prototype['checkUserPresenceOnRefreshToken'] = undefined;

/**
 * @member {Boolean} consentGatheringScriptBackwardCompatibility
 */
AppConfiguration.prototype['consentGatheringScriptBackwardCompatibility'] = undefined;

/**
 * @member {Boolean} introspectionScriptBackwardCompatibility
 */
AppConfiguration.prototype['introspectionScriptBackwardCompatibility'] = undefined;

/**
 * @member {Boolean} introspectionResponseScopesBackwardCompatibility
 */
AppConfiguration.prototype['introspectionResponseScopesBackwardCompatibility'] = undefined;

/**
 * @member {String} softwareStatementValidationType
 */
AppConfiguration.prototype['softwareStatementValidationType'] = undefined;

/**
 * @member {String} softwareStatementValidationClaimName
 */
AppConfiguration.prototype['softwareStatementValidationClaimName'] = undefined;

/**
 * @member {module:model/AuthenticationProtectionConfiguration} authenticationProtectionConfiguration
 */
AppConfiguration.prototype['authenticationProtectionConfiguration'] = undefined;

/**
 * @member {module:model/AppConfiguration.ErrorHandlingMethodEnum} errorHandlingMethod
 */
AppConfiguration.prototype['errorHandlingMethod'] = undefined;

/**
 * @member {Boolean} disableAuthnForMaxAgeZero
 */
AppConfiguration.prototype['disableAuthnForMaxAgeZero'] = undefined;

/**
 * @member {Boolean} keepAuthenticatorAttributesOnAcrChange
 */
AppConfiguration.prototype['keepAuthenticatorAttributesOnAcrChange'] = undefined;

/**
 * @member {Number} deviceAuthzRequestExpiresIn
 */
AppConfiguration.prototype['deviceAuthzRequestExpiresIn'] = undefined;

/**
 * @member {Number} deviceAuthzTokenPollInterval
 */
AppConfiguration.prototype['deviceAuthzTokenPollInterval'] = undefined;

/**
 * @member {String} deviceAuthzResponseTypeToProcessAuthz
 */
AppConfiguration.prototype['deviceAuthzResponseTypeToProcessAuthz'] = undefined;

/**
 * @member {String} deviceAuthzAcr
 */
AppConfiguration.prototype['deviceAuthzAcr'] = undefined;

/**
 * @member {String} backchannelClientId
 */
AppConfiguration.prototype['backchannelClientId'] = undefined;

/**
 * @member {String} backchannelRedirectUri
 */
AppConfiguration.prototype['backchannelRedirectUri'] = undefined;

/**
 * @member {String} backchannelAuthenticationEndpoint
 */
AppConfiguration.prototype['backchannelAuthenticationEndpoint'] = undefined;

/**
 * @member {String} backchannelDeviceRegistrationEndpoint
 */
AppConfiguration.prototype['backchannelDeviceRegistrationEndpoint'] = undefined;

/**
 * @member {Array.<String>} backchannelTokenDeliveryModesSupported
 */
AppConfiguration.prototype['backchannelTokenDeliveryModesSupported'] = undefined;

/**
 * @member {Array.<String>} backchannelAuthenticationRequestSigningAlgValuesSupported
 */
AppConfiguration.prototype['backchannelAuthenticationRequestSigningAlgValuesSupported'] = undefined;

/**
 * @member {Boolean} backchannelUserCodeParameterSupported
 */
AppConfiguration.prototype['backchannelUserCodeParameterSupported'] = undefined;

/**
 * @member {String} backchannelBindingMessagePattern
 */
AppConfiguration.prototype['backchannelBindingMessagePattern'] = undefined;

/**
 * @member {Number} backchannelAuthenticationResponseExpiresIn
 */
AppConfiguration.prototype['backchannelAuthenticationResponseExpiresIn'] = undefined;

/**
 * @member {Number} backchannelAuthenticationResponseInterval
 */
AppConfiguration.prototype['backchannelAuthenticationResponseInterval'] = undefined;

/**
 * @member {Array.<String>} backchannelLoginHintClaims
 */
AppConfiguration.prototype['backchannelLoginHintClaims'] = undefined;

/**
 * @member {module:model/CIBAEndUserNotificationConfig} cibaEndUserNotificationConfig
 */
AppConfiguration.prototype['cibaEndUserNotificationConfig'] = undefined;

/**
 * @member {Number} backchannelRequestsProcessorJobIntervalSec
 */
AppConfiguration.prototype['backchannelRequestsProcessorJobIntervalSec'] = undefined;

/**
 * @member {Number} backchannelRequestsProcessorJobChunkSize
 */
AppConfiguration.prototype['backchannelRequestsProcessorJobChunkSize'] = undefined;

/**
 * @member {Number} cibaGrantLifeExtraTimeSec
 */
AppConfiguration.prototype['cibaGrantLifeExtraTimeSec'] = undefined;

/**
 * @member {Number} cibaMaxExpirationTimeAllowedSec
 */
AppConfiguration.prototype['cibaMaxExpirationTimeAllowedSec'] = undefined;

/**
 * @member {Array.<String>} dpopSigningAlgValuesSupported
 */
AppConfiguration.prototype['dpopSigningAlgValuesSupported'] = undefined;

/**
 * @member {Number} dpopTimeframe
 */
AppConfiguration.prototype['dpopTimeframe'] = undefined;

/**
 * @member {Number} dpopJtiCacheTime
 */
AppConfiguration.prototype['dpopJtiCacheTime'] = undefined;

/**
 * @member {Boolean} dpopUseNonce
 */
AppConfiguration.prototype['dpopUseNonce'] = undefined;

/**
 * @member {Number} dpopNonceCacheTime
 */
AppConfiguration.prototype['dpopNonceCacheTime'] = undefined;

/**
 * @member {Boolean} dpopJktForceForAuthorizationCode
 */
AppConfiguration.prototype['dpopJktForceForAuthorizationCode'] = undefined;

/**
 * @member {Boolean} allowIdTokenWithoutImplicitGrantType
 */
AppConfiguration.prototype['allowIdTokenWithoutImplicitGrantType'] = undefined;

/**
 * @member {Boolean} forceRopcInAuthorizationEndpoint
 */
AppConfiguration.prototype['forceRopcInAuthorizationEndpoint'] = undefined;

/**
 * @member {Number} discoveryCacheLifetimeInMinutes
 */
AppConfiguration.prototype['discoveryCacheLifetimeInMinutes'] = undefined;

/**
 * @member {Array.<String>} discoveryAllowedKeys
 */
AppConfiguration.prototype['discoveryAllowedKeys'] = undefined;

/**
 * @member {Array.<String>} discoveryDenyKeys
 */
AppConfiguration.prototype['discoveryDenyKeys'] = undefined;

/**
 * @member {Array.<module:model/AppConfiguration.FeatureFlagsEnum>} featureFlags
 */
AppConfiguration.prototype['featureFlags'] = undefined;

/**
 * @member {Boolean} httpLoggingEnabled
 */
AppConfiguration.prototype['httpLoggingEnabled'] = undefined;

/**
 * @member {Array.<String>} httpLoggingExcludePaths
 */
AppConfiguration.prototype['httpLoggingExcludePaths'] = undefined;

/**
 * @member {String} externalLoggerConfiguration
 */
AppConfiguration.prototype['externalLoggerConfiguration'] = undefined;

/**
 * @member {module:model/EngineConfig} agamaConfiguration
 */
AppConfiguration.prototype['agamaConfiguration'] = undefined;

/**
 * @member {Array.<module:model/SsaValidationConfig>} dcrSsaValidationConfigs
 */
AppConfiguration.prototype['dcrSsaValidationConfigs'] = undefined;

/**
 * @member {module:model/SsaConfiguration} ssaConfiguration
 */
AppConfiguration.prototype['ssaConfiguration'] = undefined;

/**
 * @member {Boolean} blockWebviewAuthorizationEnabled
 */
AppConfiguration.prototype['blockWebviewAuthorizationEnabled'] = undefined;

/**
 * @member {String} authorizationChallengeDefaultAcr
 */
AppConfiguration.prototype['authorizationChallengeDefaultAcr'] = undefined;

/**
 * @member {Boolean} authorizationChallengeShouldGenerateSession
 */
AppConfiguration.prototype['authorizationChallengeShouldGenerateSession'] = undefined;

/**
 * @member {Object.<String, String>} dateFormatterPatterns
 */
AppConfiguration.prototype['dateFormatterPatterns'] = undefined;

/**
 * @member {Boolean} httpLoggingResponseBodyContent
 */
AppConfiguration.prototype['httpLoggingResponseBodyContent'] = undefined;

/**
 * @member {Boolean} skipAuthenticationFilterOptionsMethod
 */
AppConfiguration.prototype['skipAuthenticationFilterOptionsMethod'] = undefined;

/**
 * @member {module:model/LockMessageConfig} lockMessageConfig
 */
AppConfiguration.prototype['lockMessageConfig'] = undefined;

/**
 * @member {Array.<module:model/AppConfiguration.AllResponseTypesSupportedEnum>} allResponseTypesSupported
 */
AppConfiguration.prototype['allResponseTypesSupported'] = undefined;

/**
 * @member {Boolean} fapi
 */
AppConfiguration.prototype['fapi'] = undefined;

/**
 * Allowed values for the <code>xframeOptionsHeaderValue</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['XframeOptionsHeaderValueEnum'] = {
  /**
   * value: "SAMEORIGIN"
   * @const
   */
  "SAMEORIGIN": "SAMEORIGIN",
  /**
   * value: "DENY"
   * @const
   */
  "DENY": "DENY"
};

/**
 * Allowed values for the <code>responseModesSupported</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['ResponseModesSupportedEnum'] = {
  /**
   * value: "query"
   * @const
   */
  "query": "query",
  /**
   * value: "fragment"
   * @const
   */
  "fragment": "fragment",
  /**
   * value: "form_post"
   * @const
   */
  "form_post": "form_post",
  /**
   * value: "query.jwt"
   * @const
   */
  "query.jwt": "query.jwt",
  /**
   * value: "fragment.jwt"
   * @const
   */
  "fragment.jwt": "fragment.jwt",
  /**
   * value: "form_post.jwt"
   * @const
   */
  "form_post.jwt": "form_post.jwt",
  /**
   * value: "jwt"
   * @const
   */
  "jwt": "jwt"
};

/**
 * Allowed values for the <code>grantTypesSupported</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['GrantTypesSupportedEnum'] = {
  /**
   * value: "none"
   * @const
   */
  "none": "none",
  /**
   * value: "authorization_code"
   * @const
   */
  "authorization_code": "authorization_code",
  /**
   * value: "implicit"
   * @const
   */
  "implicit": "implicit",
  /**
   * value: "password"
   * @const
   */
  "password": "password",
  /**
   * value: "client_credentials"
   * @const
   */
  "client_credentials": "client_credentials",
  /**
   * value: "refresh_token"
   * @const
   */
  "refresh_token": "refresh_token",
  /**
   * value: "urn:ietf:params:oauth:grant-type:uma-ticket"
   * @const
   */
  "urn:ietf:params:oauth:grant-type:uma-ticket": "urn:ietf:params:oauth:grant-type:uma-ticket",
  /**
   * value: "urn:ietf:params:oauth:grant-type:token-exchange"
   * @const
   */
  "urn:ietf:params:oauth:grant-type:token-exchange": "urn:ietf:params:oauth:grant-type:token-exchange",
  /**
   * value: "urn:openid:params:grant-type:ciba"
   * @const
   */
  "urn:openid:params:grant-type:ciba": "urn:openid:params:grant-type:ciba",
  /**
   * value: "urn:ietf:params:oauth:grant-type:device_code"
   * @const
   */
  "urn:ietf:params:oauth:grant-type:device_code": "urn:ietf:params:oauth:grant-type:device_code"
};

/**
 * Allowed values for the <code>grantTypesSupportedByDynamicRegistration</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['GrantTypesSupportedByDynamicRegistrationEnum'] = {
  /**
   * value: "none"
   * @const
   */
  "none": "none",
  /**
   * value: "authorization_code"
   * @const
   */
  "authorization_code": "authorization_code",
  /**
   * value: "implicit"
   * @const
   */
  "implicit": "implicit",
  /**
   * value: "password"
   * @const
   */
  "password": "password",
  /**
   * value: "client_credentials"
   * @const
   */
  "client_credentials": "client_credentials",
  /**
   * value: "refresh_token"
   * @const
   */
  "refresh_token": "refresh_token",
  /**
   * value: "urn:ietf:params:oauth:grant-type:uma-ticket"
   * @const
   */
  "urn:ietf:params:oauth:grant-type:uma-ticket": "urn:ietf:params:oauth:grant-type:uma-ticket",
  /**
   * value: "urn:ietf:params:oauth:grant-type:token-exchange"
   * @const
   */
  "urn:ietf:params:oauth:grant-type:token-exchange": "urn:ietf:params:oauth:grant-type:token-exchange",
  /**
   * value: "urn:openid:params:grant-type:ciba"
   * @const
   */
  "urn:openid:params:grant-type:ciba": "urn:openid:params:grant-type:ciba",
  /**
   * value: "urn:ietf:params:oauth:grant-type:device_code"
   * @const
   */
  "urn:ietf:params:oauth:grant-type:device_code": "urn:ietf:params:oauth:grant-type:device_code"
};

/**
 * Allowed values for the <code>webKeysStorage</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['WebKeysStorageEnum'] = {
  /**
   * value: "keystore"
   * @const
   */
  "keystore": "keystore",
  /**
   * value: "pkcs11"
   * @const
   */
  "pkcs11": "pkcs11"
};

/**
 * Allowed values for the <code>keySelectionStrategy</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['KeySelectionStrategyEnum'] = {
  /**
   * value: "OLDER"
   * @const
   */
  "OLDER": "OLDER",
  /**
   * value: "NEWER"
   * @const
   */
  "NEWER": "NEWER",
  /**
   * value: "FIRST"
   * @const
   */
  "FIRST": "FIRST"
};

/**
 * Allowed values for the <code>errorHandlingMethod</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['ErrorHandlingMethodEnum'] = {
  /**
   * value: "internal"
   * @const
   */
  "internal": "internal",
  /**
   * value: "remote"
   * @const
   */
  "remote": "remote"
};

/**
 * Allowed values for the <code>featureFlags</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['FeatureFlagsEnum'] = {
  /**
   * value: "UNKNOWN"
   * @const
   */
  "UNKNOWN": "UNKNOWN",
  /**
   * value: "HEALTH_CHECK"
   * @const
   */
  "HEALTH_CHECK": "HEALTH_CHECK",
  /**
   * value: "USERINFO"
   * @const
   */
  "USERINFO": "USERINFO",
  /**
   * value: "CLIENTINFO"
   * @const
   */
  "CLIENTINFO": "CLIENTINFO",
  /**
   * value: "ID_GENERATION"
   * @const
   */
  "ID_GENERATION": "ID_GENERATION",
  /**
   * value: "REGISTRATION"
   * @const
   */
  "REGISTRATION": "REGISTRATION",
  /**
   * value: "INTROSPECTION"
   * @const
   */
  "INTROSPECTION": "INTROSPECTION",
  /**
   * value: "REVOKE_TOKEN"
   * @const
   */
  "REVOKE_TOKEN": "REVOKE_TOKEN",
  /**
   * value: "REVOKE_SESSION"
   * @const
   */
  "REVOKE_SESSION": "REVOKE_SESSION",
  /**
   * value: "GLOBAL_TOKEN_REVOCATION"
   * @const
   */
  "GLOBAL_TOKEN_REVOCATION": "GLOBAL_TOKEN_REVOCATION",
  /**
   * value: "STATUS_LIST"
   * @const
   */
  "STATUS_LIST": "STATUS_LIST",
  /**
   * value: "ACTIVE_SESSION"
   * @const
   */
  "ACTIVE_SESSION": "ACTIVE_SESSION",
  /**
   * value: "END_SESSION"
   * @const
   */
  "END_SESSION": "END_SESSION",
  /**
   * value: "STATUS_SESSION"
   * @const
   */
  "STATUS_SESSION": "STATUS_SESSION",
  /**
   * value: "JANS_CONFIGURATION"
   * @const
   */
  "JANS_CONFIGURATION": "JANS_CONFIGURATION",
  /**
   * value: "CIBA"
   * @const
   */
  "CIBA": "CIBA",
  /**
   * value: "UMA"
   * @const
   */
  "UMA": "UMA",
  /**
   * value: "U2F"
   * @const
   */
  "U2F": "U2F",
  /**
   * value: "DEVICE_AUTHZ"
   * @const
   */
  "DEVICE_AUTHZ": "DEVICE_AUTHZ",
  /**
   * value: "METRIC"
   * @const
   */
  "METRIC": "METRIC",
  /**
   * value: "STAT"
   * @const
   */
  "STAT": "STAT",
  /**
   * value: "PAR"
   * @const
   */
  "PAR": "PAR",
  /**
   * value: "ACCESS_EVALUATION"
   * @const
   */
  "ACCESS_EVALUATION": "ACCESS_EVALUATION",
  /**
   * value: "SSA"
   * @const
   */
  "SSA": "SSA"
};

/**
 * Allowed values for the <code>allResponseTypesSupported</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['AllResponseTypesSupportedEnum'] = {
  /**
   * value: "code"
   * @const
   */
  "code": "code",
  /**
   * value: "token"
   * @const
   */
  "token": "token",
  /**
   * value: "id_token"
   * @const
   */
  "id_token": "id_token"
};
var _default = exports["default"] = AppConfiguration;