"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _IdentityProvider = _interopRequireDefault(require("../model/IdentityProvider"));
var _IdentityProviderPagedResult = _interopRequireDefault(require("../model/IdentityProviderPagedResult"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* SAMLIdentityBroker service.
* @module api/SAMLIdentityBrokerApi
* @version OAS Version
*/
var SAMLIdentityBrokerApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new SAMLIdentityBrokerApi. 
  * @alias module:api/SAMLIdentityBrokerApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function SAMLIdentityBrokerApi(apiClient) {
    _classCallCheck(this, SAMLIdentityBrokerApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteSamlIdentityProvider operation.
   * @callback module:api/SAMLIdentityBrokerApi~deleteSamlIdentityProviderCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Delete SAML Identity Provider
   * Delete SAML Identity Provider
   * @param {String} inum Unique identifier
   * @param {module:api/SAMLIdentityBrokerApi~deleteSamlIdentityProviderCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(SAMLIdentityBrokerApi, [{
    key: "deleteSamlIdentityProvider",
    value: function deleteSamlIdentityProvider(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteSamlIdentityProvider");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/kc/saml/idp/{inum}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getSamlIdentityProvider operation.
     * @callback module:api/SAMLIdentityBrokerApi~getSamlIdentityProviderCallback
     * @param {String} error Error message, if any.
     * @param {module:model/IdentityProviderPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieves SAML Identity Provider
     * Retrieves SAML Identity Provider
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/SAMLIdentityBrokerApi~getSamlIdentityProviderCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/IdentityProviderPagedResult}
     */
  }, {
    key: "getSamlIdentityProvider",
    value: function getSamlIdentityProvider(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _IdentityProviderPagedResult["default"];
      return this.apiClient.callApi('/kc/saml/idp', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getSamlIdentityProviderByInum operation.
     * @callback module:api/SAMLIdentityBrokerApi~getSamlIdentityProviderByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/IdentityProvider} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get SAML Identity Provider by Inum
     * Get SAML Identity Provider by Inum
     * @param {String} inum Unique identifier
     * @param {module:api/SAMLIdentityBrokerApi~getSamlIdentityProviderByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/IdentityProvider}
     */
  }, {
    key: "getSamlIdentityProviderByInum",
    value: function getSamlIdentityProviderByInum(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getSamlIdentityProviderByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _IdentityProvider["default"];
      return this.apiClient.callApi('/kc/saml/idp/{inum}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getSamlSpMetadataJson operation.
     * @callback module:api/SAMLIdentityBrokerApi~getSamlSpMetadataJsonCallback
     * @param {String} error Error message, if any.
     * @param {Object} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get SAML SP Metadata as Json
     * Get SAML SP Metadata as Json
     * @param {String} inum Unique identifier
     * @param {module:api/SAMLIdentityBrokerApi~getSamlSpMetadataJsonCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Object}
     */
  }, {
    key: "getSamlSpMetadataJson",
    value: function getSamlSpMetadataJson(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getSamlSpMetadataJson");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = Object;
      return this.apiClient.callApi('/kc/saml/idp/sp-metadata/{inum}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getSamlSpMetadataUrl operation.
     * @callback module:api/SAMLIdentityBrokerApi~getSamlSpMetadataUrlCallback
     * @param {String} error Error message, if any.
     * @param {String} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get SAML SP Metadata Endpoint URL
     * Get SAML SP Metadata Endpoint URL
     * @param {String} inum Unique identifier
     * @param {module:api/SAMLIdentityBrokerApi~getSamlSpMetadataUrlCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link String}
     */
  }, {
    key: "getSamlSpMetadataUrl",
    value: function getSamlSpMetadataUrl(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getSamlSpMetadataUrl");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = 'String';
      return this.apiClient.callApi('/kc/saml/idp/sp-metadata-file/{inum}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postSamlIdentityProvider operation.
     * @callback module:api/SAMLIdentityBrokerApi~postSamlIdentityProviderCallback
     * @param {String} error Error message, if any.
     * @param {module:model/IdentityProvider} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create SAML Identity Provider
     * Create SAML Identity Provider
     * @param {module:model/IdentityProvider} identityProvider 
     * @param {File} metaDataFile 
     * @param {module:api/SAMLIdentityBrokerApi~postSamlIdentityProviderCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/IdentityProvider}
     */
  }, {
    key: "postSamlIdentityProvider",
    value: function postSamlIdentityProvider(identityProvider, metaDataFile, callback) {
      var postBody = null;
      // verify the required parameter 'identityProvider' is set
      if (identityProvider === undefined || identityProvider === null) {
        throw new Error("Missing the required parameter 'identityProvider' when calling postSamlIdentityProvider");
      }
      // verify the required parameter 'metaDataFile' is set
      if (metaDataFile === undefined || metaDataFile === null) {
        throw new Error("Missing the required parameter 'metaDataFile' when calling postSamlIdentityProvider");
      }
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {
        'identityProvider': identityProvider,
        'metaDataFile': metaDataFile
      };
      var authNames = ['oauth2'];
      var contentTypes = ['multipart/form-data'];
      var accepts = ['application/json-patch+json'];
      var returnType = _IdentityProvider["default"];
      return this.apiClient.callApi('/kc/saml/idp/upload', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putSamlIdentityProvider operation.
     * @callback module:api/SAMLIdentityBrokerApi~putSamlIdentityProviderCallback
     * @param {String} error Error message, if any.
     * @param {module:model/IdentityProvider} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update SAML Identity Provider
     * Update SAML Identity Provider
     * @param {module:model/IdentityProvider} identityProvider 
     * @param {File} metaDataFile 
     * @param {module:api/SAMLIdentityBrokerApi~putSamlIdentityProviderCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/IdentityProvider}
     */
  }, {
    key: "putSamlIdentityProvider",
    value: function putSamlIdentityProvider(identityProvider, metaDataFile, callback) {
      var postBody = null;
      // verify the required parameter 'identityProvider' is set
      if (identityProvider === undefined || identityProvider === null) {
        throw new Error("Missing the required parameter 'identityProvider' when calling putSamlIdentityProvider");
      }
      // verify the required parameter 'metaDataFile' is set
      if (metaDataFile === undefined || metaDataFile === null) {
        throw new Error("Missing the required parameter 'metaDataFile' when calling putSamlIdentityProvider");
      }
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {
        'identityProvider': identityProvider,
        'metaDataFile': metaDataFile
      };
      var authNames = ['oauth2'];
      var contentTypes = ['multipart/form-data'];
      var accepts = ['application/json-patch+json'];
      var returnType = _IdentityProvider["default"];
      return this.apiClient.callApi('/kc/saml/idp/upload', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();