"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _ApiError = _interopRequireDefault(require("../model/ApiError"));
var _AssetDirMapping = _interopRequireDefault(require("../model/AssetDirMapping"));
var _Document = _interopRequireDefault(require("../model/Document"));
var _DocumentPagedResult = _interopRequireDefault(require("../model/DocumentPagedResult"));
var _PagedResult = _interopRequireDefault(require("../model/PagedResult"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* JansAssets service.
* @module api/JansAssetsApi
* @version OAS Version
*/
var JansAssetsApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new JansAssetsApi. 
  * @alias module:api/JansAssetsApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function JansAssetsApi(apiClient) {
    _classCallCheck(this, JansAssetsApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteAsset operation.
   * @callback module:api/JansAssetsApi~deleteAssetCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Delete an asset
   * Delete an asset
   * @param {String} inum Asset identifier
   * @param {module:api/JansAssetsApi~deleteAssetCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(JansAssetsApi, [{
    key: "deleteAsset",
    value: function deleteAsset(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteAsset");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = null;
      return this.apiClient.callApi('/api/v1/jans-assets/{inum}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAllAssets operation.
     * @callback module:api/JansAssetsApi~getAllAssetsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/DocumentPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets all Jans assets.
     * Gets all Jans assets.
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {String} opts.status Status of the attribute (default to 'all')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/JansAssetsApi~getAllAssetsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/DocumentPagedResult}
     */
  }, {
    key: "getAllAssets",
    value: function getAllAssets(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'status': opts['status'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _DocumentPagedResult["default"];
      return this.apiClient.callApi('/api/v1/jans-assets', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAssetByInum operation.
     * @callback module:api/JansAssetsApi~getAssetByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets an asset by inum - unique identifier
     * Gets an asset by inum - unique identifier
     * @param {String} inum Asset Inum
     * @param {module:api/JansAssetsApi~getAssetByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
  }, {
    key: "getAssetByInum",
    value: function getAssetByInum(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getAssetByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _PagedResult["default"];
      return this.apiClient.callApi('/api/v1/jans-assets/{inum}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAssetByName operation.
     * @callback module:api/JansAssetsApi~getAssetByNameCallback
     * @param {String} error Error message, if any.
     * @param {module:model/DocumentPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch asset by name
     * Fetch asset by name.
     * @param {String} name Asset Name
     * @param {module:api/JansAssetsApi~getAssetByNameCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/DocumentPagedResult}
     */
  }, {
    key: "getAssetByName",
    value: function getAssetByName(name, callback) {
      var postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling getAssetByName");
      }
      var pathParams = {
        'name': name
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _DocumentPagedResult["default"];
      return this.apiClient.callApi('/api/v1/jans-assets/name/{name}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAssetDirMapping operation.
     * @callback module:api/JansAssetsApi~getAssetDirMappingCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/AssetDirMapping>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get valid asset types
     * Get valid asset types
     * @param {module:api/JansAssetsApi~getAssetDirMappingCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/AssetDirMapping>}
     */
  }, {
    key: "getAssetDirMapping",
    value: function getAssetDirMapping(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_AssetDirMapping["default"]];
      return this.apiClient.callApi('/api/v1/jans-assets/asset-dir-mapping', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAssetServices operation.
     * @callback module:api/JansAssetsApi~getAssetServicesCallback
     * @param {String} error Error message, if any.
     * @param {Array.<String>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets asset services
     * Gets asset services
     * @param {module:api/JansAssetsApi~getAssetServicesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<String>}
     */
  }, {
    key: "getAssetServices",
    value: function getAssetServices(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = ['String'];
      return this.apiClient.callApi('/api/v1/jans-assets/services', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getAssetTypes operation.
     * @callback module:api/JansAssetsApi~getAssetTypesCallback
     * @param {String} error Error message, if any.
     * @param {Array.<String>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get valid asset types
     * Get valid asset types
     * @param {module:api/JansAssetsApi~getAssetTypesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<String>}
     */
  }, {
    key: "getAssetTypes",
    value: function getAssetTypes(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = ['String'];
      return this.apiClient.callApi('/api/v1/jans-assets/asset-type', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the loadServiceAsset operation.
     * @callback module:api/JansAssetsApi~loadServiceAssetCallback
     * @param {String} error Error message, if any.
     * @param {String} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Load assets on server for a service
     * Load assets on server for a service
     * @param {String} serviceName Service Name
     * @param {module:api/JansAssetsApi~loadServiceAssetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link String}
     */
  }, {
    key: "loadServiceAsset",
    value: function loadServiceAsset(serviceName, callback) {
      var postBody = null;
      // verify the required parameter 'serviceName' is set
      if (serviceName === undefined || serviceName === null) {
        throw new Error("Missing the required parameter 'serviceName' when calling loadServiceAsset");
      }
      var pathParams = {
        'service-name': serviceName
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['multipart/form-data'];
      var accepts = ['application/json'];
      var returnType = 'String';
      return this.apiClient.callApi('/api/v1/jans-assets/service/{service-name}', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postNewAsset operation.
     * @callback module:api/JansAssetsApi~postNewAssetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Document} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Upload new asset
     * Upload new asset
     * @param {module:model/Document} document 
     * @param {File} assetFile 
     * @param {module:api/JansAssetsApi~postNewAssetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Document}
     */
  }, {
    key: "postNewAsset",
    value: function postNewAsset(document, assetFile, callback) {
      var postBody = null;
      // verify the required parameter 'document' is set
      if (document === undefined || document === null) {
        throw new Error("Missing the required parameter 'document' when calling postNewAsset");
      }
      // verify the required parameter 'assetFile' is set
      if (assetFile === undefined || assetFile === null) {
        throw new Error("Missing the required parameter 'assetFile' when calling postNewAsset");
      }
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {
        'document': document,
        'assetFile': assetFile
      };
      var authNames = ['oauth2'];
      var contentTypes = ['multipart/form-data'];
      var accepts = ['application/json-patch+json', 'application/json'];
      var returnType = _Document["default"];
      return this.apiClient.callApi('/api/v1/jans-assets/upload', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putAsset operation.
     * @callback module:api/JansAssetsApi~putAssetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Document} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update existing asset
     * Update existing asset
     * @param {module:model/Document} document 
     * @param {File} assetFile 
     * @param {module:api/JansAssetsApi~putAssetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Document}
     */
  }, {
    key: "putAsset",
    value: function putAsset(document, assetFile, callback) {
      var postBody = null;
      // verify the required parameter 'document' is set
      if (document === undefined || document === null) {
        throw new Error("Missing the required parameter 'document' when calling putAsset");
      }
      // verify the required parameter 'assetFile' is set
      if (assetFile === undefined || assetFile === null) {
        throw new Error("Missing the required parameter 'assetFile' when calling putAsset");
      }
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {
        'document': document,
        'assetFile': assetFile
      };
      var authNames = ['oauth2'];
      var contentTypes = ['multipart/form-data'];
      var accepts = ['application/json-patch+json', 'application/json'];
      var returnType = _Document["default"];
      return this.apiClient.callApi('/api/v1/jans-assets/upload', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();