"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _HealthStatus = _interopRequireDefault(require("../model/HealthStatus"));
var _StatsData = _interopRequireDefault(require("../model/StatsData"));
var _Status = _interopRequireDefault(require("../model/Status"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* HealthCheck service.
* @module api/HealthCheckApi
* @version OAS Version
*/
var HealthCheckApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new HealthCheckApi. 
  * @alias module:api/HealthCheckApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function HealthCheckApi(apiClient) {
    _classCallCheck(this, HealthCheckApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the getAppVersion operation.
   * @callback module:api/HealthCheckApi~getAppVersionCallback
   * @param {String} error Error message, if any.
   * @param {Object} data The data returned by the service call.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Returns application version
   * Returns application version
   * @param {Object} opts Optional parameters
   * @param {String} opts.artifact artifact name for which version is requied else ALL (default to 'all')
   * @param {module:api/HealthCheckApi~getAppVersionCallback} callback The callback function, accepting three arguments: error, data, response
   * data is of type: {@link Object}
   */
  return _createClass(HealthCheckApi, [{
    key: "getAppVersion",
    value: function getAppVersion(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'artifact': opts['artifact']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = Object;
      return this.apiClient.callApi('/api/v1/health/app-version', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getConfigHealth operation.
     * @callback module:api/HealthCheckApi~getConfigHealthCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/HealthStatus>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns application health status
     * Returns application health status
     * @param {module:api/HealthCheckApi~getConfigHealthCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/HealthStatus>}
     */
  }, {
    key: "getConfigHealth",
    value: function getConfigHealth(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = [];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_HealthStatus["default"]];
      return this.apiClient.callApi('/api/v1/health', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getConfigHealthLive operation.
     * @callback module:api/HealthCheckApi~getConfigHealthLiveCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Status} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns application liveness status
     * Returns application liveness status
     * @param {module:api/HealthCheckApi~getConfigHealthLiveCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Status}
     */
  }, {
    key: "getConfigHealthLive",
    value: function getConfigHealthLive(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = [];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _Status["default"];
      return this.apiClient.callApi('/api/v1/health/live', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getConfigHealthReady operation.
     * @callback module:api/HealthCheckApi~getConfigHealthReadyCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Status} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns application readiness status
     * Returns application readiness status
     * @param {module:api/HealthCheckApi~getConfigHealthReadyCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Status}
     */
  }, {
    key: "getConfigHealthReady",
    value: function getConfigHealthReady(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = [];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _Status["default"];
      return this.apiClient.callApi('/api/v1/health/ready', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getServerStat operation.
     * @callback module:api/HealthCheckApi~getServerStatCallback
     * @param {String} error Error message, if any.
     * @param {module:model/StatsData} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns application server status
     * Returns application server status
     * @param {module:api/HealthCheckApi~getServerStatCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/StatsData}
     */
  }, {
    key: "getServerStat",
    value: function getServerStat(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = [];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _StatsData["default"];
      return this.apiClient.callApi('/api/v1/health/server-stat', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getServiceStatus operation.
     * @callback module:api/HealthCheckApi~getServiceStatusCallback
     * @param {String} error Error message, if any.
     * @param {Object} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch service status
     * Fetch service status
     * @param {Object} opts Optional parameters
     * @param {String} opts.service Service name to check status (default to 'all')
     * @param {module:api/HealthCheckApi~getServiceStatusCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Object}
     */
  }, {
    key: "getServiceStatus",
    value: function getServiceStatus(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'service': opts['service']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = Object;
      return this.apiClient.callApi('/api/v1/health/service-status', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();