"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _ApiError = _interopRequireDefault(require("../model/ApiError"));
var _Fido2RegistrationEntry = _interopRequireDefault(require("../model/Fido2RegistrationEntry"));
var _Fido2RegistrationEntryPagedResult = _interopRequireDefault(require("../model/Fido2RegistrationEntryPagedResult"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* Fido2Registration service.
* @module api/Fido2RegistrationApi
* @version OAS Version
*/
var Fido2RegistrationApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new Fido2RegistrationApi. 
  * @alias module:api/Fido2RegistrationApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function Fido2RegistrationApi(apiClient) {
    _classCallCheck(this, Fido2RegistrationApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteFido2Data operation.
   * @callback module:api/Fido2RegistrationApi~deleteFido2DataCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Delete Fido2 Device Data based on device UID
   * Delete Fido2 Device Data based on device UID
   * @param {String} jansId Fido2Registration Unique identifier.
   * @param {module:api/Fido2RegistrationApi~deleteFido2DataCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(Fido2RegistrationApi, [{
    key: "deleteFido2Data",
    value: function deleteFido2Data(jansId, callback) {
      var postBody = null;
      // verify the required parameter 'jansId' is set
      if (jansId === undefined || jansId === null) {
        throw new Error("Missing the required parameter 'jansId' when calling deleteFido2Data");
      }
      var pathParams = {
        'jansId': jansId
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = null;
      return this.apiClient.callApi('/fido2/registration/id/{jansId}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getFido2ById operation.
     * @callback module:api/Fido2RegistrationApi~getFido2ByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Fido2RegistrationEntry} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch Fido2RegistrationEntry by Id.
     * Fetch Fido2RegistrationEntry by Id.
     * @param {String} jansId Fido2Registration identifier
     * @param {module:api/Fido2RegistrationApi~getFido2ByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Fido2RegistrationEntry}
     */
  }, {
    key: "getFido2ById",
    value: function getFido2ById(jansId, callback) {
      var postBody = null;
      // verify the required parameter 'jansId' is set
      if (jansId === undefined || jansId === null) {
        throw new Error("Missing the required parameter 'jansId' when calling getFido2ById");
      }
      var pathParams = {
        'jansId': jansId
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _Fido2RegistrationEntry["default"];
      return this.apiClient.callApi('/fido2/registration/id/{jansId}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getRegistrationEntriesFido2 operation.
     * @callback module:api/Fido2RegistrationApi~getRegistrationEntriesFido2Callback
     * @param {String} error Error message, if any.
     * @param {module:model/Fido2RegistrationEntryPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get details of connected FIDO2 devices registered to user
     * Get details of connected FIDO2 devices registered to user
     * @param {String} username User name
     * @param {module:api/Fido2RegistrationApi~getRegistrationEntriesFido2Callback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Fido2RegistrationEntryPagedResult}
     */
  }, {
    key: "getRegistrationEntriesFido2",
    value: function getRegistrationEntriesFido2(username, callback) {
      var postBody = null;
      // verify the required parameter 'username' is set
      if (username === undefined || username === null) {
        throw new Error("Missing the required parameter 'username' when calling getRegistrationEntriesFido2");
      }
      var pathParams = {
        'username': username
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _Fido2RegistrationEntryPagedResult["default"];
      return this.apiClient.callApi('/fido2/registration/entries/{username}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the searchFido2RegistrationData operation.
     * @callback module:api/Fido2RegistrationApi~searchFido2RegistrationDataCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Fido2RegistrationEntryPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a list of Fido2RegistrationEntry.
     * Get a list of Fido2RegistrationEntry.
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Data whose value will be used to order the returned response (default to 'jansId')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/Fido2RegistrationApi~searchFido2RegistrationDataCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Fido2RegistrationEntryPagedResult}
     */
  }, {
    key: "searchFido2RegistrationData",
    value: function searchFido2RegistrationData(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _Fido2RegistrationEntryPagedResult["default"];
      return this.apiClient.callApi('/fido2/registration', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();