"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _ApiError = _interopRequireDefault(require("../model/ApiError"));
var _CustomUser = _interopRequireDefault(require("../model/CustomUser"));
var _UserPagedResult = _interopRequireDefault(require("../model/UserPagedResult"));
var _UserPatchRequest = _interopRequireDefault(require("../model/UserPatchRequest"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* ConfigurationUserManagement service.
* @module api/ConfigurationUserManagementApi
* @version OAS Version
*/
var ConfigurationUserManagementApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new ConfigurationUserManagementApi. 
  * @alias module:api/ConfigurationUserManagementApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function ConfigurationUserManagementApi(apiClient) {
    _classCallCheck(this, ConfigurationUserManagementApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteUser operation.
   * @callback module:api/ConfigurationUserManagementApi~deleteUserCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Delete User
   * Delete User
   * @param {String} inum User identifier
   * @param {module:api/ConfigurationUserManagementApi~deleteUserCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(ConfigurationUserManagementApi, [{
    key: "deleteUser",
    value: function deleteUser(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteUser");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/mgt/configuser/{inum}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getUser operation.
     * @callback module:api/ConfigurationUserManagementApi~getUserCallback
     * @param {String} error Error message, if any.
     * @param {module:model/UserPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of users
     * Gets list of users
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/ConfigurationUserManagementApi~getUserCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/UserPagedResult}
     */
  }, {
    key: "getUser",
    value: function getUser(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _UserPagedResult["default"];
      return this.apiClient.callApi('/mgt/configuser', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getUserByInum operation.
     * @callback module:api/ConfigurationUserManagementApi~getUserByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomUser} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get User by Inum
     * Get User by Inum
     * @param {String} inum User identifier
     * @param {module:api/ConfigurationUserManagementApi~getUserByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomUser}
     */
  }, {
    key: "getUserByInum",
    value: function getUserByInum(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getUserByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _CustomUser["default"];
      return this.apiClient.callApi('/mgt/configuser/{inum}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the patchUserByInum operation.
     * @callback module:api/ConfigurationUserManagementApi~patchUserByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomUser} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patch user properties by Inum
     * Patch user properties by Inum
     * @param {String} inum User identifier
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.removeNonLDAPAttributes Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request. (default to true)
     * @param {module:model/UserPatchRequest} opts.userPatchRequest UserPatchRequest
     * @param {module:api/ConfigurationUserManagementApi~patchUserByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomUser}
     */
  }, {
    key: "patchUserByInum",
    value: function patchUserByInum(inum, opts, callback) {
      opts = opts || {};
      var postBody = opts['userPatchRequest'];
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling patchUserByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {
        'removeNonLDAPAttributes': opts['removeNonLDAPAttributes']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _CustomUser["default"];
      return this.apiClient.callApi('/mgt/configuser/{inum}', 'PATCH', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postUser operation.
     * @callback module:api/ConfigurationUserManagementApi~postUserCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomUser} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new User
     * Create new User
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.removeNonLDAPAttributes Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request. (default to true)
     * @param {module:model/CustomUser} opts.customUser User object
     * @param {module:api/ConfigurationUserManagementApi~postUserCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomUser}
     */
  }, {
    key: "postUser",
    value: function postUser(opts, callback) {
      opts = opts || {};
      var postBody = opts['customUser'];
      var pathParams = {};
      var queryParams = {
        'removeNonLDAPAttributes': opts['removeNonLDAPAttributes']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _CustomUser["default"];
      return this.apiClient.callApi('/mgt/configuser', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putUser operation.
     * @callback module:api/ConfigurationUserManagementApi~putUserCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomUser} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update User
     * Update User
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.removeNonLDAPAttributes Boolean flag to indicate if attributes to be removed for non-LDAP DB. Default value is true, indicating non-LDAP attributes will be removed from request. (default to true)
     * @param {module:model/CustomUser} opts.customUser User object
     * @param {module:api/ConfigurationUserManagementApi~putUserCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomUser}
     */
  }, {
    key: "putUser",
    value: function putUser(opts, callback) {
      opts = opts || {};
      var postBody = opts['customUser'];
      var pathParams = {};
      var queryParams = {
        'removeNonLDAPAttributes': opts['removeNonLDAPAttributes']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _CustomUser["default"];
      return this.apiClient.callApi('/mgt/configuser', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();