"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* AgamaConfiguration service.
* @module api/AgamaConfigurationApi
* @version OAS Version
*/
var AgamaConfigurationApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new AgamaConfigurationApi. 
  * @alias module:api/AgamaConfigurationApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function AgamaConfigurationApi(apiClient) {
    _classCallCheck(this, AgamaConfigurationApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the agamaSyntaxCheck operation.
   * @callback module:api/AgamaConfigurationApi~agamaSyntaxCheckCallback
   * @param {String} error Error message, if any.
   * @param {String} data The data returned by the service call.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Determine if the text passed is valid Agama code
   * Determine if the text passed is valid Agama code
   * @param {String} qname Agama Flow name
   * @param {Object} opts Optional parameters
   * @param {String} opts.body 
   * @param {module:api/AgamaConfigurationApi~agamaSyntaxCheckCallback} callback The callback function, accepting three arguments: error, data, response
   * data is of type: {@link String}
   */
  return _createClass(AgamaConfigurationApi, [{
    key: "agamaSyntaxCheck",
    value: function agamaSyntaxCheck(qname, opts, callback) {
      opts = opts || {};
      var postBody = opts['body'];
      // verify the required parameter 'qname' is set
      if (qname === undefined || qname === null) {
        throw new Error("Missing the required parameter 'qname' when calling agamaSyntaxCheck");
      }
      var pathParams = {
        'qname': qname
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['text/plain'];
      var accepts = ['application/json'];
      var returnType = 'String';
      return this.apiClient.callApi('/api/v1/agama/syntax-check/{qname}', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();