/// <reference types="react" />
import { Placement } from '@floating-ui/react-dom';
import { Align } from '../../types';
export type ReferenceElement = HTMLElement | null;
export interface OverlayOptions {
    align?: Align;
    dropup?: boolean;
    flip?: boolean;
    positionFixed?: boolean;
}
export declare function getMiddleware(props: Pick<OverlayOptions, 'align' | 'flip'>): {
    options?: any;
    name: string;
    fn: (state: {
        x: number;
        y: number;
        initialPlacement: Placement;
        placement: Placement;
        strategy: import("@floating-ui/utils").Strategy;
        middlewareData: import("@floating-ui/core").MiddlewareData;
        rects: import("@floating-ui/utils").ElementRects;
        platform: import("@floating-ui/core").Platform;
        elements: import("@floating-ui/dom").Elements;
    }) => import("@floating-ui/core").MiddlewareReturn | Promise<import("@floating-ui/core").MiddlewareReturn>;
}[];
export declare function getPlacement(props: Pick<OverlayOptions, 'align' | 'dropup'>): Placement;
export declare function useOverlay(referenceElement: ReferenceElement, options: OverlayOptions): {
    innerRef: import("react").Dispatch<import("react").SetStateAction<ReferenceElement>>;
    style: import("react").CSSProperties;
};
export default useOverlay;
