import PropTypes from 'prop-types';
import { CSSProperties, ReactElement, RefCallback } from 'react';
import { OverlayOptions, ReferenceElement } from './useOverlay';
export interface OverlayRenderProps {
    innerRef: RefCallback<HTMLElement>;
    style: CSSProperties;
}
export interface OverlayProps extends OverlayOptions {
    children: (props: OverlayRenderProps) => ReactElement | null;
    isMenuShown: boolean;
    referenceElement: ReferenceElement;
}
declare const Overlay: {
    ({ referenceElement, isMenuShown, ...props }: OverlayProps): ReactElement<any, string | import("react").JSXElementConstructor<any>> | null;
    propTypes: {
        align: PropTypes.Requireable<"justify" | "left" | "right">;
        children: PropTypes.Validator<(...args: any[]) => any>;
        dropup: PropTypes.Requireable<boolean>;
        flip: PropTypes.Requireable<boolean>;
        isMenuShown: PropTypes.Requireable<boolean>;
        positionFixed: PropTypes.Requireable<boolean>;
        referenceElement: PropTypes.Requireable<Element>;
    };
};
export default Overlay;
