"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _Context = require("./Context");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { "default": e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n["default"] = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2["default"])(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var inputPropKeys = ['activeIndex', 'disabled', 'id', 'inputRef', 'isFocused', 'isMenuShown', 'multiple', 'onBlur', 'onChange', 'onClick', 'onFocus', 'onKeyDown', 'placeholder'];
var propKeys = ['activeIndex', 'hideMenu', 'isMenuShown', 'labelKey', 'onClear', 'onHide', 'onRemove', 'results', 'selected', 'text', 'toggleMenu'];
var contextKeys = ['activeIndex', 'id', 'initialItem', 'inputNode', 'onActiveItemChange', 'onAdd', 'onInitialItemChange', 'onMenuItemClick', 'setItem'];
var TypeaheadManager = function TypeaheadManager(props) {
  var allowNew = props.allowNew,
    children = props.children,
    initialItem = props.initialItem,
    isMenuShown = props.isMenuShown,
    onAdd = props.onAdd,
    onInitialItemChange = props.onInitialItemChange,
    onKeyDown = props.onKeyDown,
    onMenuToggle = props.onMenuToggle,
    results = props.results,
    selectHint = props.selectHint;
  var hintText = (0, _utils.getHintText)(props);
  (0, _react.useEffect)(function () {
    // Clear the initial item when there are no results.
    if (!(allowNew || results.length)) {
      onInitialItemChange();
    }
  });
  var isInitialRender = (0, _react.useRef)(true);
  (0, _react.useEffect)(function () {
    if (isInitialRender.current) {
      isInitialRender.current = false;
      return;
    }
    onMenuToggle(isMenuShown);
  }, [isMenuShown, onMenuToggle]);
  var handleKeyDown = function handleKeyDown(e) {
    onKeyDown(e);
    if (!initialItem) {
      return;
    }
    var addOnlyResult = e.key === 'Enter' && (0, _utils.getIsOnlyResult)(props);
    var shouldSelectHint = hintText && (0, _utils.defaultSelectHint)(e, selectHint);
    if (addOnlyResult || shouldSelectHint) {
      onAdd(initialItem);
    }
  };
  var childProps = _objectSpread(_objectSpread({}, (0, _utils.pick)(props, propKeys)), {}, {
    getInputProps: (0, _utils.getInputProps)(_objectSpread(_objectSpread({}, (0, _utils.pick)(props, inputPropKeys)), {}, {
      onKeyDown: handleKeyDown,
      value: (0, _utils.getInputText)(props)
    }))
  });
  var contextValue = _objectSpread(_objectSpread({}, (0, _utils.pick)(props, contextKeys)), {}, {
    hintText: hintText,
    isOnlyResult: (0, _utils.getIsOnlyResult)(props)
  });
  return /*#__PURE__*/_react["default"].createElement(_Context.TypeaheadContext.Provider, {
    value: contextValue
  }, (0, _utils.isFunction)(children) ? children(childProps) : children);
};
var _default = exports["default"] = TypeaheadManager;